#include <QApplication>
#include <qextserialport.h>

#include "defs.h"
#include "MainWindow.h"
#include "MessageWindow.h"
#include "Murphytalk/PinyinImpl.h"

int main(int argc, char *argv[])
{
	int exec;

	QApplication app(argc, argv);
    //redirect debug messages to the MessageWindow dialog
    const QApplication::Type type = app.type();

    app.setAutoSipEnabled(true);
	qInstallMsgHandler(MessageWindow::AppendMsgWrapper);

	MainWindow mainWindow(APP_TITLE);
    mainWindow.setFont(QFont("unifont", 14, QFont::Normal));
    if (QApplication::GuiServer == type)
        {
            QPinyinImpl::installInputMethod();
        }

	mainWindow.show();
	exec = app.exec();

    if (QApplication::GuiServer == type)
            QPinyinImpl::releaseInputMethod();

	return exec;
}

