#include "threadcheck.h"
#include <QApplication>

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/input.h>

ThreadCheck::ThreadCheck(QObject* parent)
    :QThread(parent)
    ,m_bRun(true)
    ,m_pParent(parent)
{
    InitUserKey();

}

ThreadCheck::~ThreadCheck()
{
    ::close(m_nDeviceId);
}

void ThreadCheck::run()
{
    struct input_event t;
    while(m_bRun)
    {
        if(read(m_nDeviceId,&t,sizeof(t))==sizeof(t))
        {
            if(t.type==EV_KEY)          //获取的是按键消息
                if(t.value==0 || t.value==1)    //返回值是1或者0
                {
                    printf("key %d %s\n",t.code,(t.value)?"Pressed":"Released");     //1表按下，0表弹起
                    KeyEvent * pEvent = new KeyEvent((QEvent::Type)(QEvent::User+1), t.code, t.value);
                    QApplication::postEvent(m_pParent, pEvent);
                }
        }
        sleep(1);
    }

}

void ThreadCheck::InitUserKey()
{
    m_nDeviceId = open("/dev/event0", O_RDONLY);
     if(m_nDeviceId <= 0)
     {
            printf("open /dev/event0 device error!\n");
            return ;
     }
}
