#include "dtled.h"
#include "QPictureButton.h"
#include <QPixmap>
#include <fcntl.h>
#include <sys/ioctl.h>
//#include <unistd.h>


#define DEVICE_NAME	"/dev/vib"

DTLed::DTLed(QWidget *parent)
    : QWidget(parent)
    ,m_pTimerFlow(NULL)
{
    m_SizeScreen = QApplication::desktop()->size();
    this->setWindowTitle("LED Test");

    this->setAutoFillBackground(true);
    QPalette palette;
    palette.setColor(this->backgroundRole(), Qt::black);
    this->setPalette(palette);

    QWidget * pVlayoutWg = new QWidget(this);
    pVlayoutWg->setAutoFillBackground(true);
    palette.setColor(this->backgroundRole(), Qt::gray);
    pVlayoutWg->setPalette(palette);

    pVlayoutWg->setGeometry(0, 0, m_SizeScreen.width()/2, m_SizeScreen.height());
    QGridLayout * pGLayout = new QGridLayout(pVlayoutWg);
    pGLayout->setAlignment(Qt::AlignCenter);
    pGLayout->setSpacing(30);
    pGLayout->setMargin(30);


    m_pBtnLed1 = new QPictureButton(pVlayoutWg);
    m_pBtnLed1->setMinimumHeight(100);
    m_pBtnLed1->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
    m_pBtnLed1->setCheckable(true);
    m_pBtnLed1->SetPictureNormal(QPixmap(":/images/off.png"));
    m_pBtnLed1->SetPicturePushed(QPixmap(":/images/on.png"));
    QObject::connect(m_pBtnLed1, SIGNAL(clicked()), this, SLOT(OnBtnClickedLed1()));

    m_pBtnLed2 = new QPictureButton(pVlayoutWg);
    m_pBtnLed2->setMinimumHeight(100);
    m_pBtnLed2->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
    m_pBtnLed2->setCheckable(true);
    m_pBtnLed2->SetPictureNormal(QPixmap(":/images/off.png"));
    m_pBtnLed2->SetPicturePushed(QPixmap(":/images/on.png"));
    QObject::connect(m_pBtnLed2, SIGNAL(clicked()), this, SLOT(OnBtnClickedLed1()));

    m_pBtnLed3 = new QPictureButton(pVlayoutWg);
    m_pBtnLed3->setMinimumHeight(100);
    m_pBtnLed3->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
    m_pBtnLed3->setCheckable(true);
    m_pBtnLed3->SetPictureNormal(QPixmap(":/images/off.png"));
    m_pBtnLed3->SetPicturePushed(QPixmap(":/images/on.png"));
    QObject::connect(m_pBtnLed3, SIGNAL(clicked()), this, SLOT(OnBtnClickedLed1()));

    m_pBtnLed4 = new QPictureButton(pVlayoutWg);
    m_pBtnLed4->setMinimumHeight(100);
    m_pBtnLed4->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
    m_pBtnLed4->setCheckable(true);
    m_pBtnLed4->SetPictureNormal(QPixmap(":/images/off.png"));
    m_pBtnLed4->SetPicturePushed(QPixmap(":/images/on.png"));
    QObject::connect(m_pBtnLed4, SIGNAL(clicked()), this, SLOT(OnBtnClickedLed1()));

    QLabel * pLbl = new QLabel(QString::fromUtf8("***LED测试程序***"), pVlayoutWg);
    pLbl->setAlignment(Qt::AlignCenter);
    palette.setColor(QPalette::WindowText,Qt::white);
    pLbl->setPalette(palette);

    QPictureButton * m_pBtnClose = new QPictureButton(pVlayoutWg);
    //m_pBtnClose->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
    m_pBtnClose->setText("退出");
    m_pBtnClose->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnClose->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnClose, SIGNAL(clicked()), this, SLOT(close()));

    pGLayout->addWidget(pLbl, 0, 0, 3, 4);
    pGLayout->addWidget(m_pBtnLed1, 3, 0, 1, 1);
    pGLayout->addWidget(m_pBtnLed2, 3, 1, 1, 1);
    pGLayout->addWidget(m_pBtnLed3, 3, 2, 1, 1);
    pGLayout->addWidget(m_pBtnLed4, 3, 3, 1, 1);
    pGLayout->addWidget(m_pBtnClose, 4, 1, 1, 2);



    QWidget * pRightWidget = new QWidget(this);

    pRightWidget->setGeometry(m_SizeScreen.width()/2, 0, m_SizeScreen.width()/2, m_SizeScreen.height());
    QVBoxLayout * pRightGLayout = new QVBoxLayout(pRightWidget);
    pRightGLayout->setAlignment(Qt::AlignCenter);
    pRightGLayout->setSpacing(30);
    pRightGLayout->setMargin(30);

    m_pBtnLedOn = new QPictureButton(pRightWidget);
    //m_pBtnLedOn->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
   // m_pBtnLedOn->setMaximumWidth(100);
    m_pBtnLedOn->setText("All On");
    m_pBtnLedOn->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnLedOn->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnLedOn, SIGNAL(clicked()), this, SLOT(OnBtnClickedLedOn()));

    m_pBtnLedOff = new QPictureButton(pRightWidget);
    //m_pBtnLedOff->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
    m_pBtnLedOff->setText("All Off");
    m_pBtnLedOff->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnLedOff->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnLedOff, SIGNAL(clicked()), this, SLOT(OnBtnClickedLedOff()));

    m_pBtnLedFlow = new QPictureButton(pRightWidget);
    //m_pBtnLedFlow->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed );
    m_pBtnLedFlow->setText("Flow LED");
    m_pBtnLedFlow->SetPictureNormal(QPixmap(":/images/button_radio_normal.png"));
    m_pBtnLedFlow->SetPicturePushed(QPixmap(":/images/button_radio_pressed.png"));
    QObject::connect(m_pBtnLedFlow, SIGNAL(clicked()), this, SLOT(OnBtnClickedLedFlow()));


     QLabel * m_pLblLogo = new QLabel(pRightWidget);
     m_pLblLogo->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed );
     m_pLblLogo->setGeometry(m_SizeScreen.width()/2 +40,(m_SizeScreen.height() - 186)/2,250,186);
     QPixmap pix;
     pix.load(QObject::tr(":/images/x210iilogo.png"));
     m_pLblLogo->setPixmap(pix);

     pRightGLayout->addWidget(m_pLblLogo, 30);
     pRightGLayout->addWidget(m_pBtnLedOn);
     pRightGLayout->addWidget(m_pBtnLedOff);
     pRightGLayout->addWidget(m_pBtnLedFlow);

     pVlayoutWg->show();
     pRightWidget->show();

     qDebug() << "led TEST";
     m_nDeviceId  = open(DEVICE_NAME, 0);//打开设备
     if(m_nDeviceId == -1)
     {
             printf("open device %s error \n",DEVICE_NAME);
      }
      else
      {
             printf("open device %s ok! \n",DEVICE_NAME);
      }
}

DTLed::~DTLed()
{
    ::close(m_nDeviceId);
}
/*
int DTLed::SetLed(int id, bool show)
{
    int fd = open(DEVICE_NAME, 0);//打开设备
    if(fd == -1)
    {
            printf("open device %s error \n",DEVICE_NAME);
            return 0;
     }
     else
     {
            printf("open device %s ok! \n",DEVICE_NAME);
     }

    if(show)
     {
        ioctl(fd,LED_ON);
     }
     else
     {
         ioctl(fd,LED_OFF);
      }
       ::close(fd);
}
*/
int DTLed::SetLed()
{
    int value = 0xF0;
    value |=  m_pBtnLed1->isChecked() << 0;
    value |=  m_pBtnLed2->isChecked() << 1;
    value |=  m_pBtnLed3->isChecked() << 2;
    value |=  m_pBtnLed4->isChecked() << 3;





      ioctl(m_nDeviceId,value);


}

void DTLed::OnBtnClickedLed1()
{

    QPictureButton * pBtn = qobject_cast<QPictureButton*>(sender());
    if(!pBtn)
        return;

    int id = 0;
    if(pBtn == m_pBtnLed1)
    {
         qDebug() << "led1";
         id = 0;
    }
    else if(pBtn == m_pBtnLed2)
    {
         qDebug() << "led2";
         id = 1;
    }
    else if(pBtn == m_pBtnLed3)
    {
         qDebug() << "led3";
         id = 2;
    }
    else if(pBtn == m_pBtnLed4)
    {
         qDebug() << "led4";
         id = 3;
    }

    SetLed();
}

void DTLed::OnBtnClickedLedOn()
{
    if(m_pTimerFlow && m_pTimerFlow->isActive())
    {
        m_pTimerFlow->stop();
    }
    qDebug() << "OnBtnClickedLedOn";
    m_pBtnLed1->setChecked(true);
    m_pBtnLed2->setChecked(true);
    m_pBtnLed3->setChecked(true);
    m_pBtnLed4->setChecked(true);

    SetLed();
    qDebug() << "OnBtnClickedLedOn111";
}

void DTLed::OnBtnClickedLedOff()
{
    if(m_pTimerFlow && m_pTimerFlow->isActive())
    {
        m_pTimerFlow->stop();
    }
    qDebug() << "OnBtnClickedLedOff";
    m_pBtnLed1->setChecked(false);
    m_pBtnLed2->setChecked(false);
    m_pBtnLed3->setChecked(false);
    m_pBtnLed4->setChecked(false);
    SetLed();
}

void DTLed::OnBtnClickedLedFlow()
{
    qDebug() << "OnBtnClickedLedFlow";
    StartFLow();

}

void DTLed::StartFLow()
{
    if(!m_pTimerFlow)
    {
        m_pTimerFlow = new QTimer(this);
        QObject::connect(m_pTimerFlow, SIGNAL(timeout()), this, SLOT(OnTimerFlow()));
    }
    if(!m_pTimerFlow->isActive())
    {
        OnBtnClickedLedOff();
        m_pTimerFlow->start(400);
    }
}

void DTLed::OnTimerFlow()
{
    static QPictureButton * pBtnOld = NULL;
    static int idOld = 0;
    if(pBtnOld)
    {
        pBtnOld->setChecked(false);
        if(pBtnOld == m_pBtnLed1)
        {
            pBtnOld = m_pBtnLed2;
            idOld = 1;
        }
        else if(pBtnOld == m_pBtnLed2)
        {
            pBtnOld = m_pBtnLed3;
            idOld = 2;
        }
        else if(pBtnOld == m_pBtnLed3)
        {
            pBtnOld = m_pBtnLed4;
            idOld = 3;
        }
        else if(pBtnOld == m_pBtnLed4)
        {
            pBtnOld = m_pBtnLed1;
            idOld = 0;
        }
        pBtnOld->setChecked(true);

    }
    else
    {
        pBtnOld = m_pBtnLed1;
        pBtnOld->setChecked(true);

    }
    SetLed();
}

/*
void DTLed::paintEvent( QPaintEvent* event)
{
    QPainter painter(this);
    painter.setPen(QColor(200, 200, 200));
    painter.drawLine(QPoint(m_SizeScreen.width()/2,10), QPoint(m_SizeScreen.width()/2,m_SizeScreen.height() - 20));
    painter.end();
}
*/
