/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfNavigatorContentProvider;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;

public class TmfEditorLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        IFile file = ResourceUtil.getFile((IEditorInput)anInput);
        if (file != null) {
            try {
                String traceTypeId = file.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                if (traceTypeId == null) {
                    return StructuredSelection.EMPTY;
                }
                TmfNavigatorContentProvider ncp = new TmfNavigatorContentProvider();
                ncp.getChildren(file.getProject());
                TmfProjectElement project = TmfProjectRegistry.getProject(file.getProject());
                if (traceTypeId.equals(TmfExperiment.class.getCanonicalName())) {
                    for (ITmfProjectModelElement projectElement : project.getExperimentsFolder().getChildren()) {
                        if (!projectElement.getName().equals(file.getParent().getName())) continue;
                        return new StructuredSelection((Object)projectElement);
                    }
                } else if (traceTypeId.equals(TmfTrace.class.getCanonicalName())) {
                    for (ITmfProjectModelElement projectElement : project.getTracesFolder().getChildren()) {
                        if (!projectElement.getName().equals(file.getParent().getName())) continue;
                        return new StructuredSelection((Object)projectElement);
                    }
                } else {
                    for (ITmfProjectModelElement projectElement : project.getTracesFolder().getChildren()) {
                        if (!projectElement.getResource().equals((Object)file)) continue;
                        return new StructuredSelection((Object)projectElement);
                    }
                }
            }
            catch (CoreException coreException) {
                return StructuredSelection.EMPTY;
            }
        }
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        IFile file = null;
        if (aSelection.getFirstElement() instanceof TmfTraceElement) {
            TmfTraceElement traceElement = (TmfTraceElement)aSelection.getFirstElement();
            traceElement = traceElement.getElementUnderTraceFolder();
            file = traceElement.getBookmarksFile();
        } else if (aSelection.getFirstElement() instanceof TmfExperimentElement) {
            TmfExperimentElement experimentElement = (TmfExperimentElement)aSelection.getFirstElement();
            file = experimentElement.getBookmarksFile();
        }
        if (file != null) {
            FileEditorInput tmpInput = new FileEditorInput(file);
            IEditorPart localEditor = aPage.findEditor((IEditorInput)tmpInput);
            if (localEditor != null) {
                aPage.bringToTop((IWorkbenchPart)localEditor);
            } else {
                IEditorReference[] refs;
                IEditorReference[] iEditorReferenceArray = refs = aPage.getEditorReferences();
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    try {
                        if (editorReference.getEditorInput().equals(tmpInput) && (localEditor = editorReference.getEditor(true)) != null) {
                            aPage.bringToTop((IWorkbenchPart)localEditor);
                        }
                    }
                    catch (PartInitException partInitException) {}
                    ++n2;
                }
            }
        }
    }
}

