/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng2.kernel.core.trace;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.internal.lttng2.kernel.core.stateprovider.LttngKernelStateProvider;
import org.eclipse.linuxtools.lttng2.kernel.core.trace.Messages;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.statesystem.TmfStateSystemFactory;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;

public class LttngKernelTrace
extends CtfTmfTrace {
    public static final String HISTORY_TREE_FILE_NAME = "stateHistory.ht";
    public static final String STATE_ID = "org.eclipse.linuxtools.lttng2.kernel";

    public IStatus validate(IProject project, String path) {
        CTFTrace temp;
        try {
            temp = new CTFTrace(path);
        }
        catch (CTFReaderException e) {
            Status validStatus = new Status(4, "org.eclipse.linuxtools.lttng2.core", e.toString(), (Throwable)e);
            return validStatus;
        }
        catch (NullPointerException e) {
            Status validStatus = new Status(4, "org.eclipse.linuxtools.lttng2.core", e.toString(), (Throwable)e);
            return validStatus;
        }
        String dom = (String)temp.getEnvironment().get("domain");
        temp.dispose();
        if (dom != null && dom.equals("\"kernel\"")) {
            return Status.OK_STATUS;
        }
        Status validStatus = new Status(4, "org.eclipse.linuxtools.lttng2.core", Messages.LttngKernelTrace_DomainError);
        return validStatus;
    }

    protected void buildStateSystem() throws TmfTraceException {
        super.buildStateSystem();
        String directory = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)this);
        File htFile = new File(String.valueOf(directory) + HISTORY_TREE_FILE_NAME);
        LttngKernelStateProvider htInput = new LttngKernelStateProvider(this);
        ITmfStateSystem ss = TmfStateSystemFactory.newFullHistory((File)htFile, (ITmfStateProvider)htInput, (boolean)false);
        this.fStateSystems.put(STATE_ID, ss);
    }
}

