/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.core.ISourceRange;

public class SourceRange
implements ISourceRange {
    public static final ISourceRange UNKNOWN_RANGE = new SourceRange(-1, 0);
    private final int offset;
    private final int length;

    public SourceRange(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public SourceRange(ISourceRange range) {
        this(range.getOffset(), range.getLength());
    }

    public SourceRange(ISourceNode node) {
        this.offset = node.start();
        this.length = node.end() - this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        int end = this.getOffset() + this.getLength() - 1;
        return "[" + this.getOffset() + ".." + end + "]";
    }

    public int hashCode() {
        return this.length ^ this.offset;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ISourceRange) {
            ISourceRange other = (ISourceRange)obj;
            return other.getOffset() == this.offset && other.getLength() == this.length;
        }
        return false;
    }

    public static boolean isAvailable(ISourceRange range) {
        return range != null && range != UNKNOWN_RANGE;
    }

    public static ISourceRange offset(ISourceRange range, int offset) {
        if (SourceRange.isAvailable(range)) {
            return new SourceRange(range.getOffset() + offset, range.getLength());
        }
        return range;
    }
}

