/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http.ntlm;

import java.io.IOException;
import sun.misc.BASE64Decoder;
import sun.net.www.protocol.http.ntlm.B64Encoder;

public class NTLMAuthSequence {
    private String username;
    private String password;
    private String ntdomain;
    private int state;
    private long crdHandle;
    private long ctxHandle;
    Status status;

    NTLMAuthSequence(String string, String string2, String string3) throws IOException {
        this.username = string;
        this.password = string2;
        this.ntdomain = string3;
        this.status = new Status();
        this.state = 0;
        this.crdHandle = this.getCredentialsHandle(string, string3, string2);
        if (this.crdHandle == 0L) {
            throw new IOException("could not get credentials handle");
        }
    }

    public String getAuthHeader(String string) throws IOException {
        byte[] byArray;
        byte[] byArray2 = null;
        assert (!this.status.sequenceComplete);
        if (string != null) {
            byArray2 = new BASE64Decoder().decodeBuffer(string);
        }
        if ((byArray = this.getNextToken(this.crdHandle, byArray2, this.status)) == null) {
            throw new IOException("Internal authentication error");
        }
        return new B64Encoder().encode(byArray);
    }

    public boolean isComplete() {
        return this.status.sequenceComplete;
    }

    private static native void initFirst(Class<Status> var0);

    private native long getCredentialsHandle(String var1, String var2, String var3);

    private native byte[] getNextToken(long var1, byte[] var3, Status var4);

    static {
        NTLMAuthSequence.initFirst(Status.class);
    }

    class Status {
        boolean sequenceComplete;

        Status() {
        }
    }
}

