/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class BugzillaPeoplePart
extends AbstractTaskEditorPart {
    private static final int COLUMN_MARGIN = 5;

    public BugzillaPeoplePart() {
        this.setPartName(Messages.BugzillaPeoplePart_People);
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute) {
        AbstractAttributeEditor editor = this.createAttributeEditor(attribute);
        if (editor != null) {
            editor.createLabelControl(composite, toolkit);
            GridDataFactory.defaultsFor((Control)editor.getLabelControl()).indent(5, 0).applyTo((Control)editor.getLabelControl());
            editor.createControl(composite, toolkit);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(editor);
            if (attribute.getId().equals(BugzillaAttribute.CC.getKey())) {
                GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(130, 95).applyTo(editor.getControl());
            } else {
                GridDataFactory.fillDefaults().grab(true, false).align(4, 128).hint(130, -1).applyTo(editor.getControl());
            }
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Section section = this.createSection(parent, toolkit, true);
        Composite peopleComposite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 5;
        layout.horizontalSpacing = 10;
        peopleComposite.setLayout((Layout)layout);
        this.addAttribute(peopleComposite, toolkit, this.getTaskData().getRoot().getMappedAttribute("task.common.user.assigned"));
        TaskAttribute assignee = this.getTaskData().getRoot().getAttribute(BugzillaAttribute.SET_DEFAULT_ASSIGNEE.getKey());
        if (assignee != null) {
            this.addAttribute(peopleComposite, toolkit, assignee);
        }
        this.addAttribute(peopleComposite, toolkit, this.getTaskData().getRoot().getMappedAttribute("task.common.user.reporter"));
        String useParam = this.getTaskData().getAttributeMapper().getTaskRepository().getProperty("bugzilla.param.useqacontact");
        if (useParam == null || useParam != null && useParam.equals("true")) {
            this.addAttribute(peopleComposite, toolkit, this.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.QA_CONTACT.getKey()));
        }
        this.addAttribute(peopleComposite, toolkit, this.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.NEWCC.getKey()));
        this.addSelfToCC(peopleComposite);
        TaskAttribute cc = this.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.CC.getKey());
        if (cc != null) {
            this.addAttribute(peopleComposite, toolkit, cc);
            toolkit.createLabel(peopleComposite, "");
            Label label = toolkit.createLabel(peopleComposite, Messages.BugzillaPeoplePart__Select_to_remove_);
            GridDataFactory.fillDefaults().indent(0, 5).align(0x1000000, 0x1000000).applyTo((Control)label);
        }
        toolkit.paintBordersFor(peopleComposite);
        section.setClient((Control)peopleComposite);
        this.setSection(toolkit, section);
    }

    protected void addSelfToCC(Composite composite) {
        TaskRepository repository = this.getTaskEditorPage().getTaskRepository();
        if (repository.getUserName() == null) {
            return;
        }
        TaskAttribute root = this.getTaskData().getRoot();
        TaskAttribute owner = root.getMappedAttribute("task.common.user.assigned");
        if (owner != null && owner.getValue().indexOf(repository.getUserName()) != -1) {
            return;
        }
        TaskAttribute reporter = root.getMappedAttribute("task.common.user.reporter");
        if (reporter != null && reporter.getValue().indexOf(repository.getUserName()) != -1) {
            return;
        }
        TaskAttribute ccAttribute = root.getMappedAttribute("task.common.user.cc");
        if (ccAttribute != null && ccAttribute.getValues().contains(repository.getUserName())) {
            return;
        }
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        TaskAttribute attrAddToCC = this.getTaskData().getRoot().getMappedAttribute("task.common.addselfcc");
        if (attrAddToCC == null) {
            attrAddToCC = BugzillaTaskDataHandler.createAttribute((TaskData)this.getTaskData(), (BugzillaAttribute)BugzillaAttribute.ADDSELFCC);
        }
        this.addAttribute(composite, toolkit, attrAddToCC);
    }
}

