/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import org.eclipse.cdt.internal.autotools.ui.editors.automake.IDirective;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IMakefile;

public abstract class Directive
implements IDirective {
    int endLine;
    int startLine;
    String filename;
    IMakefile makefile;
    Directive parent;

    public Directive(Directive owner) {
        this.parent = owner;
    }

    public Directive(int start, int end) {
        this.setLines(start, end);
    }

    @Override
    public abstract String toString();

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public IDirective getParent() {
        return this.parent;
    }

    public String getFileName() {
        if (this.filename == null && this.parent != null) {
            this.filename = this.parent.getFileName();
        }
        return this.filename;
    }

    @Override
    public IMakefile getMakefile() {
        if (this.makefile == null && this.parent != null) {
            this.makefile = this.parent.getMakefile();
        }
        return this.makefile;
    }

    public void setParent(Directive owner) {
        this.parent = owner;
    }

    public void setStartLine(int lineno) {
        this.startLine = lineno;
    }

    public void setEndLine(int lineno) {
        this.endLine = lineno;
    }

    public void setLines(int start, int end) {
        this.setStartLine(start);
        this.setEndLine(end);
    }

    public void setFilename(String name) {
        this.filename = name;
    }
}

