/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring.reorg;

import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.corext.refactoring.rename.RenameSourceModuleProcessor;
import org.eclipse.dltk.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.reorg.RenameInputWizardPage;
import org.eclipse.dltk.internal.ui.refactoring.reorg.RenameRefactoringWizard;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;

public class RenameSourceModuleWizard
extends RenameRefactoringWizard {
    public RenameSourceModuleWizard(Refactoring refactoring) {
        super(refactoring, RefactoringMessages.RenameCuWizard_defaultPageTitle, RefactoringMessages.RenameCuWizard_inputPage_description, DLTKPluginImages.DESC_WIZBAN_REFACTOR_CU, "");
    }

    protected RefactoringStatus validateNewName(String newName) {
        String fullName = this.getSourceModuleProcessor().isFileExtensionRequired() ? ScriptModelUtil.getRenamedCUName((ISourceModule)this.getSourceModule(), (String)newName) : newName;
        return super.validateNewName(fullName);
    }

    private ISourceModule getSourceModule() {
        return (ISourceModule)this.getSourceModuleProcessor().getElements()[0];
    }

    protected RenameInputWizardPage createInputPage(String message, String initialSetting) {
        return new RenameInputWizardPage(message, this.fPageContextHelpId, true, initialSetting){

            protected RefactoringStatus validateTextField(String text) {
                return RenameSourceModuleWizard.this.validateNewName(text);
            }

            protected String getNewName(INameUpdating nameUpdating) {
                String result = nameUpdating.getNewElementName();
                if (RenameSourceModuleWizard.this.getSourceModuleProcessor().isFileExtensionRequired()) {
                    return RenameSourceModuleProcessor.removeFileNameExtension(result);
                }
                return result;
            }
        };
    }

    private RenameSourceModuleProcessor getSourceModuleProcessor() {
        return (RenameSourceModuleProcessor)((RenameRefactoring)this.getRefactoring()).getProcessor();
    }
}

