/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui;

import java.io.IOException;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.EclipseAuthenticator;
import org.eclipse.egit.ui.EclipseProxySelector;
import org.eclipse.egit.ui.EclipseSshSessionFactory;
import org.eclipse.egit.ui.internal.ConfigurationChecker;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.themes.ITheme;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends AbstractUIPlugin
implements DebugOptionsListener {
    private static Activator plugin;
    private static List<IPropertyChangeListener> propertyChangeListeners;
    public static final String DECORATORS_CHANGED = "org.eclipse.egit.ui.DECORATORS_CHANGED";
    private RepositoryChangeScanner rcs;
    private ResourceRefreshJob refreshJob;
    private ListenerHandle refreshHandle;
    private DebugOptions debugOptions;
    private IWindowListener focusListener;

    static {
        propertyChangeListeners = new ArrayList<IPropertyChangeListener>(5);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public static void handleError(String message, Throwable throwable, boolean show) {
        Activator.handleIssue(4, message, throwable, show);
    }

    public static void handleIssue(int severity, String message, Throwable throwable, boolean show) {
        Status status = new Status(severity, Activator.getPluginId(), message, throwable);
        int style = 1;
        if (show) {
            style |= 2;
        }
        StatusManager.getManager().handle((IStatus)status, style);
    }

    public static void showError(String message, Throwable throwable) {
        Status status = new Status(4, Activator.getPluginId(), message, throwable);
        StatusManager.getManager().handle((IStatus)status, 2);
    }

    public static void showErrorStatus(String message, IStatus status) {
        StatusManager.getManager().handle(status, 2);
    }

    public static ITheme getTheme() {
        return plugin.getWorkbench().getThemeManager().getCurrentTheme();
    }

    public static Font getFont(String id) {
        return Activator.getTheme().getFontRegistry().get(id);
    }

    public static Font getBoldFont(String id) {
        return Activator.getTheme().getFontRegistry().getBold(id);
    }

    public Activator() {
        Activator.setActivator(this);
    }

    private static void setActivator(Activator a) {
        plugin = a;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        ((Dictionary)props).put("listener.symbolic.name", context.getBundle().getSymbolicName());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
        this.setupSSH(context);
        this.setupProxy(context);
        this.setupRepoChangeScanner();
        this.setupRepoIndexRefresh();
        this.setupFocusHandling();
        this.setupCredentialsProvider();
        ConfigurationChecker.checkConfiguration();
    }

    private void setupCredentialsProvider() {
        CredentialsProvider.setDefault((CredentialsProvider)new EGitCredentialsProvider());
    }

    static boolean isActive() {
        final AtomicBoolean ret = new AtomicBoolean();
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display.isDisposed()) {
            return false;
        }
        display.syncExec(new Runnable(){

            public void run() {
                ret.set(display.getActiveShell() != null);
            }
        });
        return ret.get();
    }

    private void setupFocusHandling() {
        this.focusListener = new IWindowListener(){

            public void windowOpened(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowActivated(IWorkbenchWindow window) {
                if (Activator.this.rcs.doReschedule) {
                    Activator.this.rcs.schedule();
                }
                Activator.this.refreshJob.triggerRefresh();
            }
        };
        PlatformUI.getWorkbench().addWindowListener(this.focusListener);
    }

    public void optionsChanged(DebugOptions options) {
        this.debugOptions = options;
        GitTraceLocation.initializeFromOptions(options, this.isDebugging());
    }

    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    private void setupRepoIndexRefresh() {
        this.refreshJob = new ResourceRefreshJob();
        this.refreshHandle = Repository.getGlobalListenerList().addIndexChangedListener((IndexChangedListener)this.refreshJob);
    }

    public static synchronized void addPropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.add(listener);
    }

    public static synchronized void removePropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.remove(listener);
    }

    public static synchronized void broadcastPropertyChange(PropertyChangeEvent event) {
        for (IPropertyChangeListener listener : propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    private void setupRepoChangeScanner() {
        this.rcs = new RepositoryChangeScanner();
        this.rcs.setSystem(true);
        this.rcs.schedule(10000L);
    }

    private void setupSSH(BundleContext context) {
        ServiceReference ssh = context.getServiceReference(IJSchService.class.getName());
        if (ssh != null) {
            SshSessionFactory.setInstance((SshSessionFactory)new EclipseSshSessionFactory((IJSchService)context.getService(ssh)));
        }
    }

    private void setupProxy(BundleContext context) {
        ServiceReference proxy = context.getServiceReference(IProxyService.class.getName());
        if (proxy != null) {
            ProxySelector.setDefault(new EclipseProxySelector((IProxyService)context.getService(proxy)));
            Authenticator.setDefault(new EclipseAuthenticator((IProxyService)context.getService(proxy)));
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.refreshHandle != null) {
            this.refreshHandle.remove();
            this.refreshHandle = null;
        }
        if (this.focusListener != null) {
            PlatformUI.getWorkbench().removeWindowListener(this.focusListener);
            this.focusListener = null;
        }
        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Trying to cancel " + this.rcs.getName() + " job");
        }
        this.rcs.setReschedule(false);
        this.rcs.cancel();
        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Trying to cancel " + this.refreshJob.getName() + " job");
        }
        this.refreshJob.cancel();
        this.rcs.join();
        this.refreshJob.join();
        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Jobs terminated");
        }
        super.stop(context);
        plugin = null;
    }

    public static void logError(String message, Throwable e) {
        Activator.handleError(message, e, false);
    }

    public static void error(String message, Throwable e) {
        Activator.handleError(message, e, false);
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, Activator.getPluginId(), message, throwable);
    }

    public static IStatus createErrorStatus(String message) {
        return new Status(4, Activator.getPluginId(), message);
    }

    public RepositoryUtil getRepositoryUtil() {
        return org.eclipse.egit.core.Activator.getDefault().getRepositoryUtil();
    }

    static class RepositoryChangeScanner
    extends Job {
        private static final long REPO_SCAN_INTERVAL = 10000L;
        private volatile boolean doReschedule = true;

        RepositoryChangeScanner() {
            super(UIText.Activator_repoScanJobName);
        }

        void setReschedule(boolean reschedule) {
            this.doReschedule = reschedule;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Repository[] repos = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache().getAllRepositories();
            if (repos.length == 0) {
                return Status.OK_STATUS;
            }
            if (Activator.getDefault().getPreferenceStore().getBoolean("refesh_only_when_active") && !Activator.isActive()) {
                monitor.done();
                if (this.doReschedule) {
                    this.schedule(10000L);
                }
                return Status.OK_STATUS;
            }
            monitor.beginTask(UIText.Activator_scanningRepositories, repos.length);
            try {
                try {
                    Repository[] repositoryArray = repos;
                    int n = repos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Repository repo = repositoryArray[n2];
                        if (monitor.isCanceled()) {
                            break;
                        }
                        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Scanning " + repo + " for changes");
                        }
                        repo.scanForRepoChanges();
                        monitor.worked(1);
                        ++n2;
                    }
                }
                catch (IOException e) {
                    if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Stopped rescheduling " + this.getName() + "job");
                    }
                    IStatus iStatus = Activator.createErrorStatus(UIText.Activator_scanError, e);
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Rescheduling " + this.getName() + " job");
            }
            if (this.doReschedule) {
                this.schedule(10000L);
            }
            return Status.OK_STATUS;
        }
    }

    static class ResourceRefreshJob
    extends Job
    implements IndexChangedListener {
        private Set<IProject> projectsToScan = new LinkedHashSet<IProject>();
        private Set<Repository> repositoriesChanged = new HashSet<Repository>();

        ResourceRefreshJob() {
            super(UIText.Activator_refreshJobName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            monitor.beginTask(UIText.Activator_refreshingProjects, projects.length);
            while (this.projectsToScan.size() > 0) {
                IProject p;
                Set<IProject> set = this.projectsToScan;
                synchronized (set) {
                    if (this.projectsToScan.size() == 0) {
                        break;
                    }
                    Iterator<IProject> i = this.projectsToScan.iterator();
                    p = i.next();
                    i.remove();
                }
                ISchedulingRule rule = p.getWorkspace().getRuleFactory().refreshRule((IResource)p);
                try {
                    try {
                        ResourceRefreshJob.getJobManager().beginRule(rule, monitor);
                        if (!p.exists()) continue;
                        p.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        Activator.handleError(UIText.Activator_refreshFailed, e, false);
                        Status status = new Status(4, Activator.getPluginId(), e.getMessage());
                        ResourceRefreshJob.getJobManager().endRule(rule);
                        return status;
                    }
                }
                finally {
                    ResourceRefreshJob.getJobManager().endRule(rule);
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        public void onIndexChanged(IndexChangedEvent e) {
            if (Activator.getDefault().getPreferenceStore().getBoolean("refesh_on_index_change")) {
                this.mayTriggerRefresh((RepositoryEvent)e);
            }
        }

        private void mayTriggerRefresh(RepositoryEvent e) {
            this.repositoriesChanged.add(e.getRepository());
            if (!Activator.getDefault().getPreferenceStore().getBoolean("refesh_only_when_active") || Activator.isActive()) {
                this.triggerRefresh();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void triggerRefresh() {
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Triggered refresh");
            }
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            HashSet<IProject> toRefresh = new HashSet<IProject>();
            Set<Repository> set = this.repositoriesChanged;
            synchronized (set) {
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p = iProjectArray[n2];
                    RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)p);
                    if (mapping != null && this.repositoriesChanged.contains(mapping.getRepository())) {
                        toRefresh.add(p);
                    }
                    ++n2;
                }
                this.repositoriesChanged.clear();
            }
            set = this.projectsToScan;
            synchronized (set) {
                this.projectsToScan.addAll(toRefresh);
            }
            if (this.projectsToScan.size() > 0) {
                this.schedule();
            }
        }
    }
}

