/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PropertyManager {
    private static final String NODE_NAME = "properties";
    private static PropertyManager fInstance;
    private LoaddedInfo fLoaddedInfo;

    private PropertyManager() {
    }

    public static PropertyManager getInstance() {
        if (fInstance == null) {
            fInstance = new PropertyManager();
        }
        return fInstance;
    }

    protected void setProperty(IConfiguration cfg, IBuildObject bo, String prop, String value) {
        if (((Configuration)cfg).isPreference()) {
            return;
        }
        Properties props = this.getProperties(cfg, bo);
        if (props != null) {
            props.setProperty(prop, value);
        }
    }

    protected String getProperty(IConfiguration cfg, IBuildObject bo, String prop) {
        if (((Configuration)cfg).isPreference()) {
            return null;
        }
        Properties props = this.getProperties(cfg, bo);
        if (props != null) {
            return props.getProperty(prop);
        }
        return null;
    }

    protected Properties getProperties(IConfiguration cfg, IBuildObject bo) {
        return this.loadProperties(cfg, bo);
    }

    private LoaddedInfo getLoaddedInfo() {
        return this.fLoaddedInfo;
    }

    private synchronized void setLoaddedInfo(LoaddedInfo info) {
        this.fLoaddedInfo = info;
    }

    protected Map<String, Object> getLoaddedData(IConfiguration cfg) {
        LoaddedInfo info = this.getLoaddedInfo();
        if (info == null) {
            return null;
        }
        if (!info.cfgMatch(cfg)) {
            return null;
        }
        return info.getProperties();
    }

    protected synchronized void clearLoaddedData(IConfiguration cfg) {
        if (((Configuration)cfg).isPreference()) {
            return;
        }
        LoaddedInfo info = this.getLoaddedInfo();
        if (info == null) {
            return;
        }
        if (info.cfgMatch(cfg)) {
            this.setLoaddedInfo(null);
        }
    }

    private static IProject getProject(IConfiguration cfg) {
        IResource rc = cfg.getOwner();
        return rc != null ? rc.getProject() : null;
    }

    protected Properties loadProperties(IConfiguration cfg, IBuildObject bo) {
        Map<String, Object> map = this.getData(cfg);
        return this.getPropsFromData(map, bo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getPropsFromData(Map<String, Object> data, IBuildObject bo) {
        Map<String, Object> map = data;
        synchronized (map) {
            Object oVal = data.get(bo.getId());
            Properties props = null;
            if (oVal instanceof String) {
                props = this.stringToProps((String)oVal);
                data.put(bo.getId(), props);
            } else if (oVal instanceof Properties) {
                props = (Properties)oVal;
            }
            if (props == null) {
                props = new Properties();
                data.put(bo.getId(), props);
            }
            return props;
        }
    }

    protected void storeData(IConfiguration cfg) {
        Map<String, Object> map = this.getLoaddedData(cfg);
        if (map != null) {
            this.storeData(cfg, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties mapToProps(Map<String, Object> map) {
        Properties props = null;
        if (map != null) {
            Map<String, Object> map2 = map;
            synchronized (map2) {
                if (map.size() > 0) {
                    props = new Properties();
                    Set<Map.Entry<String, Object>> entrySet = map.entrySet();
                    for (Map.Entry<String, Object> entry : entrySet) {
                        String key = entry.getKey();
                        String value = null;
                        Object oVal = entry.getValue();
                        if (oVal instanceof Properties) {
                            value = this.propsToString((Properties)oVal);
                        } else if (oVal instanceof String) {
                            value = (String)oVal;
                        }
                        if (key == null || value == null) continue;
                        props.setProperty(key, value);
                    }
                }
            }
        }
        return props;
    }

    protected String propsToString(Properties props) {
        if (props == null || props.size() == 0) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            props.store(stream, null);
        }
        catch (IOException iOException) {}
        byte[] bytes = stream.toByteArray();
        String value = null;
        try {
            value = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            value = new String(bytes);
        }
        String sep = System.getProperty("line.separator");
        while (value.charAt(0) == '#') {
            value = value.substring(value.indexOf(sep) + sep.length());
        }
        return value;
    }

    protected Properties stringToProps(String str) {
        Properties props = null;
        if (str != null) {
            byte[] bytes;
            props = new Properties();
            try {
                bytes = str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = str.getBytes();
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            try {
                props.load(stream);
            }
            catch (IOException iOException) {
                props = null;
            }
        }
        return props;
    }

    protected void storeData(IConfiguration cfg, Map<String, Object> map) {
        String str = null;
        Properties props = this.mapToProps(map);
        str = this.propsToString(props);
        this.storeString(cfg, str);
    }

    protected void storeString(IConfiguration cfg, String str) {
        Preferences prefs = this.getNode(cfg.getManagedProject());
        if (prefs != null) {
            if (str != null) {
                prefs.put(cfg.getId(), str);
            } else {
                prefs.remove(cfg.getId());
            }
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    protected String loadString(IConfiguration cfg) {
        String str = null;
        Preferences prefs = this.getNode(cfg.getManagedProject());
        if (prefs != null) {
            str = prefs.get(cfg.getId(), null);
        }
        return str;
    }

    protected Preferences getNode(IManagedProject mProject) {
        return this.getInstNode(mProject);
    }

    protected Preferences getProjNode(IManagedProject mProject) {
        IProject project = mProject.getOwner().getProject();
        if (project == null || !project.exists() || !project.isOpen()) {
            return null;
        }
        IEclipsePreferences prefs = new ProjectScope(project).getNode(ManagedBuilderCorePlugin.getUniqueIdentifier());
        if (prefs != null) {
            return prefs.node(NODE_NAME);
        }
        return null;
    }

    protected Preferences getInstNode(IManagedProject mProject) {
        IEclipsePreferences prefs = new InstanceScope().getNode(ManagedBuilderCorePlugin.getUniqueIdentifier());
        if (prefs != null && (prefs = prefs.node(NODE_NAME)) != null) {
            prefs = prefs.node(mProject.getId());
        }
        return prefs;
    }

    protected Map<String, Object> getData(IConfiguration cfg) {
        Map<String, Object> map = this.getLoaddedData(cfg);
        if (map == null) {
            map = this.loadData(cfg);
            this.setLoaddedData(cfg, map);
        }
        return map;
    }

    protected Map<String, Object> loadData(IConfiguration cfg) {
        Map<String, Object> map = null;
        String str = this.loadString(cfg);
        Properties props = this.stringToProps(str);
        map = this.propsToMap(props);
        if (map == null) {
            map = new LinkedHashMap<String, Object>();
        }
        return map;
    }

    protected Map<String, Object> propsToMap(Properties props) {
        if (props != null) {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(props);
            return map;
        }
        return null;
    }

    private static IConfiguration getConfigurationFromId(IProject project, String id) {
        IManagedProject mProj;
        if (project == null || id == null) {
            return null;
        }
        IManagedBuildInfo bInfo = ManagedBuildManager.getBuildInfo((IResource)project, false);
        IConfiguration cfg = null;
        if (bInfo != null && (mProj = bInfo.getManagedProject()) != null) {
            cfg = mProj.getConfiguration(id);
        }
        return cfg;
    }

    protected void setLoaddedData(IConfiguration cfg, Map<String, Object> data) {
        if (cfg.getOwner() == null) {
            return;
        }
        LoaddedInfo info = this.getLoaddedInfo();
        if (info != null) {
            if (info.cfgMatch(cfg)) {
                info = new LoaddedInfo(info.getProject(), info.getConfigurationId(), data);
                this.setLoaddedInfo(info);
                return;
            }
            IConfiguration oldCfg = info.getConfiguration();
            if (oldCfg != null) {
                this.storeData(oldCfg, info.getProperties());
            }
        }
        IProject proj = cfg.getOwner().getProject();
        info = new LoaddedInfo(proj, cfg.getId(), data);
        this.setLoaddedInfo(info);
    }

    public void setProperty(IConfiguration cfg, String key, String value) {
        this.setProperty(cfg, cfg, key, value);
    }

    public void setProperty(IResourceInfo rcInfo, String key, String value) {
        this.setProperty(rcInfo.getParent(), rcInfo, key, value);
    }

    public void setProperty(IToolChain tc, String key, String value) {
        this.setProperty(tc.getParent(), tc, key, value);
    }

    public void setProperty(ITool tool, String key, String value) {
        Configuration cfg = (Configuration)this.getConfiguration(tool);
        if (cfg.isPreference()) {
            return;
        }
        this.setProperty(cfg, tool, key, value);
    }

    public void setProperty(IBuilder builder, String key, String value) {
        this.setProperty(this.getConfiguration(builder), builder, key, value);
    }

    public String getProperty(IConfiguration cfg, String key) {
        return this.getProperty(cfg, cfg, key);
    }

    public String getProperty(IResourceInfo rcInfo, String key) {
        return this.getProperty(rcInfo.getParent(), rcInfo, key);
    }

    public String getProperty(IToolChain tc, String key) {
        return this.getProperty(tc.getParent(), tc, key);
    }

    public String getProperty(ITool tool, String key) {
        return this.getProperty(this.getConfiguration(tool), tool, key);
    }

    public String getProperty(IBuilder builder, String key) {
        return this.getProperty(this.getConfiguration(builder), builder, key);
    }

    public void clearProperties(IManagedProject mProject) {
        if (mProject == null) {
            return;
        }
        IConfiguration[] cfgs = mProject.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            this.clearLoaddedData(cfgs[i]);
            ++i;
        }
        Preferences prefs = this.getNode(mProject);
        if (prefs != null) {
            try {
                Preferences parent = prefs.parent();
                prefs.removeNode();
                if (parent != null) {
                    parent.flush();
                }
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    public void clearProperties(IConfiguration cfg) {
        if (cfg.getOwner() == null) {
            return;
        }
        this.clearLoaddedData(cfg);
        this.storeData(cfg, null);
    }

    private IConfiguration getConfiguration(IBuilder builder) {
        IToolChain tc = builder.getParent();
        if (tc != null) {
            return tc.getParent();
        }
        return null;
    }

    private IConfiguration getConfiguration(ITool tool) {
        IBuildObject p = tool.getParent();
        IConfiguration cfg = null;
        if (p instanceof IToolChain) {
            cfg = ((IToolChain)p).getParent();
        } else if (p instanceof IResourceConfiguration) {
            cfg = ((IResourceConfiguration)p).getParent();
        }
        return cfg;
    }

    public void serialize(IConfiguration cfg) {
        if (cfg.isTemporary() || cfg.getOwner() == null) {
            return;
        }
        this.storeData(cfg);
    }

    public void serialize() {
        LoaddedInfo info = this.getLoaddedInfo();
        IConfiguration cfg = info.getConfiguration();
        if (cfg != null) {
            this.serialize(cfg);
            this.clearLoaddedData(cfg);
        }
    }

    private static class LoaddedInfo {
        private final IProject fProject;
        private final String fCfgId;
        private final Map<String, Object> fCfgPropertyMap;

        LoaddedInfo(IProject project, String cfgId, Map<String, Object> cfgPropertyMap) {
            this.fProject = project;
            this.fCfgId = cfgId;
            this.fCfgPropertyMap = cfgPropertyMap;
        }

        public IConfiguration getConfiguration() {
            return PropertyManager.getConfigurationFromId(this.fProject, this.fCfgId);
        }

        public IProject getProject() {
            return this.fProject;
        }

        public String getConfigurationId() {
            return this.fCfgId;
        }

        public Map<String, Object> getProperties() {
            return this.fCfgPropertyMap;
        }

        public boolean cfgMatch(IConfiguration cfg) {
            if (this.fCfgId == null || this.fProject == null) {
                return false;
            }
            if (!this.fCfgId.equals(cfg.getId())) {
                return false;
            }
            return this.fProject.equals((Object)PropertyManager.getProject(cfg));
        }
    }
}

