/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.NodeFilterImpl;
import com.sun.webpane.webkit.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class TreeWalkerImpl
implements TreeWalker {
    protected final long contextPeer;
    protected final long rootPeer;
    protected final long peer;

    TreeWalkerImpl(long peer, long contextPeer, long rootPeer) {
        this.peer = peer;
        this.contextPeer = contextPeer;
        this.rootPeer = rootPeer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static TreeWalker create(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        return new TreeWalkerImpl(peer, contextPeer, rootPeer);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(TreeWalker arg) {
        return arg == null ? 0L : ((TreeWalkerImpl)arg).getPeer();
    }

    public boolean equals(Object that) {
        return that instanceof TreeWalkerImpl && this.peer == ((TreeWalkerImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static TreeWalker getImpl(long peer, long contextPeer, long rootPeer) {
        return TreeWalkerImpl.create(peer, contextPeer, rootPeer);
    }

    @Override
    public Node getRoot() {
        return NodeImpl.getImpl(TreeWalkerImpl.getRootImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getRootImpl(long var0);

    @Override
    public int getWhatToShow() {
        return TreeWalkerImpl.getWhatToShowImpl(this.getPeer());
    }

    static native int getWhatToShowImpl(long var0);

    @Override
    public NodeFilter getFilter() {
        return NodeFilterImpl.getImpl(TreeWalkerImpl.getFilterImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getFilterImpl(long var0);

    @Override
    public boolean getExpandEntityReferences() {
        return TreeWalkerImpl.getExpandEntityReferencesImpl(this.getPeer());
    }

    static native boolean getExpandEntityReferencesImpl(long var0);

    @Override
    public Node getCurrentNode() {
        return NodeImpl.getImpl(TreeWalkerImpl.getCurrentNodeImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getCurrentNodeImpl(long var0);

    @Override
    public void setCurrentNode(Node value) throws DOMException {
        TreeWalkerImpl.setCurrentNodeImpl(this.getPeer(), NodeImpl.getPeer(value));
    }

    static native void setCurrentNodeImpl(long var0, long var2);

    @Override
    public Node parentNode() {
        return NodeImpl.getImpl(TreeWalkerImpl.parentNodeImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long parentNodeImpl(long var0);

    @Override
    public Node firstChild() {
        return NodeImpl.getImpl(TreeWalkerImpl.firstChildImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long firstChildImpl(long var0);

    @Override
    public Node lastChild() {
        return NodeImpl.getImpl(TreeWalkerImpl.lastChildImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long lastChildImpl(long var0);

    @Override
    public Node previousSibling() {
        return NodeImpl.getImpl(TreeWalkerImpl.previousSiblingImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long previousSiblingImpl(long var0);

    @Override
    public Node nextSibling() {
        return NodeImpl.getImpl(TreeWalkerImpl.nextSiblingImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long nextSiblingImpl(long var0);

    @Override
    public Node previousNode() {
        return NodeImpl.getImpl(TreeWalkerImpl.previousNodeImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long previousNodeImpl(long var0);

    @Override
    public Node nextNode() {
        return NodeImpl.getImpl(TreeWalkerImpl.nextNodeImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long nextNodeImpl(long var0);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            TreeWalkerImpl.dispose(this.peer);
        }
    }
}

