/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.internal.ui.search.CSearchElement;
import org.eclipse.cdt.internal.ui.search.CSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.cdt.internal.ui.search.HidePolymorphicCalls;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.FileEditorInput;

public class CSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private static final String KEY_SHOW_POLYMORPHIC_CALLS = "ShowPolymorphicCalls";
    static final MatchFilter[] ALL_FILTERS = new MatchFilter[]{HidePolymorphicCalls.FILTER};
    static final MatchFilter[] NO_FILTERS = new MatchFilter[0];
    private CSearchQuery query;
    private boolean indexerBusy;

    public CSearchResult(CSearchQuery query) {
        this.query = query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    private String getFileName(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        IPath path = null;
        if (input instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            path = fileInput.getFile().getLocation();
        } else if (input instanceof ExternalEditorInput) {
            ExternalEditorInput extInput = (ExternalEditorInput)input;
            path = extInput.getPath();
        } else if (input instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)input).getStorage();
                path = storage.getFullPath();
            }
            catch (CoreException coreException) {}
        } else if (input instanceof IPathEditorInput) {
            path = ((IPathEditorInput)input).getPath();
        } else {
            ILocationProvider provider = (ILocationProvider)input.getAdapter(ILocationProvider.class);
            if (provider != null) {
                path = provider.getPath((Object)input);
            }
        }
        if (path != null) {
            return path.toOSString();
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        String fileName = this.getFileName(editor);
        if (fileName != null && match instanceof CSearchMatch) {
            Path filePath = new Path(fileName);
            return filePath.equals((Object)IndexLocationFactory.getAbsolutePath((IIndexFileLocation)((CSearchMatch)match).getLocation()));
        }
        return false;
    }

    private Match[] computeContainedMatches(AbstractTextSearchResult result, String filename) throws CoreException {
        Path pfilename = new Path(filename);
        ArrayList<Match> list = new ArrayList<Match>();
        Object[] elements = result.getElements();
        int i = 0;
        while (i < elements.length) {
            if (pfilename.equals((Object)IndexLocationFactory.getAbsolutePath((IIndexFileLocation)((CSearchElement)elements[i]).getLocation()))) {
                Match[] matches = result.getMatches(elements[i]);
                int j = 0;
                while (j < matches.length) {
                    if (matches[j] instanceof CSearchMatch) {
                        list.add(matches[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new Match[list.size()]);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        try {
            String filename = this.getFileName(editor);
            if (filename != null) {
                return this.computeContainedMatches(result, filename);
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return new Match[0];
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        try {
            String filename = file.getLocation().toOSString();
            return this.computeContainedMatches(result, filename);
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            return new Match[0];
        }
    }

    public IFile getFile(Object element) {
        CSearchElement searchElement;
        IIndexFileLocation location;
        if (element instanceof IIndexName) {
            IIndexName name = (IIndexName)element;
            try {
                IIndexFileLocation location2 = name.getFile().getLocation();
                if (location2.getFullPath() != null) {
                    return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(location2.getFullPath()));
                }
            }
            catch (CoreException coreException) {}
        } else if (element instanceof CSearchElement && (location = (searchElement = (CSearchElement)element).getLocation()).getFullPath() != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(location.getFullPath()));
        }
        return null;
    }

    public String getLabel() {
        return this.query.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public void setIndexerBusy(boolean b) {
        this.indexerBusy = b;
    }

    public boolean wasIndexerBusy() {
        return this.indexerBusy;
    }

    public MatchFilter[] getAllMatchFilters() {
        return ALL_FILTERS;
    }

    public MatchFilter[] getActiveMatchFilters() {
        MatchFilter[] result = super.getActiveMatchFilters();
        if (result == null) {
            if (CUIPlugin.getDefault().getDialogSettings().getBoolean(KEY_SHOW_POLYMORPHIC_CALLS)) {
                return ALL_FILTERS;
            }
            return NO_FILTERS;
        }
        return result;
    }

    public void setActiveMatchFilters(MatchFilter[] filters) {
        boolean showPoly = false;
        int i = 0;
        while (i < filters.length) {
            if (filters[i] == HidePolymorphicCalls.FILTER) {
                showPoly = true;
            }
            ++i;
        }
        CUIPlugin.getDefault().getDialogSettings().put(KEY_SHOW_POLYMORPHIC_CALLS, showPoly);
        super.setActiveMatchFilters(filters);
    }
}

