/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeInfo;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class IncludeMap {
    private static final String TAG_CPP_ONLY = "cpp_only";
    private static final String TAG_FORCED_REPLACEMENT = "forced_replacement";
    private static final String TAG_MAPPING = "mapping";
    private static final String TAG_KEY = "key";
    private static final String TAG_VALUE = "value";
    private final boolean forcedReplacement;
    private final boolean cppOnly;
    private final Map<IncludeInfo, List<IncludeInfo>> map;

    public IncludeMap(boolean forcedReplacement, boolean cppOnly) {
        this.forcedReplacement = forcedReplacement;
        this.cppOnly = cppOnly;
        this.map = new HashMap<IncludeInfo, List<IncludeInfo>>();
    }

    public IncludeMap(boolean forcedReplacement, boolean cppOnly, String[] keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("More keys than values");
        }
        this.forcedReplacement = forcedReplacement;
        this.cppOnly = cppOnly;
        this.map = new HashMap<IncludeInfo, List<IncludeInfo>>(keysAndValues.length / 2);
        int i = 0;
        while (i < keysAndValues.length) {
            String key = keysAndValues[i++];
            this.addMapping(key, keysAndValues[i++]);
        }
    }

    public IncludeMap(IncludeMap other) {
        this.forcedReplacement = other.forcedReplacement;
        this.cppOnly = other.cppOnly;
        this.map = new HashMap<IncludeInfo, List<IncludeInfo>>(other.map.size());
        this.addAllMappings(other);
    }

    protected void addMapping(IncludeInfo from, IncludeInfo to) {
        if (from.equals(to)) {
            return;
        }
        List<IncludeInfo> list = this.map.get(from);
        if (list == null) {
            list = new ArrayList<IncludeInfo>(2);
            this.map.put(from, list);
        }
        list.add(to);
    }

    public void addMapping(String from, String to) {
        this.addMapping(new IncludeInfo(from), new IncludeInfo(to));
    }

    public List<IncludeInfo> getMapping(IncludeInfo from) {
        List<IncludeInfo> list = this.map.get(from);
        if (list == null) {
            if (!from.isSystem()) {
                list = this.map.get(new IncludeInfo(from.getName(), true));
            }
            if (list == null) {
                return Collections.emptyList();
            }
        }
        return list;
    }

    public List<IncludeInfo> getMapping(String from) {
        return this.getMapping(new IncludeInfo(from));
    }

    public IncludeInfo getPreferredMapping(IncludeInfo from) {
        List<IncludeInfo> list = this.getMapping(from);
        return list == null ? null : list.get(0);
    }

    public boolean isForcedReplacement() {
        return this.forcedReplacement;
    }

    public boolean isCppOnly() {
        return this.cppOnly;
    }

    public void saveToMemento(IMemento memento) {
        memento.putBoolean(TAG_CPP_ONLY, this.cppOnly);
        memento.putBoolean(TAG_FORCED_REPLACEMENT, this.forcedReplacement);
        for (Map.Entry<IncludeInfo, List<IncludeInfo>> entry : this.map.entrySet()) {
            String key = entry.getKey().toString();
            for (IncludeInfo value : entry.getValue()) {
                IMemento mapping = memento.createChild(TAG_MAPPING);
                mapping.putString(TAG_KEY, key);
                mapping.putString(TAG_VALUE, value.toString());
            }
        }
    }

    public static IncludeMap fromMemento(IMemento memento) {
        Boolean cppOnly = memento.getBoolean(TAG_CPP_ONLY);
        Boolean forcedReplacement = memento.getBoolean(TAG_FORCED_REPLACEMENT);
        IncludeMap includeMap = new IncludeMap(cppOnly, forcedReplacement);
        IMemento[] iMementoArray = memento.getChildren(TAG_MAPPING);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento mapping = iMementoArray[n2];
            includeMap.addMapping(mapping.getString(TAG_KEY), mapping.getString(TAG_VALUE));
            ++n2;
        }
        return includeMap;
    }

    public static IncludeMap fromSerializedMemento(String str) {
        XMLMemento memento;
        StringReader reader = new StringReader(str);
        try {
            memento = XMLMemento.createReadRoot((Reader)reader);
        }
        catch (WorkbenchException workbenchException) {
            return null;
        }
        return IncludeMap.fromMemento((IMemento)memento);
    }

    public void addAllMappings(IncludeMap other) {
        if (other.forcedReplacement != this.forcedReplacement) {
            throw new IllegalArgumentException();
        }
        for (Map.Entry<IncludeInfo, List<IncludeInfo>> entry : other.map.entrySet()) {
            IncludeInfo source = entry.getKey();
            List<IncludeInfo> otherTargets = entry.getValue();
            List<IncludeInfo> targets = this.map.get(source);
            if (targets == null) {
                targets = new ArrayList<IncludeInfo>(otherTargets);
                this.map.put(source, targets);
                continue;
            }
            targets.addAll(otherTargets);
        }
    }

    public void transitivelyClose() {
        List<IncludeInfo> targets;
        IncludeInfo source;
        block0: for (Map.Entry<IncludeInfo, List<IncludeInfo>> entry : this.map.entrySet()) {
            IncludeInfo target;
            source = entry.getKey();
            targets = entry.getValue();
            ArrayDeque<IncludeInfo> queue = new ArrayDeque<IncludeInfo>(targets);
            targets.clear();
            HashSet<IncludeInfo> processed = new HashSet<IncludeInfo>();
            if (!this.forcedReplacement) {
                processed.add(source);
            }
            HashSet<IncludeInfo> seenTargets = new HashSet<IncludeInfo>();
            while ((target = queue.pollFirst()) != null) {
                if (processed.contains(target)) continue;
                List<IncludeInfo> newTargets = this.map.get(target);
                if (newTargets != null) {
                    queue.addFirst(target);
                    boolean added = false;
                    if (seenTargets.add(target)) {
                        int i = newTargets.size();
                        while (--i >= 0) {
                            IncludeInfo newTarget = newTargets.get(i);
                            if (processed.contains(newTarget)) continue;
                            if (this.forcedReplacement && newTarget.equals(source)) continue block0;
                            queue.addFirst(newTarget);
                            added = true;
                        }
                    }
                    if (added) continue;
                    target = queue.pollFirst();
                    targets.add(target);
                    if (this.forcedReplacement) continue block0;
                    processed.add(target);
                    seenTargets.clear();
                    continue;
                }
                targets.add(target);
                if (this.forcedReplacement) continue block0;
                processed.add(target);
                seenTargets.clear();
            }
        }
        if (this.forcedReplacement) {
            Iterator<Map.Entry<IncludeInfo, List<IncludeInfo>>> iter = this.map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<IncludeInfo, List<IncludeInfo>> entry = iter.next();
                source = entry.getKey();
                targets = entry.getValue();
                if (!targets.isEmpty() && (targets.size() != 1 || !source.equals(targets.get(0)))) continue;
                iter.remove();
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("forcedReplacement = ").append(this.forcedReplacement);
        buf.append(", cppOnly = ").append(this.cppOnly);
        ArrayList<IncludeInfo> sources = new ArrayList<IncludeInfo>(this.map.keySet());
        Collections.sort(sources);
        for (IncludeInfo source : sources) {
            buf.append('\n');
            buf.append(source);
            buf.append(" -> ");
            List<IncludeInfo> targets = this.map.get(source);
            int i = 0;
            while (i < targets.size()) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(targets.get(i));
                ++i;
            }
        }
        return buf.toString();
    }
}

