/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.CopyElementsOperation;
import org.eclipse.cdt.internal.core.model.CopyResourceElementsOperation;
import org.eclipse.cdt.internal.core.model.DeleteElementsOperation;
import org.eclipse.cdt.internal.core.model.DeleteResourceElementsOperation;
import org.eclipse.cdt.internal.core.model.MoveElementsOperation;
import org.eclipse.cdt.internal.core.model.MoveResourceElementsOperation;
import org.eclipse.cdt.internal.core.model.MultiOperation;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.RenameElementsOperation;
import org.eclipse.cdt.internal.core.model.RenameResourceElementsOperation;
import org.eclipse.cdt.internal.core.util.MementoTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class CModel
extends Openable
implements ICModel {
    public CModel() {
        this(ResourcesPlugin.getWorkspace().getRoot());
    }

    public CModel(IWorkspaceRoot root) {
        super(null, (IResource)root, 10);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CModel)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public ICProject[] getCProjects() throws CModelException {
        List<ICElement> list = this.getChildrenOfType(11);
        ICProject[] array = new ICProject[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public ICProject getCProject(String name) {
        IProject project = ((IWorkspaceRoot)this.getResource()).getProject(name);
        return CModelManager.getDefault().create(project);
    }

    public ICProject getCProject(IResource resource) {
        switch (resource.getType()) {
            case 2: {
                return new CProject(this, ((IFolder)resource).getProject());
            }
            case 1: {
                return new CProject(this, ((IFile)resource).getProject());
            }
            case 4: {
                return new CProject(this, (IProject)resource);
            }
        }
        throw new IllegalArgumentException("element.invalidResourceForProject");
    }

    public ICProject findCProject(IProject project) {
        try {
            ICProject[] projects;
            ICProject[] iCProjectArray = projects = this.getOldCProjectsList();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                ICProject cProject = iCProjectArray[n2];
                if (project.equals((Object)cProject.getProject())) {
                    return cProject;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.getUnderlyingResource().getWorkspace();
    }

    @Override
    public void copy(ICElement[] elements, ICElement[] containers, ICElement[] siblings, String[] renamings, boolean replace, IProgressMonitor monitor) throws CModelException {
        if (elements != null && elements[0] != null && elements[0].getElementType() <= 60) {
            this.runOperation(new CopyResourceElementsOperation(elements, containers, replace), elements, siblings, renamings, monitor);
        } else {
            this.runOperation(new CopyElementsOperation(elements, containers, replace), elements, siblings, renamings, monitor);
        }
    }

    @Override
    public void delete(ICElement[] elements, boolean force, IProgressMonitor monitor) throws CModelException {
        MultiOperation op = elements != null && elements[0] != null && elements[0].getElementType() <= 60 ? new DeleteResourceElementsOperation(elements, force) : new DeleteElementsOperation(elements, force);
        op.runOperation(monitor);
    }

    @Override
    public void move(ICElement[] elements, ICElement[] containers, ICElement[] siblings, String[] renamings, boolean replace, IProgressMonitor monitor) throws CModelException {
        if (elements != null && elements[0] != null && elements[0].getElementType() <= 60) {
            this.runOperation(new MoveResourceElementsOperation(elements, containers, replace), elements, siblings, renamings, monitor);
        } else {
            this.runOperation(new MoveElementsOperation(elements, containers, replace), elements, siblings, renamings, monitor);
        }
    }

    @Override
    public void rename(ICElement[] elements, ICElement[] destinations, String[] renamings, boolean force, IProgressMonitor monitor) throws CModelException {
        MultiOperation op = elements != null && elements[0] != null && elements[0].getElementType() <= 60 ? new RenameResourceElementsOperation(elements, destinations, renamings, force) : new RenameElementsOperation(elements, destinations, renamings, force);
        op.runOperation(monitor);
    }

    protected void runOperation(MultiOperation op, ICElement[] elements, ICElement[] siblings, String[] renamings, IProgressMonitor monitor) throws CModelException {
        op.setRenamings(renamings);
        if (siblings != null) {
            int i = 0;
            while (i < elements.length) {
                op.setInsertBefore(elements[i], siblings[i]);
                ++i;
            }
        }
        op.runOperation(monitor);
    }

    @Override
    protected CElementInfo createElementInfo() {
        return new CModelInfo(this);
    }

    @Override
    public int hashCode() {
        return this.resource.hashCode();
    }

    public ICProject[] getOldCProjectsList() throws CModelException {
        CModelManager manager = CModelManager.getDefault();
        return manager.cProjectsCache == null ? this.getCProjects() : manager.cProjectsCache;
    }

    @Override
    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map<ICElement, CElementInfo> newElements, IResource underlyingResource) throws CModelException {
        boolean validInfo = false;
        try {
            IResource res = this.getResource();
            if (res != null && (res instanceof IWorkspaceRoot || res.getProject().isOpen())) {
                validInfo = this.computeChildren(info, res);
            }
        }
        finally {
            if (!validInfo) {
                CModelManager.getDefault().removeInfo(this);
            }
        }
        return validInfo;
    }

    @Override
    public Object[] getNonCResources() throws CModelException {
        return ((CModelInfo)this.getElementInfo()).getNonCResources();
    }

    protected boolean computeChildren(OpenableInfo info, IResource res) throws CModelException {
        IProject[] projects;
        IWorkspaceRoot root = (IWorkspaceRoot)this.getResource();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (CoreModel.hasCNature(project) || CoreModel.hasCCNature(project)) {
                CProject cproject = new CProject(this, project);
                info.addChild(cproject);
            }
            ++n2;
        }
        ((CModelInfo)this.getElementInfo()).setNonCResources(null);
        return true;
    }

    @Override
    public ICElement getHandleFromMemento(String token, MementoTokenizer memento) {
        switch (token.charAt(0)) {
            case '=': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String projectName = memento.nextToken();
                CElement project = (CElement)((Object)this.getCProject(projectName));
                if (project == null) break;
                return project.getHandleFromMemento(memento);
            }
        }
        return null;
    }

    @Override
    public void getHandleMemento(StringBuilder buff) {
        buff.append(this.getElementName());
    }

    @Override
    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }
}

