/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;

public class ASTQueries {
    private static NameSearch NAME_SEARCH = new NameSearch();

    public static boolean canContainName(IASTExpression expr) {
        if (expr == null) {
            return false;
        }
        NAME_SEARCH.reset();
        expr.accept(NAME_SEARCH);
        return NAME_SEARCH.foundName();
    }

    public static IASTDeclarator findOutermostDeclarator(IASTDeclarator declarator) {
        IASTDeclarator outermost = null;
        IASTNode candidate = declarator;
        while (candidate instanceof IASTDeclarator) {
            outermost = candidate;
            candidate = outermost.getParent();
        }
        return outermost;
    }

    public static IASTDeclarator findInnermostDeclarator(IASTDeclarator declarator) {
        IASTDeclarator innermost = null;
        while (declarator != null) {
            innermost = declarator;
            declarator = declarator.getNestedDeclarator();
        }
        return innermost;
    }

    public static IASTDeclarator findTypeRelevantDeclarator(IASTDeclarator declarator) {
        if (declarator == null) {
            return null;
        }
        IASTDeclarator result = ASTQueries.findInnermostDeclarator(declarator);
        while (!(result.getPointerOperators().length != 0 || result instanceof IASTFieldDeclarator || result instanceof IASTFunctionDeclarator || result instanceof IASTArrayModifier)) {
            IASTNode parent = result.getParent();
            if (parent instanceof IASTDeclarator) {
                result = (IASTDeclarator)parent;
                continue;
            }
            return result;
        }
        return result;
    }

    public static IASTDeclaration[] extractActiveDeclarations(IASTDeclaration[] allDeclarations, int size) {
        IASTDeclaration[] active;
        if (size == 0) {
            active = IASTDeclaration.EMPTY_DECLARATION_ARRAY;
        } else {
            active = new IASTDeclaration[size];
            int j = 0;
            int i = 0;
            while (i < size) {
                IASTDeclaration d = allDeclarations[i];
                if (d.isActive()) {
                    active[j++] = d;
                }
                ++i;
            }
            active = ArrayUtil.trimAt(IASTDeclaration.class, active, j - 1);
        }
        return active;
    }

    public static boolean isSameType(IType type1, IType type2) {
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return type1.isSameType(type2);
    }

    protected static IType isCompatibleArray(IType t1, IType t2) {
        if (t1 instanceof IArrayType && t2 instanceof IArrayType) {
            IArrayType a1 = (IArrayType)t1;
            IArrayType a2 = (IArrayType)t2;
            if (!ASTQueries.isSameType(a1.getType(), a2.getType())) {
                return null;
            }
            if (a1.getSize() == null) {
                if (a2.getSize() != null) {
                    return a2;
                }
            } else if (a2.getSize() == null) {
                return a1;
            }
        }
        return null;
    }

    private static class NameSearch
    extends ASTVisitor {
        private boolean fFound;

        NameSearch() {
            super(false);
            this.shouldVisitAmbiguousNodes = true;
            this.shouldVisitNames = true;
        }

        public void reset() {
            this.fFound = false;
        }

        public boolean foundName() {
            return this.fFound;
        }

        @Override
        public int visit(IASTName name) {
            this.fFound = true;
            return 2;
        }

        @Override
        public int visit(ASTAmbiguousNode node) {
            IASTNode[] alternatives;
            IASTNode[] iASTNodeArray = alternatives = node.getNodes();
            int n = alternatives.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode alt = iASTNodeArray[n2];
                if (!alt.accept(this)) {
                    return 2;
                }
                ++n2;
            }
            return 3;
        }
    }
}

