/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.preferences.ControlPreferences;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.CommandResult;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.ICommandResult;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.ICommandShell;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.IRemoteSystemProxy;
import org.eclipse.rse.services.shells.HostShellProcessAdapter;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;

public class CommandShell
implements ICommandShell {
    public static final String DONE_MARKUP_STRING = "--RSE:donedonedone:--";
    public static final String BEGIN_END_TAG = "BEGIN-END-TAG:";
    public static final String CMD_DELIMITER = "\n";
    public static final String SHELL_ECHO_CMD = " echo ";
    public static final char CMD_SEPARATOR = ';';
    private IRemoteSystemProxy fProxy = null;
    private IHostShell fHostShell = null;
    private BufferedReader fInputBufferReader = null;
    private BufferedReader fErrorBufferReader = null;
    private final ExecutorService fExecutor = Executors.newFixedThreadPool(1);
    private boolean fIsConnected = false;
    private final Random fRandom = new Random(System.currentTimeMillis());
    private int fReturnValue;

    public CommandShell(IRemoteSystemProxy proxy) {
        this.fProxy = proxy;
    }

    @Override
    public void connect() throws ExecutionException {
        IShellService shellService = this.fProxy.getShellService();
        HostShellProcessAdapter p = null;
        try {
            this.fHostShell = shellService.launchShell("", new String[0], (IProgressMonitor)new NullProgressMonitor());
            p = new HostShellProcessAdapter(this.fHostShell);
        }
        catch (Exception e) {
            throw new ExecutionException(Messages.TraceControl_CommandShellError, (Throwable)e);
        }
        this.fInputBufferReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        this.fErrorBufferReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        this.fIsConnected = true;
    }

    @Override
    public void disconnect() {
        this.fIsConnected = false;
        try {
            this.fInputBufferReader.close();
            this.fErrorBufferReader.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public ICommandResult executeCommand(String command, IProgressMonitor monitor) throws ExecutionException {
        return this.executeCommand(command, monitor, true);
    }

    @Override
    public ICommandResult executeCommand(final String command, final IProgressMonitor monitor, boolean checkReturnValue) throws ExecutionException {
        if (this.fIsConnected) {
            FutureTask<CommandResult> future = new FutureTask<CommandResult>(new Callable<CommandResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public CommandResult call() throws IOException, CancellationException {
                    ArrayList<String> result = new ArrayList<String>();
                    IHostShell iHostShell = CommandShell.this.fHostShell;
                    synchronized (iHostShell) {
                        String nextLine;
                        CommandShell.this.fReturnValue = 0;
                        int startAlias = CommandShell.this.fRandom.nextInt();
                        int endAlias = CommandShell.this.fRandom.nextInt();
                        CommandShell.this.fHostShell.writeToShell(CommandShell.formatShellCommand(command, startAlias, endAlias));
                        boolean isStartFound = false;
                        while ((nextLine = CommandShell.this.fInputBufferReader.readLine()) != null) {
                            if (monitor.isCanceled()) {
                                CommandShell.this.flushInput();
                                throw new CancellationException();
                            }
                            if (CommandShell.this.isAliasEchoResult(nextLine, startAlias, true)) {
                                isStartFound = true;
                                continue;
                            }
                            if (CommandShell.this.isAliasEchoResult(nextLine, endAlias, false)) break;
                            if (!isStartFound || CommandShell.isCommandEcho(nextLine, command) || nextLine.contains(CommandShell.getEchoResult(endAlias))) continue;
                            result.add(nextLine);
                        }
                        CommandShell.this.flushInput();
                        if (CommandShell.this.fReturnValue != 0) {
                            while (CommandShell.this.fErrorBufferReader.ready()) {
                                nextLine = CommandShell.this.fErrorBufferReader.readLine();
                                if (nextLine == null) continue;
                                result.add(nextLine);
                            }
                        }
                    }
                    return new CommandResult(CommandShell.this.fReturnValue, result.toArray(new String[result.size()]));
                }
            });
            this.fExecutor.execute(future);
            try {
                return future.get(ControlPreferences.getInstance().getCommandTimeout(), TimeUnit.SECONDS);
            }
            catch (java.util.concurrent.ExecutionException ex) {
                throw new ExecutionException(Messages.TraceControl_ExecutionFailure, (Throwable)ex);
            }
            catch (InterruptedException ex) {
                throw new ExecutionException(Messages.TraceControl_ExecutionCancelled, (Throwable)ex);
            }
            catch (TimeoutException ex) {
                throw new ExecutionException(Messages.TraceControl_ExecutionTimeout, (Throwable)ex);
            }
        }
        throw new ExecutionException(Messages.TraceControl_ShellNotConnected, null);
    }

    private void flushInput() throws IOException {
        char[] cbuf = new char[1];
        while (this.fInputBufferReader.ready()) {
            if (this.fInputBufferReader.read(cbuf, 0, 1) == -1) break;
        }
    }

    private static String formatShellCommand(String cmd, int startAlias, int endAlias) {
        if (cmd == null || cmd.equals("")) {
            return cmd;
        }
        StringBuffer formattedCommand = new StringBuffer();
        formattedCommand.append(CommandShell.getEchoCmd(startAlias));
        formattedCommand.append(CMD_DELIMITER);
        formattedCommand.append(cmd);
        formattedCommand.append(CMD_DELIMITER);
        formattedCommand.append(CommandShell.getEchoCmd(endAlias));
        formattedCommand.append(CMD_DELIMITER);
        return formattedCommand.toString();
    }

    private static String getEchoCmd(int alias) {
        return SHELL_ECHO_CMD + CommandShell.getEchoResult(alias) + "$?";
    }

    private static String getEchoResult(int alias) {
        return BEGIN_END_TAG + String.valueOf(alias) + DONE_MARKUP_STRING;
    }

    private boolean isAliasEchoResult(String line, int alias, boolean checkReturnValue) {
        String expected = CommandShell.getEchoResult(alias);
        if (line.startsWith(expected)) {
            if (!checkReturnValue) {
                try {
                    int k;
                    this.fReturnValue = k = Integer.valueOf(line.substring(expected.length())).intValue();
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return true;
        }
        int index = line.indexOf(expected);
        return index > 0 && line.indexOf(SHELL_ECHO_CMD) == -1;
    }

    private static boolean isCommandEcho(String line, String cmd) {
        String s1 = line.replaceAll("\\s", "");
        String s2 = cmd.replaceAll("\\s", "");
        s2 = s2.replaceAll("(\\*)", "(\\\\*)");
        String patternStr = ".*(" + s2 + ")$";
        return s1.matches(patternStr);
    }
}

