/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IChannelInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IDomainInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.ISessionInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.LogLevelType;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceLogLevel;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceSessionState;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.SessionInfo;
import org.eclipse.linuxtools.internal.lttng2.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.ITraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TargetNodeComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceDomainComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceProviderGroup;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionGroup;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.property.TraceSessionPropertySource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public class TraceSessionComponent
extends TraceControlComponent {
    public static final String TRACE_SESSION_ICON_FILE_INACTIVE = "icons/obj16/session_inactive.gif";
    public static final String TRACE_SESSION_ICON_FILE_ACTIVE = "icons/obj16/session_active.gif";
    public static final String TRACE_SESSION_ICON_FILE_DESTROYED = "icons/obj16/session_destroyed.gif";
    private ISessionInfo fSessionInfo = null;
    private boolean fIsDestroyed = false;
    private Image fActiveImage = null;
    private Image fDestroyedImage = null;

    public TraceSessionComponent(String name, ITraceControlComponent parent) {
        super(name, parent);
        this.setImage(TRACE_SESSION_ICON_FILE_INACTIVE);
        this.setToolTip(Messages.TraceControl_SessionDisplayName);
        this.fSessionInfo = new SessionInfo(name);
        this.fActiveImage = Activator.getDefault().loadIcon(TRACE_SESSION_ICON_FILE_ACTIVE);
        this.fDestroyedImage = Activator.getDefault().loadIcon(TRACE_SESSION_ICON_FILE_DESTROYED);
    }

    @Override
    public Image getImage() {
        if (this.fIsDestroyed) {
            return this.fDestroyedImage;
        }
        if (this.fSessionInfo.getSessionState() == TraceSessionState.INACTIVE) {
            return super.getImage();
        }
        return this.fActiveImage;
    }

    public boolean isDestroyed() {
        return this.fIsDestroyed;
    }

    public void setDestroyed(boolean destroyed) {
        this.fIsDestroyed = destroyed;
    }

    public TraceSessionState getSessionState() {
        return this.fSessionInfo.getSessionState();
    }

    public void setSessionState(TraceSessionState state) {
        this.fSessionInfo.setSessionState(state);
    }

    public void setSessionState(String stateName) {
        this.fSessionInfo.setSessionState(stateName);
    }

    public String getSessionPath() {
        return this.fSessionInfo.getSessionPath();
    }

    public void setSessionPath(String sessionPath) {
        this.fSessionInfo.setSessionPath(sessionPath);
    }

    public boolean isStreamedTrace() {
        return this.fSessionInfo.isStreamedTrace();
    }

    public void setIsStreamedTrace(boolean isStreamedTrace) {
        this.fSessionInfo.setStreamedTrace(isStreamedTrace);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return new TraceSessionPropertySource(this);
        }
        return null;
    }

    public TraceDomainComponent[] getDomains() {
        List<ITraceControlComponent> sessions = this.getChildren(TraceDomainComponent.class);
        return sessions.toArray(new TraceDomainComponent[sessions.size()]);
    }

    public TargetNodeComponent getTargetNode() {
        return ((TraceSessionGroup)this.getParent()).getTargetNode();
    }

    public boolean hasKernelProvider() {
        List<ITraceControlComponent> providerGroups = this.getTargetNode().getChildren(TraceProviderGroup.class);
        return !providerGroups.isEmpty() ? ((TraceProviderGroup)providerGroups.get(0)).hasKernelProvider() : false;
    }

    public boolean isEventFilteringSupported() {
        return ((TargetNodeComponent)this.getParent().getParent()).isEventFilteringSupported();
    }

    public void getConfigurationFromNode(IProgressMonitor monitor) throws ExecutionException {
        this.removeAllChildren();
        this.fSessionInfo = this.getControlService().getSession(this.getName(), monitor);
        IDomainInfo[] domains = this.fSessionInfo.getDomains();
        int i = 0;
        while (i < domains.length) {
            TraceDomainComponent domainComponent = new TraceDomainComponent(domains[i].getName(), this);
            this.addChild(domainComponent);
            domainComponent.setDomainInfo(domains[i]);
            ++i;
        }
    }

    public void startSession(IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().startSession(this.getName(), monitor);
    }

    public void stopSession(IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().stopSession(this.getName(), monitor);
    }

    public void enableChannels(List<String> channelNames, IChannelInfo info, boolean isKernel, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableChannels(this.getName(), channelNames, isKernel, info, monitor);
    }

    public void enableEvents(List<String> eventNames, boolean isKernel, String filterExpression, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableEvents(this.getName(), null, eventNames, isKernel, filterExpression, monitor);
    }

    public void enableSyscalls(IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableSyscalls(this.getName(), null, monitor);
    }

    public void enableProbe(String eventName, boolean isFunction, String probe, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableProbe(this.getName(), null, eventName, isFunction, probe, monitor);
    }

    public void enableLogLevel(String eventName, LogLevelType logLevelType, TraceLogLevel level, String filterExpression, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableLogLevel(this.getName(), null, eventName, logLevelType, level, null, monitor);
    }

    public List<String> getContextList(IProgressMonitor monitor) throws ExecutionException {
        return this.getControlService().getContextList(monitor);
    }
}

