/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.text.rules;

import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class LuaDocSingleCommentSeriesRule
implements IPredicateRule {
    private IToken fDocToken;
    private EndOfLineRule threeDashesRule;
    private EndOfLineRule twoDashesRule;

    public LuaDocSingleCommentSeriesRule(IToken docToken) {
        this.fDocToken = docToken;
        this.threeDashesRule = new EndOfLineRule("---", this.fDocToken);
        this.twoDashesRule = new EndOfLineRule("--", this.fDocToken);
    }

    public IToken getSuccessToken() {
        return this.fDocToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        WhitespaceRule whiteSpaceRule = new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return c == ' ' || c == '\t';
            }
        });
        IToken t = this.threeDashesRule.evaluate(scanner);
        if (t == this.fDocToken) {
            while (t == this.fDocToken) {
                whiteSpaceRule.evaluate(scanner);
                t = this.twoDashesRule.evaluate(scanner);
            }
            return this.fDocToken;
        }
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }
}

