/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.templates;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.internal.ui.text.hover.SourceViewerInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlCreatorExtension;
import org.eclipse.koneki.ldt.ui.internal.LuaDocumentationHelper;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;

public class LuaTemplateInformationControlCreator
implements IInformationControlCreator,
IInformationControlCreatorExtension {
    private SourceViewerInformationControl fControl;
    private int fOrientation;
    private IDLTKLanguageToolkit fToolkit;

    public LuaTemplateInformationControlCreator(int orientation, IDLTKLanguageToolkit toolkit) {
        Assert.isLegal((orientation == 0x4000000 || orientation == 0x2000000 ? 1 : 0) != 0);
        this.fOrientation = orientation;
        this.fToolkit = toolkit;
    }

    public IInformationControl createInformationControl(Shell parent) {
        this.fControl = new SourceViewerInformationControl(parent, 4 | this.fOrientation, 0, this.fToolkit);
        this.fControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LuaTemplateInformationControlCreator.this.fControl = null;
            }
        });
        this.fControl.setBackgroundColor(LuaDocumentationHelper.getBackgroundColor());
        this.fControl.setForegroundColor(LuaDocumentationHelper.getForegroundColor());
        return this.fControl;
    }

    public boolean canReuse(IInformationControl control) {
        return this.fControl == control && this.fControl != null;
    }

    public boolean canReplace(IInformationControlCreator creator) {
        return creator != null && this.getClass() == creator.getClass();
    }
}

