/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.Set;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewRemoteDialog
extends TitleAreaDialog {
    private Text nameText;
    private Set<String> existingRemotes;
    private Button forPush;
    private String name;
    private boolean pushMode;

    public NewRemoteDialog(Shell parentShell, Repository repository) {
        super(parentShell);
        this.existingRemotes = repository.getConfig().getSubsections("remote");
    }

    public void create() {
        super.create();
        this.setTitle(UIText.NewRemoteDialog_DialogTitle);
        this.setMessage(UIText.NewRemoteDialog_ConfigurationMessage);
        if (this.existingRemotes.isEmpty()) {
            this.nameText.setText("origin");
            this.nameText.selectAll();
        }
        this.checkPage();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.NewRemoteDialog_WindowTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(main);
        GridDataFactory.fillDefaults().indent(5, 5).grab(true, true).applyTo((Control)main);
        Label nameLabel = new Label(main, 0);
        nameLabel.setText(UIText.NewRemoteDialog_NameLabel);
        this.nameText = new Text(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewRemoteDialog.this.checkPage();
            }
        });
        this.forPush = new Button(main, 16);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.forPush);
        this.forPush.setText(UIText.NewRemoteDialog_PushRadio);
        this.forPush.setSelection(true);
        Button forFetch = new Button(main, 16);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)forFetch);
        forFetch.setText(UIText.NewRemoteDialog_FetchRadio);
        this.nameText.setFocus();
        NewRemoteDialog.applyDialogFont((Control)main);
        return main;
    }

    private void checkPage() {
        boolean errorFound = false;
        this.setErrorMessage(null);
        if (this.existingRemotes.contains(this.nameText.getText())) {
            this.setErrorMessage(NLS.bind((String)UIText.NewRemoteDialog_RemoteAlreadyExistsMessage, (Object)this.nameText.getText()));
            errorFound = true;
        }
        this.getButton(0).setEnabled(!errorFound);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.name = this.nameText.getText();
            this.pushMode = this.forPush.getSelection();
        }
        super.buttonPressed(buttonId);
    }

    public String getName() {
        return this.name;
    }

    public boolean getPushMode() {
        return this.pushMode;
    }
}

