/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util;

import java.util.Stack;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;

public class FormattingXMLStreamWriter
extends XmlStreamWriter {
    private final XmlStreamWriter delegate;
    private int indentLevel;
    private final Stack<Integer> childCounts = new Stack();
    private int childCount;
    private final Stack<String> elements = new Stack();
    private int lineOffset = 0;

    public FormattingXMLStreamWriter(XmlStreamWriter delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public String getPrefix(String uri) {
        return this.delegate.getPrefix(uri);
    }

    @Override
    public void setDefaultNamespace(String uri) {
        this.delegate.setDefaultNamespace(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) {
        this.delegate.setPrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) {
        if (value == null) {
            value = "";
        }
        this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) {
        if (value == null) {
            value = "";
        }
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String localName, String value) {
        if (value == null) {
            value = "";
        }
        this.delegate.writeAttribute(localName, value);
    }

    @Override
    public void writeCData(String data) {
        this.delegate.writeCData(data);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) {
        int lineStart = start;
        int length = 0;
        int x = 0;
        while (x < len) {
            int charOffset = start + x;
            ++length;
            if (this.lineOffset == 0 && text[charOffset] != '\n') {
                this.maybeIndent(false, true);
            }
            ++this.lineOffset;
            if (text[charOffset] == '\n') {
                this.delegate.writeCharacters(text, lineStart, length);
                length = 0;
                this.lineOffset = 0;
                lineStart = charOffset;
            }
            ++x;
        }
        if (length > 0) {
            this.delegate.writeCharacters(text, lineStart, length);
            this.lineOffset += length;
        }
    }

    @Override
    public void writeCharacters(String text) {
        if (text == null) {
            return;
        }
        char[] chars = text.toCharArray();
        this.writeCharacters(chars, 0, chars.length);
    }

    @Override
    public void writeLiteral(String literal) {
        this.delegate.writeLiteral(literal);
    }

    @Override
    public void writeComment(String data) {
        if (data == null) {
            data = "";
        }
        ++this.childCount;
        this.maybeIndent();
        this.delegate.writeComment(data);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) {
        this.delegate.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeDTD(String dtd) {
        this.delegate.writeDTD(dtd);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) {
        ++this.childCount;
        this.maybeIndent();
        this.delegate.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) {
        ++this.childCount;
        this.maybeIndent();
        this.delegate.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String localName) {
        ++this.childCount;
        this.maybeIndent();
        this.delegate.writeEmptyElement(localName);
    }

    @Override
    public void writeEndDocument() {
        this.delegate.writeEndDocument();
    }

    @Override
    public void writeEndElement() {
        --this.indentLevel;
        this.maybeIndent();
        this.elements.pop();
        this.delegate.writeEndElement();
        this.childCount = this.childCounts.pop();
    }

    @Override
    public void writeEntityRef(String name) {
        this.delegate.writeEntityRef(name);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) {
        this.delegate.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) {
        this.delegate.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeProcessingInstruction(String target) {
        this.delegate.writeProcessingInstruction(target);
    }

    @Override
    public void writeStartDocument() {
        this.delegate.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String encoding, String version) {
        this.delegate.writeStartDocument(encoding, version);
    }

    @Override
    public void writeStartDocument(String version) {
        this.delegate.writeStartDocument(version);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) {
        ++this.childCount;
        this.maybeIndent();
        this.elements.push(localName);
        this.childCounts.push(this.childCount);
        this.childCount = 0;
        ++this.indentLevel;
        this.delegate.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) {
        ++this.childCount;
        this.maybeIndent();
        this.elements.push(localName);
        this.childCounts.push(this.childCount);
        this.childCount = 0;
        ++this.indentLevel;
        this.delegate.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String localName) {
        ++this.childCount;
        this.maybeIndent();
        this.elements.push(localName);
        this.childCounts.push(this.childCount);
        this.childCount = 0;
        ++this.indentLevel;
        this.delegate.writeStartElement(localName);
    }

    private void maybeIndent() {
        this.maybeIndent(true, false);
    }

    private void maybeIndent(boolean withNewline, boolean force) {
        if (this.childCount == 0 && !force || this.preserveWhitespace()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        if (withNewline) {
            buf.append('\n');
        }
        int x = 0;
        while (x < this.indentLevel) {
            buf.append('\t');
            ++x;
        }
        this.lineOffset = this.indentLevel;
        this.delegate.writeCharacters(buf.toString().toCharArray(), 0, buf.length());
    }

    private boolean preserveWhitespace() {
        int x = this.elements.size() - 1;
        while (x >= 0) {
            if (this.preserveWhitespace((String)this.elements.get(x))) {
                return true;
            }
            --x;
        }
        return false;
    }

    protected boolean preserveWhitespace(String elementName) {
        return false;
    }
}

