/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statistics;

import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

class StatsStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 0;

    public StatsStateProvider(ITmfTrace trace) {
        super(trace, ITmfEvent.class, "TMF Statistics");
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public StatsStateProvider getNewInstance() {
        return new StatsStateProvider(this.getTrace());
    }

    @Override
    protected void eventHandle(ITmfEvent event) {
        long ts = event.getTimestamp().normalize(0L, -9).getValue();
        String eventName = event.getType().getName();
        try {
            int quark = this.ss.getQuarkAbsoluteAndAdd("total");
            this.ss.incrementAttribute(ts, quark);
            quark = this.ss.getQuarkAbsoluteAndAdd("event_types", eventName);
            this.ss.incrementAttribute(ts, quark);
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
    }
}

