/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.component;

import org.eclipse.linuxtools.internal.tmf.core.TmfCoreTracer;
import org.eclipse.linuxtools.internal.tmf.core.request.TmfCoalescedEventRequest;
import org.eclipse.linuxtools.tmf.core.component.TmfDataProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;

public abstract class TmfEventProvider
extends TmfDataProvider {
    public TmfEventProvider() {
    }

    @Override
    public void init(String name, Class<? extends ITmfEvent> type) {
        super.init(name, type);
    }

    public TmfEventProvider(String name, Class<? extends ITmfEvent> type) {
        super(name, type);
    }

    public TmfEventProvider(String name, Class<? extends ITmfEvent> type, int queueSize) {
        super(name, type, queueSize);
    }

    public TmfEventProvider(TmfEventProvider other) {
        super(other);
    }

    @Override
    public boolean isCompleted(ITmfDataRequest request, ITmfEvent data, int nbRead) {
        boolean requestCompleted = super.isCompleted(request, data, nbRead);
        if (!requestCompleted && request instanceof ITmfEventRequest) {
            ITmfTimestamp endTime = ((ITmfEventRequest)request).getRange().getEndTime();
            return data.getTimestamp().compareTo(endTime, false) > 0;
        }
        return requestCompleted;
    }

    @Override
    protected synchronized void newCoalescedDataRequest(ITmfDataRequest request) {
        if (request instanceof ITmfEventRequest) {
            ITmfEventRequest eventRequest = (ITmfEventRequest)request;
            TmfCoalescedEventRequest coalescedRequest = new TmfCoalescedEventRequest(eventRequest.getDataType(), eventRequest.getRange(), eventRequest.getIndex(), eventRequest.getNbRequested(), eventRequest.getBlockSize(), eventRequest.getExecType());
            coalescedRequest.addRequest(eventRequest);
            if (TmfCoreTracer.isRequestTraced()) {
                TmfCoreTracer.traceRequest(request, "COALESCED with " + coalescedRequest.getRequestId());
                TmfCoreTracer.traceRequest(coalescedRequest, "now contains " + coalescedRequest.getSubRequestIds());
            }
            this.fPendingCoalescedRequests.add(coalescedRequest);
        } else {
            super.newCoalescedDataRequest(request);
        }
    }
}

