/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.historytree;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.historytree.HTNode;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.historytree.HistoryTree;

class HT_IO {
    private final HistoryTree tree;
    private final File historyTreeFile;
    private final FileInputStream fis;
    private final FileOutputStream fos;
    private final FileChannel fcIn;
    private final FileChannel fcOut;

    HT_IO(HistoryTree tree, boolean newFile) throws IOException {
        this.tree = tree;
        this.historyTreeFile = tree.getConfig().getStateFile();
        boolean success1 = true;
        if (newFile) {
            if (this.historyTreeFile.exists()) {
                success1 = this.historyTreeFile.delete();
            }
            boolean success2 = this.historyTreeFile.createNewFile();
            if (!success1 || !success2) {
                throw new IOException("Cannot create new file at " + this.historyTreeFile.getName());
            }
            this.fis = new FileInputStream(this.historyTreeFile);
            this.fos = new FileOutputStream(this.historyTreeFile, false);
        } else {
            this.fis = new FileInputStream(this.historyTreeFile);
            this.fos = new FileOutputStream(this.historyTreeFile, true);
        }
        this.fcIn = this.fis.getChannel();
        this.fcOut = this.fos.getChannel();
    }

    HTNode readNode(int seqNumber) throws ClosedChannelException {
        HTNode node = this.readNodeFromMemory(seqNumber);
        if (node == null) {
            return this.readNodeFromDisk(seqNumber);
        }
        return node;
    }

    private HTNode readNodeFromMemory(int seqNumber) {
        for (HTNode hTNode : this.tree.getLatestBranch()) {
            if (hTNode.getSequenceNumber() != seqNumber) continue;
            return hTNode;
        }
        return null;
    }

    synchronized HTNode readNodeFromDisk(int seqNumber) throws ClosedChannelException {
        try {
            this.seekFCToNodePos(this.fcIn, seqNumber);
            HTNode readNode = HTNode.readNode(this.tree, this.fcIn);
            return readNode;
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    void writeNode(HTNode node) {
        try {
            this.seekFCToNodePos(this.fcOut, node.getSequenceNumber());
            node.writeSelf(this.fcOut);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    FileChannel getFcOut() {
        return this.fcOut;
    }

    FileInputStream supplyATReader() {
        try {
            this.seekFCToNodePos(this.fcIn, this.tree.getNodeCount());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.fis;
    }

    File supplyATWriterFile() {
        return this.tree.getConfig().getStateFile();
    }

    long supplyATWriterFilePos() {
        return 4096L + (long)this.tree.getNodeCount() * (long)this.tree.getConfig().getBlockSize();
    }

    synchronized void closeFile() {
        try {
            this.fis.close();
            this.fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    synchronized void deleteFile() {
        this.closeFile();
        this.historyTreeFile.delete();
    }

    private void seekFCToNodePos(FileChannel fc, int seqNumber) throws IOException {
        fc.position(4096L + (long)seqNumber * (long)this.tree.getConfig().getBlockSize());
    }
}

