/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.media;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.PGMediaView;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.media.jfxmedia.events.VideoFrameRateListener;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.media.Media;
import javafx.scene.media.MediaErrorEvent;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;

public class MediaView
extends Node {
    private static final String VIDEO_FRAME_RATE_PROPERTY_NAME = "jfxmedia.decodedVideoFPS";
    private InvalidationListener errorListener = new MediaErrorInvalidationListener();
    private InvalidationListener mediaDimensionListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            MediaView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
            MediaView.this.impl_geomChanged();
        }
    };
    private VideoFrameRateListener decodedFrameRateListener;
    private boolean registerVideoFrameRateListener = false;
    private ObjectProperty<MediaPlayer> mediaPlayer;
    private ObjectProperty<EventHandler<MediaErrorEvent>> onError;
    private BooleanProperty preserveRatio;
    private BooleanProperty smooth;
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty fitWidth;
    private DoubleProperty fitHeight;
    private ObjectProperty<Rectangle2D> viewport;
    private int decodedFrameCount;
    private int renderedFrameCount;

    private VideoFrameRateListener createVideoFrameRateListener() {
        String string = null;
        try {
            string = System.getProperty(VIDEO_FRAME_RATE_PROPERTY_NAME);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null || !Boolean.getBoolean(VIDEO_FRAME_RATE_PROPERTY_NAME)) {
            return null;
        }
        return new VideoFrameRateListener(){

            @Override
            public void onFrameRateChanged(final double d) {
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        ObservableMap<Object, Object> observableMap = MediaView.this.getProperties();
                        observableMap.put(MediaView.VIDEO_FRAME_RATE_PROPERTY_NAME, d);
                    }
                });
            }
        };
    }

    private MediaView getMediaView() {
        return this;
    }

    public MediaView() {
        this.setSmooth(Toolkit.getToolkit().getDefaultImageSmooth());
        this.decodedFrameRateListener = this.createVideoFrameRateListener();
    }

    public MediaView(MediaPlayer mediaPlayer) {
        this.setSmooth(Toolkit.getToolkit().getDefaultImageSmooth());
        this.decodedFrameRateListener = this.createVideoFrameRateListener();
        this.setMediaPlayer(mediaPlayer);
    }

    public final void setMediaPlayer(MediaPlayer mediaPlayer) {
        this.mediaPlayerProperty().set(mediaPlayer);
    }

    public final MediaPlayer getMediaPlayer() {
        return this.mediaPlayer == null ? null : (MediaPlayer)this.mediaPlayer.get();
    }

    public final ObjectProperty<MediaPlayer> mediaPlayerProperty() {
        if (this.mediaPlayer == null) {
            this.mediaPlayer = new ObjectPropertyBase<MediaPlayer>(){
                MediaPlayer oldValue = null;

                @Override
                protected void invalidated() {
                    Object object;
                    if (this.oldValue != null) {
                        object = this.oldValue.getMedia();
                        if (object != null) {
                            ((Media)object).widthProperty().removeListener(MediaView.this.mediaDimensionListener);
                            ((Media)object).heightProperty().removeListener(MediaView.this.mediaDimensionListener);
                        }
                        if (MediaView.this.decodedFrameRateListener != null && MediaView.this.getMediaPlayer().retrieveJfxPlayer() != null) {
                            MediaView.this.getMediaPlayer().retrieveJfxPlayer().getVideoRenderControl().removeVideoFrameRateListener(MediaView.this.decodedFrameRateListener);
                        }
                        this.oldValue.errorProperty().removeListener(MediaView.this.errorListener);
                        this.oldValue.removeView(MediaView.this.getMediaView());
                    }
                    if ((object = (MediaPlayer)this.get()) != null) {
                        ((MediaPlayer)object).addView(MediaView.this.getMediaView());
                        ((MediaPlayer)object).errorProperty().addListener(MediaView.this.errorListener);
                        if (MediaView.this.decodedFrameRateListener != null && MediaView.this.getMediaPlayer().retrieveJfxPlayer() != null) {
                            MediaView.this.getMediaPlayer().retrieveJfxPlayer().getVideoRenderControl().addVideoFrameRateListener(MediaView.this.decodedFrameRateListener);
                        } else if (MediaView.this.decodedFrameRateListener != null) {
                            MediaView.this.registerVideoFrameRateListener = true;
                        }
                        Media media = ((MediaPlayer)object).getMedia();
                        if (media != null) {
                            media.widthProperty().addListener(MediaView.this.mediaDimensionListener);
                            media.heightProperty().addListener(MediaView.this.mediaDimensionListener);
                        }
                    }
                    MediaView.this.impl_markDirty(DirtyBits.MEDIAVIEW_MEDIA);
                    MediaView.this.impl_geomChanged();
                    this.oldValue = object;
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "mediaPlayer";
                }
            };
        }
        return this.mediaPlayer;
    }

    public final void setOnError(EventHandler<MediaErrorEvent> eventHandler) {
        this.onErrorProperty().set(eventHandler);
    }

    public final EventHandler<MediaErrorEvent> getOnError() {
        return this.onError == null ? null : (EventHandler)this.onError.get();
    }

    public final ObjectProperty<EventHandler<MediaErrorEvent>> onErrorProperty() {
        if (this.onError == null) {
            this.onError = new ObjectPropertyBase<EventHandler<MediaErrorEvent>>(){

                @Override
                protected void invalidated() {
                    MediaView.this.setEventHandler(MediaErrorEvent.MEDIA_ERROR, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "onError";
                }
            };
        }
        return this.onError;
    }

    public final void setPreserveRatio(boolean bl) {
        this.preserveRatioProperty().set(bl);
    }

    public final boolean isPreserveRatio() {
        return this.preserveRatio == null ? true : this.preserveRatio.get();
    }

    public final BooleanProperty preserveRatioProperty() {
        if (this.preserveRatio == null) {
            this.preserveRatio = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    MediaView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                    MediaView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "preserveRatio";
                }
            };
        }
        return this.preserveRatio;
    }

    public final void setSmooth(boolean bl) {
        this.smoothProperty().set(bl);
    }

    public final boolean isSmooth() {
        return this.smooth == null ? false : this.smooth.get();
    }

    public final BooleanProperty smoothProperty() {
        if (this.smooth == null) {
            this.smooth = new BooleanPropertyBase(){

                @Override
                protected void invalidated() {
                    MediaView.this.impl_markDirty(DirtyBits.NODE_SMOOTH);
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "smooth";
                }
            };
        }
        return this.smooth;
    }

    public final void setX(double d) {
        this.xProperty().set(d);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    MediaView.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    MediaView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double d) {
        this.yProperty().set(d);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    MediaView.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    MediaView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setFitWidth(double d) {
        this.fitWidthProperty().set(d);
    }

    public final double getFitWidth() {
        return this.fitWidth == null ? 0.0 : this.fitWidth.get();
    }

    public final DoubleProperty fitWidthProperty() {
        if (this.fitWidth == null) {
            this.fitWidth = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    MediaView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                    MediaView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "fitWidth";
                }
            };
        }
        return this.fitWidth;
    }

    public final void setFitHeight(double d) {
        this.fitHeightProperty().set(d);
    }

    public final double getFitHeight() {
        return this.fitHeight == null ? 0.0 : this.fitHeight.get();
    }

    public final DoubleProperty fitHeightProperty() {
        if (this.fitHeight == null) {
            this.fitHeight = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    MediaView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                    MediaView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "fitHeight";
                }
            };
        }
        return this.fitHeight;
    }

    public final void setViewport(Rectangle2D rectangle2D) {
        this.viewportProperty().set(rectangle2D);
    }

    public final Rectangle2D getViewport() {
        return this.viewport == null ? null : (Rectangle2D)this.viewport.get();
    }

    public final ObjectProperty<Rectangle2D> viewportProperty() {
        if (this.viewport == null) {
            this.viewport = new ObjectPropertyBase<Rectangle2D>(){

                @Override
                protected void invalidated() {
                    MediaView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                    MediaView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return MediaView.this;
                }

                @Override
                public String getName() {
                    return "viewport";
                }
            };
        }
        return this.viewport;
    }

    void notifyMediaChange() {
        MediaPlayer mediaPlayer = this.getMediaPlayer();
        if (mediaPlayer != null) {
            this.getPGMediaView().setMediaProvider(mediaPlayer);
        }
        this.impl_markDirty(DirtyBits.MEDIAVIEW_MEDIA);
        this.impl_geomChanged();
    }

    void notifyMediaSizeChange() {
        this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
        this.impl_geomChanged();
    }

    void notifyMediaFrameUpdated() {
        ++this.decodedFrameCount;
        this.impl_markDirty(DirtyBits.NODE_CONTENTS);
    }

    @Override
    @Deprecated
    protected PGNode impl_createPGNode() {
        PGMediaView pGMediaView = Toolkit.getToolkit().createPGMediaView();
        pGMediaView.setFrameTracker(new MediaViewFrameTracker());
        return pGMediaView;
    }

    PGMediaView getPGMediaView() {
        return (PGMediaView)this.impl_getPGNode();
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        double d;
        Media media = this.getMediaPlayer() == null ? null : this.getMediaPlayer().getMedia();
        double d2 = media != null ? (double)media.getWidth() : 0.0;
        double d3 = media != null ? (double)media.getHeight() : 0.0;
        double d4 = this.getFitWidth();
        double d5 = this.getFitHeight();
        double d6 = this.getViewport() != null ? this.getViewport().getWidth() : 0.0;
        double d7 = d = this.getViewport() != null ? this.getViewport().getHeight() : 0.0;
        if (d6 > 0.0 && d > 0.0) {
            d2 = d6;
            d3 = d;
        }
        if (this.getFitWidth() <= 0.0 && this.getFitHeight() <= 0.0) {
            d4 = d2;
            d5 = d3;
        } else if (this.isPreserveRatio()) {
            if (this.getFitWidth() <= 0.0) {
                d4 = d3 > 0.0 ? d2 * (this.getFitHeight() / d3) : 0.0;
                d5 = this.getFitHeight();
            } else if (this.getFitHeight() <= 0.0) {
                d4 = this.getFitWidth();
                d5 = d2 > 0.0 ? d3 * (this.getFitWidth() / d2) : 0.0;
            } else {
                if (d2 == 0.0) {
                    d2 = this.getFitWidth();
                }
                if (d3 == 0.0) {
                    d3 = this.getFitHeight();
                }
                double d8 = Math.min(this.getFitWidth() / d2, this.getFitHeight() / d3);
                d4 = d2 * d8;
                d5 = d3 * d8;
            }
        } else if (this.getFitHeight() <= 0.0) {
            d5 = d3;
        } else if (this.getFitWidth() <= 0.0) {
            d4 = d2;
        }
        if (d5 < 1.0) {
            d5 = 1.0;
        }
        if (d4 < 1.0) {
            d4 = 1.0;
        }
        d2 = d4;
        d3 = d5;
        if (d2 <= 0.0 || d3 <= 0.0) {
            return baseBounds.makeEmpty();
        }
        baseBounds = baseBounds.deriveWithNewBounds((float)this.getX(), (float)this.getY(), 0.0f, (float)(this.getX() + d2), (float)(this.getY() + d3), 0.0f);
        baseBounds = baseTransform.transform(baseBounds, baseBounds);
        return baseBounds;
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double d, double d2) {
        return true;
    }

    void updateViewport() {
        if (this.getMediaPlayer() == null) {
            return;
        }
        if (this.getViewport() != null) {
            this.getPGMediaView().setViewport((float)this.getFitWidth(), (float)this.getFitHeight(), (float)this.getViewport().getMinX(), (float)this.getViewport().getMinY(), (float)this.getViewport().getWidth(), (float)this.getViewport().getHeight(), this.isPreserveRatio());
        } else {
            this.getPGMediaView().setViewport((float)this.getFitWidth(), (float)this.getFitHeight(), 0.0f, 0.0f, 0.0f, 0.0f, this.isPreserveRatio());
        }
    }

    @Override
    @Deprecated
    public void impl_updatePG() {
        Object object;
        super.impl_updatePG();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            object = this.getPGMediaView();
            object.setX((float)this.getX());
            object.setY((float)this.getY());
        }
        if (this.impl_isDirty(DirtyBits.NODE_SMOOTH)) {
            this.getPGMediaView().setSmooth(this.isSmooth());
        }
        if (this.impl_isDirty(DirtyBits.NODE_VIEWPORT)) {
            this.updateViewport();
        }
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            this.getPGMediaView().renderNextFrame();
        }
        if (this.impl_isDirty(DirtyBits.MEDIAVIEW_MEDIA)) {
            object = this.getMediaPlayer();
            if (object != null) {
                this.getPGMediaView().setMediaProvider(object);
                this.updateViewport();
            } else {
                this.getPGMediaView().setMediaProvider(null);
            }
        }
    }

    @Deprecated
    public void impl_perfReset() {
        this.decodedFrameCount = 0;
        this.renderedFrameCount = 0;
    }

    @Deprecated
    public int impl_perfGetDecodedFrameCount() {
        return this.decodedFrameCount;
    }

    @Deprecated
    public int impl_perfGetRenderedFrameCount() {
        return this.renderedFrameCount;
    }

    @Override
    @Deprecated
    public Object impl_processMXNode(MXNodeAlgorithm mXNodeAlgorithm, MXNodeAlgorithmContext mXNodeAlgorithmContext) {
        return mXNodeAlgorithm.processLeafNode(this, mXNodeAlgorithmContext);
    }

    void _mediaPlayerOnReady() {
        if (this.decodedFrameRateListener != null && this.getMediaPlayer().retrieveJfxPlayer() != null && this.registerVideoFrameRateListener) {
            this.getMediaPlayer().retrieveJfxPlayer().getVideoRenderControl().addVideoFrameRateListener(this.decodedFrameRateListener);
            this.registerVideoFrameRateListener = false;
        }
    }

    private class MediaViewFrameTracker
    implements PGMediaView.MediaFrameTracker {
        private MediaViewFrameTracker() {
        }

        @Override
        public void incrementDecodedFrameCount(int n) {
            MediaView.this.decodedFrameCount += n;
        }

        @Override
        public void incrementRenderedFrameCount(int n) {
            MediaView.this.renderedFrameCount += n;
        }
    }

    private class MediaErrorInvalidationListener
    implements InvalidationListener {
        private MediaErrorInvalidationListener() {
        }

        @Override
        public void invalidated(Observable observable) {
            ObservableObjectValue observableObjectValue = (ObservableObjectValue)observable;
            MediaView.this.fireEvent(new MediaErrorEvent((Object)MediaView.this.getMediaPlayer(), (EventTarget)MediaView.this.getMediaView(), (MediaException)observableObjectValue.get()));
        }
    }
}

