/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.Settings;
import com.sun.scenario.animation.MilliCurrentTime;
import com.sun.scenario.animation.NanoCurrentTime;
import com.sun.scenario.animation.shared.CurrentTime;
import com.sun.scenario.animation.shared.PulseReceiver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javafx.animation.AnimationTimer;

public abstract class AbstractMasterTimer {
    protected final boolean useNanoTime = this.shouldUseNanoTime();
    protected static final String NOGAPS_PROP = "com.sun.scenario.animation.nogaps";
    protected static boolean nogaps = false;
    protected static final String FULLSPEED_PROP = "javafx.animation.fullspeed";
    protected static boolean fullspeed = false;
    protected static final String ADAPTIVE_PULSE_PROP = "com.sun.scenario.animation.adaptivepulse";
    protected static boolean useAdaptivePulse = false;
    protected static final String PULSE_PROP = "javafx.animation.pulse";
    protected static final String FRAMERATE_PROP = "javafx.animation.framerate";
    protected static final String ANIMATION_MBEAN_ENABLED = "com.sun.scenario.animation.AnimationMBean.enabled";
    protected static final boolean enableAnimationMBean = false;
    private static final double NANO_2_TICKS = 6.0E-6;
    protected final int PULSE_DURATION = this.getPulseDuration(1000);
    protected final int PULSE_DURATION_NS = this.getPulseDuration(1000000000);
    protected final int PULSE_DURATION_TICKS = this.getPulseDuration(6000);
    private static final AnimationTimer[] emptyAnimationTimers = new AnimationTimer[0];
    private boolean paused = false;
    private long totalPausedTime;
    private long startPauseTime;
    private final CurrentTime currentTime = this.createCurrentTime();
    private final MainLoop theMaster = new MainLoop();
    private final Set<PulseReceiver> receiverSet = new HashSet<PulseReceiver>();
    private ArrayList<PulseReceiver> receiverList = new ArrayList();
    private boolean receiverListLocked;
    private final ArrayList<AnimationTimer> animationTimerList = new ArrayList();
    private AnimationTimer[] animationTimers = emptyAnimationTimers;
    private Runnable activeAnimationHandler;

    public int getDefaultResolution() {
        return this.PULSE_DURATION_TICKS;
    }

    protected CurrentTime createCurrentTime() {
        return this.shouldUseNanoTime() ? new NanoCurrentTime() : new MilliCurrentTime();
    }

    public void pause() {
        if (!this.paused) {
            this.startPauseTime = this.nanos();
            this.paused = true;
        }
    }

    public void resume() {
        if (this.paused) {
            this.paused = false;
            this.totalPausedTime += this.nanos() - this.startPauseTime;
        }
    }

    public long nanos() {
        return this.paused ? this.startPauseTime : this.currentTime.nanos() - this.totalPausedTime;
    }

    public boolean isFullspeed() {
        return fullspeed;
    }

    protected abstract boolean shouldUseNanoTime();

    protected AbstractMasterTimer() {
    }

    public void animationTrigger() {
        this.theMaster.run();
    }

    public long getNextPulseTime() {
        return this.theMaster.getDelay();
    }

    public boolean isActive() {
        return !this.theMaster.inactive;
    }

    public void setActiveAnimationHandler(Runnable runnable) {
        this.activeAnimationHandler = runnable;
    }

    public void addPulseReceiver(PulseReceiver pulseReceiver) {
        if (this.receiverSet.add(pulseReceiver)) {
            if (this.receiverListLocked) {
                this.receiverList = new ArrayList<PulseReceiver>(this.receiverList);
                this.receiverListLocked = false;
            }
            this.receiverList.add(pulseReceiver);
        }
        this.theMaster.updateAnimationRunnable();
    }

    public void removePulseReceiver(PulseReceiver pulseReceiver) {
        if (this.receiverSet.remove(pulseReceiver)) {
            if (this.receiverListLocked) {
                this.receiverList = new ArrayList<PulseReceiver>(this.receiverList);
                this.receiverListLocked = false;
            }
            this.receiverList.remove(pulseReceiver);
        }
        if (this.receiverList.isEmpty()) {
            this.theMaster.updateAnimationRunnable();
        }
    }

    public synchronized void addAnimationTimer(AnimationTimer animationTimer) {
        this.animationTimerList.add(animationTimer);
        this.updateAnimationTimers();
        this.theMaster.updateAnimationRunnable();
    }

    private void updateAnimationTimers() {
        this.animationTimers = new AnimationTimer[this.animationTimerList.size()];
        System.arraycopy(this.animationTimerList.toArray(), 0, this.animationTimers, 0, this.animationTimers.length);
    }

    public synchronized void removeAnimationTimer(AnimationTimer animationTimer) {
        if (this.animationTimerList.remove(animationTimer)) {
            this.updateAnimationTimers();
            if (this.animationTimerList.isEmpty()) {
                this.theMaster.updateAnimationRunnable();
            }
        }
    }

    @Deprecated
    public void notifyJobsReady() {
        this.postUpdateAnimationRunnable(this.theMaster);
    }

    protected void recordStart(long l) {
    }

    protected void recordEnd() {
    }

    protected void recordAnimationEnd() {
    }

    protected abstract void postUpdateAnimationRunnable(DelayedRunnable var1);

    protected abstract int getPulseDuration(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timePulseImpl(long l) {
        int n;
        ArrayList<PulseReceiver> arrayList = this.receiverList;
        try {
            this.receiverListLocked = true;
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                arrayList.get(n).timePulse(Math.round((double)l * 6.0E-6));
            }
        }
        finally {
            this.receiverListLocked = false;
        }
        this.recordAnimationEnd();
        AnimationTimer[] animationTimerArray = this.animationTimers;
        for (n = 0; n < animationTimerArray.length; ++n) {
            animationTimerArray[n].handle(l);
        }
    }

    static {
        nogaps = Settings.getBoolean(NOGAPS_PROP);
        fullspeed = Settings.getBoolean(FULLSPEED_PROP);
        useAdaptivePulse = Settings.getBoolean(ADAPTIVE_PULSE_PROP, useAdaptivePulse);
        int n = Settings.getInt(PULSE_PROP, -1);
        if (n != -1) {
            System.err.println("Setting PULSE_DURATION to " + n + " hz");
        }
    }

    private final class MainLoop
    implements DelayedRunnable {
        private boolean inactive = true;
        private long nextPulseTime = AbstractMasterTimer.this.nanos();
        private long lastPulseDuration = Integer.MIN_VALUE;

        private MainLoop() {
        }

        @Override
        public void run() {
            if (AbstractMasterTimer.this.paused) {
                return;
            }
            long l = AbstractMasterTimer.this.nanos();
            AbstractMasterTimer.this.recordStart((this.nextPulseTime - l) / 1000000L);
            AbstractMasterTimer.this.timePulseImpl(l);
            AbstractMasterTimer.this.recordEnd();
            this.updateNextPulseTime(l);
            this.updateAnimationRunnable();
        }

        @Override
        public long getDelay() {
            long l = AbstractMasterTimer.this.nanos();
            long l2 = (this.nextPulseTime - l) / 1000000L;
            return Math.max(0L, l2);
        }

        private void updateNextPulseTime(long l) {
            long l2 = AbstractMasterTimer.this.nanos();
            if (fullspeed) {
                this.nextPulseTime = l2;
            } else if (useAdaptivePulse) {
                this.nextPulseTime += (long)AbstractMasterTimer.this.PULSE_DURATION_NS;
                long l3 = l2 - l;
                if (l3 - this.lastPulseDuration > 500000L) {
                    l3 /= 2L;
                }
                if (l3 < 2000000L) {
                    l3 = 2000000L;
                }
                if (l3 >= (long)AbstractMasterTimer.this.PULSE_DURATION_NS) {
                    l3 = 3 * AbstractMasterTimer.this.PULSE_DURATION_NS / 4;
                }
                this.lastPulseDuration = l3;
                this.nextPulseTime -= l3;
            } else {
                this.nextPulseTime = (this.nextPulseTime + (long)AbstractMasterTimer.this.PULSE_DURATION_NS) / (long)AbstractMasterTimer.this.PULSE_DURATION_NS * (long)AbstractMasterTimer.this.PULSE_DURATION_NS;
            }
        }

        private synchronized void updateAnimationRunnable() {
            boolean bl;
            boolean bl2 = bl = AbstractMasterTimer.this.animationTimerList.isEmpty() && AbstractMasterTimer.this.receiverList.isEmpty();
            if (this.inactive != bl) {
                MainLoop mainLoop;
                this.inactive = bl;
                MainLoop mainLoop2 = mainLoop = this.inactive ? null : this;
                if (AbstractMasterTimer.this.activeAnimationHandler != null) {
                    AbstractMasterTimer.this.activeAnimationHandler.run();
                }
                AbstractMasterTimer.this.postUpdateAnimationRunnable(mainLoop);
            }
        }
    }
}

