/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.models.common;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.DefaultProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.LuaFileAPI;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaASTNode;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaInternalContent;

public class LuaSourceRoot
extends ModuleDeclaration {
    private DefaultProblem problem = null;
    private LuaFile luaFile = new LuaFile();
    private boolean error;

    public LuaSourceRoot(int sourceLength) {
        super(sourceLength);
        this.addStatement(this.luaFile);
    }

    public LuaSourceRoot(int length, boolean rebuild) {
        super(length, rebuild);
        this.addStatement(this.luaFile);
    }

    public LuaFileAPI getFileapi() {
        return this.luaFile.getApi();
    }

    public LuaInternalContent getInternalContent() {
        return this.luaFile.getInternalContent();
    }

    public void setProblem(int line, int column, int offset, String message) {
        IProblemIdentifier id = DefaultProblemIdentifier.decode((int)offset);
        this.problem = new DefaultProblem("", message, id, new String[0], ProblemSeverity.ERROR, -1, offset, line, column);
        this.setError(true);
    }

    public DefaultProblem getProblem() {
        return this.problem;
    }

    public boolean hasError() {
        return this.error;
    }

    public void setError(boolean status) {
        this.error = status;
    }

    public void setLuaFileApi(LuaFileAPI api) {
        this.luaFile.setApi(api);
    }

    public void setInternalContent(LuaInternalContent content) {
        this.luaFile.setInternalContent(content);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static class LuaFile
    extends LuaASTNode {
        private LuaFileAPI fileAPI;
        private LuaInternalContent internalContent = new LuaInternalContent();

        public LuaFile() {
            this.fileAPI = new LuaFileAPI();
        }

        public LuaInternalContent getInternalContent() {
            return this.internalContent;
        }

        public void setInternalContent(LuaInternalContent internalContent) {
            this.internalContent = internalContent;
        }

        public void setApi(LuaFileAPI file) {
            this.fileAPI = file;
        }

        public LuaFileAPI getApi() {
            return this.fileAPI;
        }

        public void traverse(ASTVisitor visitor) throws Exception {
            if (visitor.visit((ASTNode)this)) {
                if (this.getApi() != null) {
                    this.fileAPI.traverse(visitor);
                    this.internalContent.traverse(visitor);
                }
                visitor.endvisit((ASTNode)this);
            }
        }
    }
}

