/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.profiling.launch.RemoteConnection;

public class ConfigUtils {
    private static final String EMPTY_STRING = "";
    private ILaunchConfiguration config;

    public ConfigUtils(ILaunchConfiguration config) {
        this.config = config;
    }

    public boolean getCopyExecutable() throws CoreException {
        boolean copyExecutable = this.config.getAttribute("ENABLE_COPY_FROM_EXE", false);
        return copyExecutable;
    }

    public String getCopyFromExecutablePath() throws CoreException {
        String executablePath = this.config.getAttribute("COPY_FROM_EXE_NAME", EMPTY_STRING);
        return executablePath;
    }

    public String getExecutablePath() throws CoreException {
        String executablePath = this.config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", EMPTY_STRING);
        return executablePath;
    }

    public IPath verifyExecutablePath(IProgressMonitor monitor) throws CoreException {
        URI executableURI;
        String executablePath = this.getExecutablePath();
        try {
            executableURI = new URI(executablePath);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        RemoteConnection rc = new RemoteConnection(executableURI);
        IFileStore fs = rc.getRmtFileProxy().getResource(executableURI.getPath());
        IFileInfo fi = fs.fetchInfo();
        if (fi.exists()) {
            return Path.fromOSString((String)executableURI.getPath());
        }
        return null;
    }

    public String getWorkingDirectory() throws CoreException {
        URI workingDirectoryURI;
        String workingDirectory = this.config.getAttribute("REMOTE_WORKING_DIRECTORY_NAME", EMPTY_STRING);
        if (workingDirectory.length() == 0) {
            return null;
        }
        try {
            workingDirectoryURI = new URI(workingDirectory);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        return workingDirectoryURI.getPath();
    }

    protected IProject verifyProject(ILaunchConfiguration configuration) throws CoreException {
        String proName = ConfigUtils.getProjectName(configuration);
        if (proName == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.profiling.launch", "Messages.AbstractParallelLaunchConfigurationDelegate_Project_not_specified"));
        }
        IProject project = ConfigUtils.getProject(proName);
        if (project == null || !project.exists() || !project.isOpen()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.profiling.launch", "Messages.AbstractParallelLaunchConfigurationDelegate_Project_does_not_exist_or_is_not_a_project"));
        }
        return project;
    }

    public static IProject getProject(String project) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(project);
    }

    public String getProjectName() throws CoreException {
        return ConfigUtils.getProjectName(this.config);
    }

    public static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
    }
}

