/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gdbtrace.core.trace;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.GDBTraceControl_7_2;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointDMData;
import org.eclipse.cdt.dsf.mi.service.MIBreakpoints;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakListInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.gdbtrace.core.GdbTraceCorePlugin;
import org.eclipse.linuxtools.internal.gdbtrace.core.event.GdbTraceEvent;
import org.eclipse.linuxtools.internal.gdbtrace.core.event.GdbTraceEventContent;
import org.eclipse.linuxtools.internal.gdbtrace.core.trace.GdbTrace;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEventType;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class DsfGdbAdaptor {
    private GdbTrace fGdbTrace;
    private int fNumberOfFrames = 0;
    private ILaunch fLaunch;
    private boolean isTerminating;
    private DsfSession fDsfSession = null;
    private String fSessionId;
    private String tracedExecutable = "";
    private String gdb72Executable = "";
    private String fTraceFilePath = "";
    private String fTraceFile = "";
    private String sourceLocator = "";
    private Map<Integer, MIBreakpointDMData> fTpInfo = new HashMap<Integer, MIBreakpointDMData>();
    private TmfEventType tmfEventType = new TmfEventType("TmfContext", "GDB Tracepoint", TmfEventField.makeRoot((String[])new String[]{"Content"}));
    private static DsfGdbPlatformEventListener fPlatformEventListener = new DsfGdbPlatformEventListener();

    public DsfGdbAdaptor(GdbTrace trace, String gdbExec, String traceFile, String tracedExecutable) {
        this.fGdbTrace = trace;
        this.gdb72Executable = gdbExec;
        this.fTraceFilePath = traceFile;
        this.fTraceFile = traceFile.substring(traceFile.lastIndexOf(47) + 1);
        this.tracedExecutable = tracedExecutable;
        try {
            this.launchDGBPostMortemTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void launchDGBPostMortemTrace() throws CoreException {
        ILaunchConfigurationType configType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.cdt.launch.postmortemLaunchType");
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.fTraceFile);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", this.gdb72Executable);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.POST_MORTEM_TYPE", "TRACE_FILE");
        wc.setAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", 0);
        wc.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", this.fTraceFilePath);
        wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "core");
        wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.tracedExecutable);
        wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        if (!this.sourceLocator.isEmpty()) {
            wc.setAttribute("org.eclipse.debug.core.source_locator_memento", this.sourceLocator);
        }
        this.fLaunch = wc.doSave().launch("debug", null);
        this.isTerminating = false;
        if (this.fLaunch instanceof GdbLaunch) {
            this.fSessionId = ((GdbLaunch)this.fLaunch).getSession().getId();
        }
        this.fDsfSession = ((GdbLaunch)this.fLaunch).getSession();
        this.fDsfSession.addServiceEventListener((Object)this, null);
        this.fNumberOfFrames = this.findNumFrames();
    }

    public void dispose() {
        if (this.fLaunch != null && this.fLaunch.canTerminate() && !this.isTerminating) {
            this.isTerminating = true;
            try {
                this.fLaunch.terminate();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
            this.fLaunch = null;
        }
    }

    public int getNumberOfFrames() {
        if (this.fNumberOfFrames == 0) {
            this.fNumberOfFrames = this.findNumFrames();
        }
        return this.fNumberOfFrames;
    }

    public synchronized GdbTraceEvent selectAndReadFrame(long rank) {
        GdbTraceEvent event;
        long ts;
        if (this.fTpInfo.isEmpty()) {
            this.getTracepointInfo();
        }
        if (this.selectDataFrame(rank, false) && (ts = (event = this.getTraceFrameData(rank)).getTimestamp().getValue()) == rank) {
            return event;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private void getTracepointInfo() {
        final DsfExecutor executor = DsfSession.getSession((String)this.fSessionId).getExecutor();
        final DsfServicesTracker tracker = new DsfServicesTracker(GdbTraceCorePlugin.getBundleContext(), this.fSessionId);
        Query<Object> selectRecordQuery = new Query<Object>(){

            public void execute(final DataRequestMonitor<Object> drm) {
                IMIProcesses procService = (IMIProcesses)tracker.getService(IMIProcesses.class);
                final ICommandControlService cmdControl = (ICommandControlService)tracker.getService(ICommandControlService.class);
                if (procService == null || cmdControl == null) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Could not find necessary services", null));
                    drm.done();
                    return;
                }
                IGDBTraceControl.ITraceTargetDMContext context = (IGDBTraceControl.ITraceTargetDMContext)cmdControl.getContext();
                ICommandControlService.ICommandControlDMContext cmdControlDMC = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)context, ICommandControlService.ICommandControlDMContext.class);
                procService.getProcessesBeingDebugged((IDMContext)cmdControlDMC, (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>((Executor)executor, drm){

                    protected void handleSuccess() {
                        if (!$assertionsDisabled && this.getData() == null) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && ((IDMContext[])this.getData()).length != 1) {
                            throw new AssertionError();
                        }
                        if (this.getData() == null || ((IDMContext[])this.getData()).length < 1) {
                            drm.done();
                            return;
                        }
                        IRunControl.IContainerDMContext containerDMC = (IRunControl.IContainerDMContext)((IDMContext[])this.getData())[0];
                        IBreakpoints.IBreakpointsTargetDMContext bpTargetDMC = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)containerDMC, IBreakpoints.IBreakpointsTargetDMContext.class);
                        CommandFactory cmdFactory = ((IMICommandControl)tracker.getService(IMICommandControl.class)).getCommandFactory();
                        IBreakpoints bpService = (IBreakpoints)tracker.getService(MIBreakpoints.class);
                        if (cmdFactory == null || bpService == null) {
                            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Could not find necessary services", null));
                            drm.done();
                            return;
                        }
                        cmdControl.queueCommand(cmdFactory.createMIBreakList(bpTargetDMC), (DataRequestMonitor)new DataRequestMonitor<MIBreakListInfo>((Executor)executor, (RequestMonitor)drm){

                            protected void handleSuccess() {
                                MIBreakpoint[] breakpoints = ((MIBreakListInfo)this.getData()).getMIBreakpoints();
                                int i = 0;
                                while (i < breakpoints.length) {
                                    MIBreakpointDMData breakpoint = new MIBreakpointDMData(breakpoints[i]);
                                    String type = breakpoint.getBreakpointType();
                                    if (type.compareTo("tracepoint") == 0) {
                                        DsfGdbAdaptor.this.fTpInfo.put(new Integer(breakpoint.getReference()), breakpoint);
                                    }
                                    ++i;
                                }
                                drm.done();
                            }
                        });
                    }
                });
            }
        };
        try {
            try {
                executor.execute((Runnable)selectRecordQuery);
                selectRecordQuery.get();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                tracker.dispose();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                tracker.dispose();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                tracker.dispose();
            }
        }
        finally {
            tracker.dispose();
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized int findNumFrames() {
        frameNum = 0;
        if (DsfSession.getSession((String)this.fSessionId) == null) {
            return 0;
        }
        executor = DsfSession.getSession((String)this.fSessionId).getExecutor();
        tracker = new DsfServicesTracker(GdbTraceCorePlugin.getBundleContext(), this.fSessionId);
        selectRecordQuery = new Query<IGDBTraceControl.ITraceStatusDMData>(){

            public void execute(DataRequestMonitor<IGDBTraceControl.ITraceStatusDMData> queryRm) {
                IGDBTraceControl traceControl = (IGDBTraceControl)tracker.getService(IGDBTraceControl.class);
                ICommandControlService commandControl = (ICommandControlService)tracker.getService(ICommandControlService.class);
                IGDBTraceControl.ITraceTargetDMContext dmc = (IGDBTraceControl.ITraceTargetDMContext)commandControl.getContext();
                if (traceControl != null) {
                    traceControl.getTraceStatus(dmc, queryRm);
                } else {
                    queryRm.done();
                }
            }
        };
        try {
            try {
                executor.execute((Runnable)selectRecordQuery);
                data = (IGDBTraceControl.ITraceStatusDMData)selectRecordQuery.get();
                frameNum = data.getNumberOfCollectedFrame();
            }
            catch (InterruptedException v0) {
                tracker.dispose();
            }
            catch (ExecutionException v1) {
                ** try [egrp 2[TRYBLOCK] [4 : 88->89)] { 
lbl18:
                // 1 sources

                tracker.dispose();
            }
            catch (RejectedExecutionException v2) {
                ** try [egrp 3[TRYBLOCK] [5 : 96->97)] { 
lbl-1000:
                // 2 sources

                {
                    catch (Throwable var6_6) {
                        throw var6_6;
                    }
                }
lbl24:
                // 1 sources

                tracker.dispose();
            }
        }
        finally {
            tracker.dispose();
        }
        return frameNum;
    }

    /*
     * Loose catch block
     */
    public boolean selectDataFrame(final long rank, final boolean update) {
        boolean status = true;
        final DsfSession dsfSession = DsfSession.getSession((String)this.fSessionId);
        if (dsfSession == null) {
            return false;
        }
        if (update) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                    int n = iWorkbenchWindowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchWindow wbWindow = iWorkbenchWindowArray[n2];
                        IWorkbenchPage[] iWorkbenchPageArray = wbWindow.getPages();
                        int n3 = iWorkbenchPageArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Viewer viewer;
                            IWorkbenchPage wbPage = iWorkbenchPageArray[n4];
                            IViewPart vp = wbPage.findView("org.eclipse.debug.ui.DebugView");
                            if (vp instanceof AbstractDebugView && (viewer = ((AbstractDebugView)vp).getViewer()) instanceof ITreeModelViewer) {
                                ((ITreeModelViewer)viewer).setSelection((ISelection)StructuredSelection.EMPTY, false, true);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            });
        }
        DsfExecutor executor = dsfSession.getExecutor();
        final DsfServicesTracker tracker = new DsfServicesTracker(GdbTraceCorePlugin.getBundleContext(), this.fSessionId);
        Query<Object> selectRecordQuery = new Query<Object>(){

            public void execute(DataRequestMonitor<Object> queryRm) {
                IGDBTraceControl traceControl = (IGDBTraceControl)tracker.getService(IGDBTraceControl.class);
                ICommandControlService commandControl = (ICommandControlService)tracker.getService(ICommandControlService.class);
                IGDBTraceControl.ITraceTargetDMContext dmc = (IGDBTraceControl.ITraceTargetDMContext)commandControl.getContext();
                if (traceControl != null) {
                    IGDBTraceControl.ITraceRecordDMContext newCtx = traceControl.createTraceRecordContext(dmc, Integer.toString((int)rank));
                    if (update) {
                        dsfSession.dispatchEvent((Object)new GDBTraceControl_7_2.TraceRecordSelectedChangedEvent(newCtx), new Hashtable());
                    }
                    traceControl.selectTraceRecord(newCtx, queryRm);
                } else {
                    queryRm.done();
                }
            }
        };
        try {
            try {
                executor.execute((Runnable)selectRecordQuery);
                selectRecordQuery.get();
            }
            catch (InterruptedException interruptedException) {
                status = false;
                tracker.dispose();
            }
            catch (ExecutionException executionException) {
                status = false;
                tracker.dispose();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                status = false;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                tracker.dispose();
            }
        }
        finally {
            tracker.dispose();
        }
        return status;
    }

    private GdbTraceEvent getTraceFrameData(long rank) {
        if (DsfSession.getSession((String)this.fSessionId) == null) {
            return null;
        }
        final DsfExecutor executor = DsfSession.getSession((String)this.fSessionId).getExecutor();
        final DsfServicesTracker tracker = new DsfServicesTracker(GdbTraceCorePlugin.getBundleContext(), this.fSessionId);
        Query<IGDBTraceControl.ITraceRecordDMData> getFrameDataQuery = new Query<IGDBTraceControl.ITraceRecordDMData>(){

            public void execute(final DataRequestMonitor<IGDBTraceControl.ITraceRecordDMData> rm) {
                final IGDBTraceControl traceControl = (IGDBTraceControl)tracker.getService(IGDBTraceControl.class);
                ICommandControlService commandControl = (ICommandControlService)tracker.getService(ICommandControlService.class);
                IGDBTraceControl.ITraceTargetDMContext dmc = (IGDBTraceControl.ITraceTargetDMContext)commandControl.getContext();
                if (traceControl != null) {
                    traceControl.getCurrentTraceRecordContext(dmc, (DataRequestMonitor)new DataRequestMonitor<IGDBTraceControl.ITraceRecordDMContext>((Executor)executor, rm){

                        protected void handleSuccess() {
                            traceControl.getTraceRecordData((IGDBTraceControl.ITraceRecordDMContext)this.getData(), rm);
                        }
                    });
                } else {
                    rm.done();
                }
            }
        };
        try {
            GdbTraceEvent ev;
            MIBreakpointDMData bp;
            executor.execute((Runnable)getFrameDataQuery);
            IGDBTraceControl.ITraceRecordDMData data = (IGDBTraceControl.ITraceRecordDMData)getFrameDataQuery.get();
            if (data == null) {
                return null;
            }
            String ts = data.getTimestamp();
            if (ts == null) {
                ts = "0";
            }
            String tmfEventRef = (bp = this.fTpInfo.get(Integer.valueOf(data.getTracepointNumber()))) != null ? String.valueOf(bp.getFileName()) + ":" + bp.getLineNumber() + " :: " + bp.getFunctionName() : this.tracedExecutable;
            GdbTraceEventContent evContent = new GdbTraceEventContent(data.getContent(), Integer.parseInt(data.getTracepointNumber()), Integer.parseInt(data.getRecordId()));
            GdbTraceEvent gdbTraceEvent = ev = new GdbTraceEvent(this.fGdbTrace, (ITmfTimestamp)new TmfTimestamp((long)Integer.parseInt(data.getRecordId())), "Tracepoint: " + data.getTracepointNumber() + ", Frame: " + data.getRecordId(), (ITmfEventType)this.tmfEventType, (ITmfEventField)evContent, tmfEventRef);
            return gdbTraceEvent;
        }
        catch (InterruptedException interruptedException) {
            GdbTraceEvent gdbTraceEvent = this.createExceptionEvent(rank, "Interruption exception");
            return gdbTraceEvent;
        }
        catch (ExecutionException executionException) {
            GdbTraceEvent gdbTraceEvent = this.createExceptionEvent(rank, "GDB exception");
            return gdbTraceEvent;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            GdbTraceEvent gdbTraceEvent = this.createExceptionEvent(rank, "Request rejected exception");
            return gdbTraceEvent;
        }
        catch (Exception exception) {
            GdbTraceEvent gdbTraceEvent = this.createExceptionEvent(rank, "General exception");
            return gdbTraceEvent;
        }
        finally {
            tracker.dispose();
        }
    }

    private GdbTraceEvent createExceptionEvent(long rank, String message) {
        String tmfEventSrc;
        String tmfEventRef;
        MIBreakpointDMData bp = this.fTpInfo.get(rank);
        if (bp != null) {
            tmfEventRef = String.valueOf(bp.getFileName()) + ":" + bp.getLineNumber() + " :: " + bp.getFunctionName();
            tmfEventSrc = String.valueOf(bp.getFileName()) + " :: " + bp.getFunctionName() + ", line: " + bp.getLineNumber();
        } else {
            tmfEventRef = this.tracedExecutable;
            tmfEventSrc = "Tracepoint: n/a";
        }
        GdbTraceEventContent evContent = new GdbTraceEventContent("ERROR: " + message, 0, 0);
        GdbTraceEvent ev = new GdbTraceEvent(this.fGdbTrace, (ITmfTimestamp)new TmfTimestamp(rank), tmfEventSrc, (ITmfEventType)this.tmfEventType, (ITmfEventField)evContent, tmfEventRef);
        return ev;
    }

    public String getSessionId() {
        return this.fSessionId;
    }

    @DsfServiceEventHandler
    public void handleDSFRecordSelectedEvents(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent event) {
        GDBTraceControl_7_2.TraceRecordSelectedChangedEvent traceEvent;
        IGDBTraceControl.ITraceRecordDMContext context;
        String reference;
        if (event instanceof GDBTraceControl_7_2.TraceRecordSelectedChangedEvent && (reference = (context = (IGDBTraceControl.ITraceRecordDMContext)(traceEvent = (GDBTraceControl_7_2.TraceRecordSelectedChangedEvent)event).getDMContext()).getRecordId()) != null) {
            int recordId = Integer.parseInt(reference);
            DsfGdbAdaptor.selectGdbTraceEditor(context.getSessionId(), recordId);
        }
    }

    private static void closeGdbTraceEditor(final String sessionId) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow wbWindow = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = wbWindow.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage wbPage = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = wbPage.getEditorReferences();
                        int n5 = iEditorReferenceArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ITmfTrace trace;
                            IEditorReference editorReference = iEditorReferenceArray[n6];
                            IEditorPart editor = editorReference.getEditor(false);
                            if (editor instanceof ITmfTraceEditor && (trace = ((ITmfTraceEditor)editor).getTrace()) instanceof GdbTrace && ((GdbTrace)trace).getDsfSessionId().equals(sessionId)) {
                                wbPage.closeEditor(editor, false);
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
    }

    private static void selectGdbTraceEditor(final String sessionId, final int recordId) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow wbWindow = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = wbWindow.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage wbPage = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = wbPage.getEditorReferences();
                        int n5 = iEditorReferenceArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference editorReference = iEditorReferenceArray[n6];
                            IEditorPart editor = editorReference.getEditor(false);
                            if (editor instanceof ITmfTraceEditor) {
                                ITmfTrace trace = ((ITmfTraceEditor)editor).getTrace();
                                if (trace instanceof GdbTrace) {
                                    if (((GdbTrace)trace).getDsfSessionId().equals(sessionId)) {
                                        wbPage.bringToTop((IWorkbenchPart)editor);
                                        if (recordId != -1) {
                                            DsfGdbAdaptor.gotoRank(editor, recordId);
                                        }
                                        return;
                                    }
                                } else if (trace instanceof TmfExperiment) {
                                    TmfExperiment experiment = (TmfExperiment)trace;
                                    int nbTraces = experiment.getTraces().length;
                                    int i = 0;
                                    while (i < nbTraces) {
                                        GdbTrace gdbTrace = (GdbTrace)experiment.getTraces()[i];
                                        if (gdbTrace.getDsfSessionId().equals(sessionId)) {
                                            wbPage.bringToTop((IWorkbenchPart)editor);
                                            if (recordId != -1) {
                                                int rank = recordId * nbTraces + i;
                                                DsfGdbAdaptor.gotoRank(editor, rank);
                                            }
                                            return;
                                        }
                                        ++i;
                                    }
                                }
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
    }

    private static void gotoRank(IEditorPart editor, int rank) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editorInput).getFile();
            try {
                IMarker marker = file.createMarker("org.eclipse.core.resources.marker");
                marker.setAttribute("location", (Object)rank);
                IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                marker.delete();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private static class DsfGdbPlatformEventListener
    implements ILaunchesListener2,
    IDebugContextListener {
        private String fCurrentSessionId = "";

        public DsfGdbPlatformEventListener() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)DsfGdbPlatformEventListener.this);
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                    DebugUITools.getDebugContextManager().getContextService(win).addDebugContextListener((IDebugContextListener)DsfGdbPlatformEventListener.this);
                }
            });
        }

        public synchronized void launchesRemoved(ILaunch[] launches) {
        }

        public synchronized void launchesAdded(ILaunch[] launches) {
        }

        public synchronized void launchesChanged(ILaunch[] launches) {
        }

        public synchronized void launchesTerminated(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                String sessionId = ((GdbLaunch)launch).getSession().getId();
                DsfGdbAdaptor.closeGdbTraceEditor(sessionId);
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void debugContextChanged(DebugContextEvent event) {
            ISelection selection = event.getContext();
            if (selection instanceof IStructuredSelection) {
                List eventContextList = ((IStructuredSelection)selection).toList();
                for (Object eventContext : eventContextList) {
                    String sessionId;
                    IDMContext context;
                    if (!(eventContext instanceof IAdaptable) || (context = (IDMContext)((IAdaptable)eventContext).getAdapter(IDMContext.class)) == null) continue;
                    String string = this.fCurrentSessionId;
                    synchronized (string) {
                        sessionId = context.getSessionId();
                        if (sessionId.equals(this.fCurrentSessionId)) {
                            return;
                        }
                    }
                    this.fCurrentSessionId = sessionId;
                    DsfExecutor executor = DsfSession.getSession((String)sessionId).getExecutor();
                    final DsfServicesTracker tracker = new DsfServicesTracker(GdbTraceCorePlugin.getBundleContext(), sessionId);
                    Query<IGDBTraceControl.ITraceRecordDMContext> getCurrentRecordQuery = new Query<IGDBTraceControl.ITraceRecordDMContext>(){

                        public void execute(DataRequestMonitor<IGDBTraceControl.ITraceRecordDMContext> queryRm) {
                            IGDBTraceControl traceControl = (IGDBTraceControl)tracker.getService(IGDBTraceControl.class);
                            ICommandControlService commandControl = (ICommandControlService)tracker.getService(ICommandControlService.class);
                            if (traceControl != null && commandControl != null) {
                                IGDBTraceControl.ITraceTargetDMContext traceContext = (IGDBTraceControl.ITraceTargetDMContext)commandControl.getContext();
                                traceControl.getCurrentTraceRecordContext(traceContext, queryRm);
                            } else {
                                queryRm.done();
                            }
                        }
                    };
                    try {
                        executor.execute((Runnable)getCurrentRecordQuery);
                        IGDBTraceControl.ITraceRecordDMContext record = (IGDBTraceControl.ITraceRecordDMContext)getCurrentRecordQuery.get();
                        if (record == null || record.getRecordId() == null) continue;
                        int recordId = Integer.parseInt(record.getRecordId());
                        DsfGdbAdaptor.selectGdbTraceEditor(sessionId, recordId);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                    }
                    finally {
                        tracker.dispose();
                    }
                }
            }
        }
    }
}

