/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.search;

import java.util.StringTokenizer;
import org.eclipse.dltk.internal.ui.search.DLTKElementMatch;
import org.eclipse.dltk.internal.ui.search.DLTKSearchQuery;
import org.eclipse.dltk.internal.ui.search.PotentialFilter;
import org.eclipse.dltk.internal.ui.search.ReadFilter;
import org.eclipse.dltk.internal.ui.search.ScriptdocFilter;
import org.eclipse.dltk.internal.ui.search.WriteFilter;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;

abstract class DLTKMatchFilter
extends MatchFilter {
    private static final String SETTINGS_LAST_USED_FILTERS = "filters_last_used";
    private static final DLTKMatchFilter POTENTIAL_FILTER = new PotentialFilter();
    private static final DLTKMatchFilter SCRIPTDOC_FILTER = new ScriptdocFilter();
    private static final DLTKMatchFilter READ_FILTER = new ReadFilter();
    private static final DLTKMatchFilter WRITE_FILTER = new WriteFilter();
    private static final DLTKMatchFilter[] ALL_FILTERS = new DLTKMatchFilter[]{POTENTIAL_FILTER, SCRIPTDOC_FILTER, READ_FILTER, WRITE_FILTER};

    DLTKMatchFilter() {
    }

    public static DLTKMatchFilter[] getLastUsedFilters() {
        String string = DLTKUIPlugin.getDefault().getDialogSettings().get(SETTINGS_LAST_USED_FILTERS);
        if (string != null && string.length() > 0) {
            return DLTKMatchFilter.decodeFiltersString(string);
        }
        return DLTKMatchFilter.getDefaultFilters();
    }

    public static void setLastUsedFilters(DLTKMatchFilter[] filters) {
        String encoded = DLTKMatchFilter.encodeFilters(filters);
        DLTKUIPlugin.getDefault().getDialogSettings().put(SETTINGS_LAST_USED_FILTERS, encoded);
    }

    public static DLTKMatchFilter[] getDefaultFilters() {
        return new DLTKMatchFilter[]{POTENTIAL_FILTER};
    }

    private static String encodeFilters(DLTKMatchFilter[] enabledFilters) {
        StringBuffer buf = new StringBuffer();
        buf.append(enabledFilters.length);
        int i = 0;
        while (i < enabledFilters.length) {
            buf.append(';');
            buf.append(enabledFilters[i].getID());
            ++i;
        }
        return buf.toString();
    }

    private static DLTKMatchFilter[] decodeFiltersString(String encodedString) {
        StringTokenizer tokenizer = new StringTokenizer(encodedString, String.valueOf(';'));
        int count = Integer.valueOf(tokenizer.nextToken());
        DLTKMatchFilter[] res = new DLTKMatchFilter[count];
        int i = 0;
        while (i < count) {
            res[i] = DLTKMatchFilter.findMatchFilter(tokenizer.nextToken());
            ++i;
        }
        return res;
    }

    public boolean filters(Match match) {
        if (match instanceof DLTKElementMatch) {
            return this.filters((DLTKElementMatch)match);
        }
        return false;
    }

    public abstract boolean isApplicable(DLTKSearchQuery var1);

    public abstract boolean filters(DLTKElementMatch var1);

    public static DLTKMatchFilter[] allFilters() {
        return ALL_FILTERS;
    }

    private static DLTKMatchFilter findMatchFilter(String id) {
        int i = 0;
        while (i < ALL_FILTERS.length) {
            if (ALL_FILTERS[i].getID().equals(id)) {
                return ALL_FILTERS[i];
            }
            ++i;
        }
        return POTENTIAL_FILTER;
    }
}

