/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludePreferences;
import org.eclipse.cdt.internal.ui.refactoring.includes.InclusionContext;
import org.eclipse.core.runtime.CoreException;

public class BindingClassifier {
    private final InclusionContext fContext;
    private final IncludePreferences fPreferences;
    private final Set<IBinding> fBindingsToDefine;
    private final Set<IBinding> fBindingsToDeclare;
    private IASTTranslationUnit fAst;
    private final BindingCollector fBindingCollector;
    private final Set<IBinding> fProcessedDefinedBindings;
    private final Set<IBinding> fProcessedDeclaredBindings;

    public BindingClassifier(InclusionContext context) {
        this.fContext = context;
        this.fPreferences = context.getPreferences();
        this.fBindingsToDefine = new HashSet<IBinding>();
        this.fBindingsToDeclare = new HashSet<IBinding>();
        this.fProcessedDefinedBindings = new HashSet<IBinding>();
        this.fProcessedDeclaredBindings = new HashSet<IBinding>();
        this.fBindingCollector = new BindingCollector();
    }

    public void classifyNodeContents(IASTNode node) {
        if (this.fAst == null) {
            this.fAst = node.getTranslationUnit();
        }
        node.accept((ASTVisitor)this.fBindingCollector);
    }

    public Set<IBinding> getBindingsToDefine() {
        return this.fBindingsToDefine;
    }

    public Set<IBinding> getBindingsToDeclare() {
        return this.fBindingsToDeclare;
    }

    private void processParameters(IParameter[] declaredParameters, IASTInitializerClause[] arguments) {
        int i = 0;
        while (i < declaredParameters.length) {
            IType declaredParameterType = declaredParameters[i].getType();
            IType actualParameterType = null;
            boolean canBeDeclared = false;
            if (declaredParameterType instanceof IPointerType || declaredParameterType instanceof ICPPReferenceType) {
                declaredParameterType = SemanticUtil.getNestedType((IType)declaredParameterType, (int)4);
                if (i < arguments.length) {
                    IASTInitializerClause actualParameter = arguments[i];
                    if (actualParameter instanceof IASTExpression) {
                        actualParameterType = ((IASTExpression)actualParameter).getExpressionType();
                        if (this.isSameType(declaredParameterType, actualParameterType = SemanticUtil.getNestedType((IType)actualParameterType, (int)4))) {
                            canBeDeclared = true;
                        }
                    }
                } else {
                    canBeDeclared = true;
                }
            }
            if (canBeDeclared) {
                this.declareType(declaredParameterType);
            } else {
                this.defineTypeExceptTypedefOrNonFixedEnum(declaredParameterType);
                this.defineTypeExceptTypedefOrNonFixedEnum(actualParameterType);
            }
            ++i;
        }
    }

    private boolean isSameType(IType type1, IType type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        if (type1.isSameType(type2)) {
            return true;
        }
        return (type1 instanceof IPointerType || type2 instanceof IPointerType) && (type1 instanceof IBasicType && ((IBasicType)type1).getKind() == IBasicType.Kind.eInt || type2 instanceof IBasicType && ((IBasicType)type2).getKind() == IBasicType.Kind.eInt);
    }

    private List<IBinding> getRequiredBindings(IBinding binding) {
        ArrayList<IBinding> bindings = new ArrayList<IBinding>();
        if (binding instanceof ICPPMember) {
            binding = binding.getOwner();
        } else if (binding instanceof IVariable) {
            if (binding instanceof ICPPSpecialization) {
                bindings.add(((ICPPSpecialization)binding).getSpecializedBinding());
            } else {
                bindings.add(binding);
            }
            binding = this.getTypeBinding(((IVariable)binding).getType());
        } else if (binding instanceof IType) {
            binding = this.getTypeBinding((IType)binding);
        } else if (binding instanceof ICPPNamespace) {
            binding = null;
        }
        if (binding instanceof ICPPSpecialization) {
            binding = ((ICPPSpecialization)binding).getSpecializedBinding();
        }
        if (binding instanceof IProblemBinding) {
            IProblemBinding problemBinding = (IProblemBinding)binding;
            IBinding[] candidateBindings = problemBinding.getCandidateBindings();
            if (candidateBindings.length > 0) {
                IBinding[] iBindingArray = candidateBindings;
                int n = candidateBindings.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinding candidateBinding = iBindingArray[n2];
                    bindings.add(candidateBinding);
                    ++n2;
                }
            } else {
                try {
                    IIndexMacro[] indexMacros;
                    IIndexMacro[] iIndexMacroArray = indexMacros = this.fContext.getIndex().findMacros(binding.getNameCharArray(), IndexFilter.ALL, null);
                    int n = indexMacros.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IIndexMacro indexMacro = iIndexMacroArray[n3];
                        bindings.add((IBinding)indexMacro);
                        ++n3;
                    }
                }
                catch (CoreException coreException) {}
            }
        } else if (binding != null) {
            bindings.add(binding);
        }
        return bindings;
    }

    private IBinding getTypeBinding(IType type) {
        if ((type = SemanticUtil.getNestedType((IType)type, (int)180)) instanceof IBinding) {
            return (IBinding)type;
        }
        return null;
    }

    private void declareBinding(IBinding binding) {
        if (this.fProcessedDefinedBindings.contains(binding)) {
            return;
        }
        if (!this.canForwardDeclare(binding)) {
            this.defineBinding(binding);
        }
        if (!this.fProcessedDeclaredBindings.add(binding)) {
            return;
        }
        List<IBinding> requiredBindings = this.getRequiredBindings(binding);
        for (IBinding requiredBinding : requiredBindings) {
            if (this.fBindingsToDeclare.contains(requiredBinding) || this.fBindingsToDefine.contains(requiredBinding)) {
                return;
            }
            if (this.fAst.getDefinitionsInAST(requiredBinding).length != 0) {
                return;
            }
            if (this.fAst.getDeclarationsInAST(requiredBinding).length != 0) {
                return;
            }
            if (this.canForwardDeclare(requiredBinding)) {
                this.fBindingsToDeclare.add(requiredBinding);
                continue;
            }
            this.fBindingsToDefine.add(requiredBinding);
        }
    }

    private boolean canForwardDeclare(IBinding binding) {
        boolean canDeclare = false;
        if (binding instanceof ICompositeType) {
            canDeclare = this.fPreferences.forwardDeclareCompositeTypes;
        } else if (binding instanceof IEnumeration) {
            canDeclare = this.fPreferences.forwardDeclareEnums;
        } else if (binding instanceof IFunction && !(binding instanceof ICPPMethod)) {
            canDeclare = this.fPreferences.forwardDeclareFunctions;
        } else if (binding instanceof IVariable) {
            canDeclare = this.fPreferences.forwardDeclareExternalVariables;
        }
        if (canDeclare && !this.fPreferences.forwardDeclareTemplates && binding instanceof ICPPTemplateDefinition) {
            canDeclare = false;
        }
        return canDeclare;
    }

    private void declareType(IType type) {
        IBinding typeBinding = this.getTypeBinding(type);
        if (typeBinding != null) {
            this.declareBinding(typeBinding);
        }
    }

    private void defineTypeExceptTypedefOrNonFixedEnum(IType type) {
        IBinding typeBinding = this.getTypeBinding(type);
        if (typeBinding != null && !(typeBinding instanceof ITypedef) && !this.isEnumerationWithoutFixedUnderlyingType(typeBinding)) {
            this.defineBinding(typeBinding);
        }
    }

    private boolean isEnumerationWithoutFixedUnderlyingType(IBinding typeBinding) {
        return typeBinding instanceof IEnumeration && (!(typeBinding instanceof ICPPEnumeration) || ((ICPPEnumeration)typeBinding).getFixedType() == null);
    }

    private void defineBinding(IBinding binding) {
        if (!this.fProcessedDefinedBindings.add(binding)) {
            return;
        }
        if (this.fAst.getDefinitionsInAST(binding).length != 0) {
            return;
        }
        if (binding instanceof ICPPTemplateInstance) {
            this.defineTemplateArguments((ICPPTemplateInstance)binding);
        }
        List<IBinding> requiredBindings = this.getRequiredBindings(binding);
        for (IBinding requiredBinding : requiredBindings) {
            this.fBindingsToDeclare.remove(requiredBinding);
            this.fBindingsToDefine.add(requiredBinding);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void defineTemplateArguments(ICPPTemplateInstance instance) {
        templateDefinition = instance.getTemplateDefinition();
        templateParameters = templateDefinition.getTemplateParameters();
        templateArguments = instance.getTemplateArguments();
        i = 0;
        while (i < templateArguments.length) {
            block4: {
                argument = templateArguments[i];
                parameter = templateParameters[i];
                parameterDefault = parameter.getDefaultValue();
                if (parameterDefault == null) ** GOTO lbl-1000
                if (argument.isSameValue(parameterDefault)) break block4;
                if (!argument.isTypeValue() || !parameterDefault.isTypeValue()) ** GOTO lbl-1000
                argType = argument.getTypeValue();
                defType = parameterDefault.getTypeValue();
                if (argType instanceof ICPPTemplateInstance && defType instanceof ICPPTemplateInstance && (argTemplate = (IType)((ICPPTemplateInstance)argType).getTemplateDefinition()).isSameType(defTemplate = (IType)((ICPPTemplateInstance)defType).getTemplateDefinition())) {
                    this.defineTemplateArguments((ICPPTemplateInstance)argType);
                } else if (!((type = argument.getTypeValue()) instanceof IPointerType) && !(type instanceof ICPPReferenceType) && (binding = this.getTypeBinding(type)) != null) {
                    this.defineBinding(binding);
                }
            }
            ++i;
        }
    }

    private void declareFunction(IFunction function, IASTFunctionCallExpression functionCallExpression) {
        IType returnType = function.getType().getReturnType();
        if (!(returnType instanceof IPointerType) && !(returnType instanceof ICPPReferenceType)) {
            this.defineTypeExceptTypedefOrNonFixedEnum(returnType);
        }
        this.processParameters(function.getParameters(), functionCallExpression.getArguments());
    }

    private class BindingCollector
    extends ASTVisitor {
        BindingCollector() {
            super(true);
            this.shouldVisitImplicitNames = true;
        }

        public int visit(IASTDeclaration declaration) {
            block8: {
                IBinding binding;
                block7: {
                    if (!(declaration instanceof IASTSimpleDeclaration)) break block7;
                    IASTSimpleDeclaration simpleDeclaration = (IASTSimpleDeclaration)declaration;
                    IASTDeclSpecifier declSpecifier = simpleDeclaration.getDeclSpecifier();
                    IASTDeclarator[] declarators = simpleDeclaration.getDeclarators();
                    if (!(declSpecifier instanceof IASTNamedTypeSpecifier)) break block8;
                    boolean staticMember = simpleDeclaration.getParent() instanceof IASTCompositeTypeSpecifier && declSpecifier.getStorageClass() == 3;
                    boolean canBeDeclared = true;
                    if (!staticMember) {
                        IASTDeclarator[] iASTDeclaratorArray = declarators;
                        int n = declarators.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IASTDeclarator declarator = iASTDeclaratorArray[n2];
                            if (!(declarator instanceof IASTFunctionDeclarator) && declarator.getPointerOperators().equals(IASTPointerOperator.EMPTY_ARRAY)) {
                                canBeDeclared = false;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (canBeDeclared) break block8;
                    BindingClassifier.this.defineBinding(((IASTNamedTypeSpecifier)declSpecifier).getName().resolveBinding());
                    break block8;
                }
                if (declaration instanceof IASTFunctionDefinition && (binding = ((IASTFunctionDefinition)declaration).getDeclarator().getName().resolveBinding()) instanceof IFunction) {
                    IType[] parameterTypes;
                    IFunction function = (IFunction)binding;
                    IType returnType = function.getType().getReturnType();
                    if (!(returnType instanceof IPointerType) && !(returnType instanceof ICPPReferenceType)) {
                        BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(returnType);
                    }
                    IType[] iTypeArray = parameterTypes = function.getType().getParameterTypes();
                    int n = parameterTypes.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IType type = iTypeArray[n3];
                        if (!(type instanceof IPointerType) && !(type instanceof ICPPReferenceType)) {
                            BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(type);
                        }
                        ++n3;
                    }
                }
            }
            return 3;
        }

        public int visit(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier) {
            BindingClassifier.this.defineBinding(baseSpecifier.getName().resolveBinding());
            return 3;
        }

        public int visit(IASTInitializer initializer) {
            IASTInitializer memberNode = initializer;
            IASTName memberName = null;
            IBinding memberBinding = null;
            while (memberNode != null) {
                if (memberNode instanceof IASTDeclarator) {
                    memberName = ((IASTDeclarator)memberNode).getName();
                    break;
                }
                if (memberNode instanceof ICPPASTConstructorChainInitializer) {
                    memberName = ((ICPPASTConstructorChainInitializer)memberNode).getMemberInitializerId();
                    break;
                }
                memberNode = memberNode.getParent();
            }
            if (memberName != null) {
                memberBinding = memberName.resolveBinding();
            }
            IASTInitializerClause[] actualParameters = new IASTInitializerClause[]{};
            if (initializer instanceof ICPPASTConstructorInitializer) {
                ICPPASTConstructorInitializer constructorInitializer = (ICPPASTConstructorInitializer)initializer;
                actualParameters = constructorInitializer.getArguments();
            } else if (initializer instanceof IASTEqualsInitializer) {
                IASTEqualsInitializer equalsInitializer = (IASTEqualsInitializer)initializer;
                actualParameters = new IASTInitializerClause[]{equalsInitializer.getInitializerClause()};
            }
            if (memberBinding instanceof IVariable) {
                IType memberType = ((IVariable)memberBinding).getType();
                if (!(memberType instanceof IPointerType) && !(memberType instanceof ICPPReferenceType)) {
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(memberType);
                } else {
                    memberType = SemanticUtil.getNestedType((IType)memberType, (int)4);
                    IASTInitializerClause[] iASTInitializerClauseArray = actualParameters;
                    int n = actualParameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType parameterType;
                        IASTInitializerClause actualParameter = iASTInitializerClauseArray[n2];
                        if (actualParameter instanceof IASTExpression && !BindingClassifier.this.isSameType(memberType, parameterType = ((IASTExpression)actualParameter).getExpressionType())) {
                            BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(memberType);
                            BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(parameterType);
                        }
                        ++n2;
                    }
                }
            } else if (memberBinding instanceof ICPPConstructor) {
                ICPPConstructor constructor = (ICPPConstructor)memberBinding;
                BindingClassifier.this.defineBinding(constructor.getOwner());
                BindingClassifier.this.processParameters((IParameter[])constructor.getParameters(), actualParameters);
            }
            return 3;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            if (declSpec instanceof IASTElaboratedTypeSpecifier) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            IASTSimpleDeclaration simpleDeclaration;
            IASTDeclSpecifier declSpecifier;
            ICPPASTCatchHandler catchHandler;
            IASTDeclaration declaration;
            if (statement instanceof IASTReturnStatement) {
                IASTReturnStatement returnStatement = (IASTReturnStatement)statement;
                IASTExpression returnValue = returnStatement.getReturnValue();
                if (returnValue != null) {
                    IBinding binding;
                    IASTFunctionDefinition functionDefinition;
                    IASTFunctionDeclarator functionDeclarator;
                    IASTReturnStatement functionDefinitionNode = returnStatement;
                    while (functionDefinitionNode != null && !(functionDefinitionNode instanceof IASTFunctionDefinition)) {
                        functionDefinitionNode = functionDefinitionNode.getParent();
                    }
                    if (functionDefinitionNode != null && (functionDeclarator = (functionDefinition = (IASTFunctionDefinition)functionDefinitionNode).getDeclarator()) != null && (binding = functionDeclarator.getName().resolveBinding()) instanceof IFunction) {
                        IType expressionType;
                        IFunction function = (IFunction)binding;
                        IType returnType = function.getType().getReturnType();
                        if (!BindingClassifier.this.isSameType(returnType = SemanticUtil.getNestedType((IType)returnType, (int)4), expressionType = SemanticUtil.getNestedType((IType)returnValue.getExpressionType(), (int)4))) {
                            BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(returnType);
                            BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(expressionType);
                        }
                    }
                }
            } else if (statement instanceof ICPPASTCatchHandler && (declaration = (catchHandler = (ICPPASTCatchHandler)statement).getDeclaration()) instanceof IASTSimpleDeclaration && (declSpecifier = (simpleDeclaration = (IASTSimpleDeclaration)declaration).getDeclSpecifier()) instanceof IASTNamedTypeSpecifier) {
                IASTNamedTypeSpecifier namedTypeSpecifier = (IASTNamedTypeSpecifier)declSpecifier;
                BindingClassifier.this.defineBinding(namedTypeSpecifier.getName().resolveBinding());
            }
            return 3;
        }

        public int visit(IASTExpression expression) {
            IType conditionExpressionType;
            ASTNodeProperty propertyInParent = expression.getPropertyInParent();
            if (!(propertyInParent != IASTIfStatement.CONDITION && propertyInParent != IASTForStatement.CONDITION && propertyInParent != IASTWhileStatement.CONDITIONEXPRESSION && propertyInParent != IASTDoStatement.CONDITION && propertyInParent != IASTConditionalExpression.LOGICAL_CONDITION || (conditionExpressionType = expression.getExpressionType()) instanceof IPointerType)) {
                BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(conditionExpressionType);
            }
            if (expression instanceof IASTIdExpression) {
                IType expressionType;
                IASTIdExpression idExpression = (IASTIdExpression)expression;
                IBinding binding = idExpression.getName().resolveBinding();
                if (binding instanceof IVariable && !((expressionType = ((IVariable)binding).getType()) instanceof IPointerType) && !(expressionType instanceof ICPPReferenceType)) {
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(expressionType);
                }
            } else if (expression instanceof IASTUnaryExpression) {
                IASTUnaryExpression unaryExpression = (IASTUnaryExpression)expression;
                boolean expressionDefinitionRequired = true;
                switch (unaryExpression.getOperator()) {
                    case 5: 
                    case 11: {
                        expressionDefinitionRequired = false;
                        break;
                    }
                    case 2: 
                    case 7: 
                    case 8: 
                    case 13: 
                    case 15: {
                        if (!(unaryExpression.getOperand().getExpressionType() instanceof IPointerType)) break;
                        expressionDefinitionRequired = false;
                    }
                }
                if (expressionDefinitionRequired) {
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(unaryExpression.getOperand().getExpressionType());
                }
            } else if (expression instanceof IASTBinaryExpression) {
                IASTBinaryExpression binaryExpression = (IASTBinaryExpression)expression;
                IType operand1Type = binaryExpression.getOperand1().getExpressionType();
                IType operand2Type = binaryExpression.getOperand2().getExpressionType();
                boolean expression1DefinitionRequired = true;
                boolean expression2DefinitionRequired = true;
                switch (binaryExpression.getOperator()) {
                    case 15: 
                    case 16: {
                        if (operand1Type instanceof IPointerType) {
                            expression1DefinitionRequired = false;
                        }
                        if (!(operand2Type instanceof IPointerType)) break;
                        expression2DefinitionRequired = false;
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 17: 
                    case 28: 
                    case 29: {
                        if (operand1Type instanceof IPointerType && operand2Type instanceof IPointerType) {
                            if (!BindingClassifier.this.isSameType(operand1Type, operand2Type)) break;
                            expression1DefinitionRequired = false;
                            expression2DefinitionRequired = false;
                            break;
                        }
                        if (operand1Type instanceof IPointerType) {
                            expression1DefinitionRequired = false;
                            break;
                        }
                        if (!(operand2Type instanceof IPointerType)) break;
                        expression2DefinitionRequired = false;
                    }
                }
                if (expression1DefinitionRequired) {
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(operand1Type);
                }
                if (expression2DefinitionRequired) {
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(operand2Type);
                }
            } else if (expression instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression functionCallExpression = (IASTFunctionCallExpression)expression;
                IASTExpression functionNameExpression = functionCallExpression.getFunctionNameExpression();
                if (functionNameExpression instanceof IASTIdExpression) {
                    IBinding binding = ((IASTIdExpression)functionNameExpression).getName().resolveBinding();
                    if (binding instanceof IFunction) {
                        BindingClassifier.this.declareFunction((IFunction)binding, functionCallExpression);
                    } else if (functionCallExpression instanceof IASTImplicitNameOwner) {
                        IASTImplicitName[] implicitNames;
                        IASTImplicitName[] iASTImplicitNameArray = implicitNames = ((IASTImplicitNameOwner)functionCallExpression).getImplicitNames();
                        int n = implicitNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IASTImplicitName name = iASTImplicitNameArray[n2];
                            binding = name.resolveBinding();
                            if (binding instanceof IFunction) {
                                BindingClassifier.this.declareFunction((IFunction)binding, functionCallExpression);
                            }
                            ++n2;
                        }
                    }
                }
            } else if (expression instanceof IASTFieldReference) {
                BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(((IASTFieldReference)expression).getFieldOwner().getExpressionType());
            } else if (expression instanceof ICPPASTNewExpression) {
                BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(((ICPPASTNewExpression)expression).getExpressionType());
            } else if (expression instanceof ICPPASTDeleteExpression) {
                BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(((ICPPASTDeleteExpression)expression).getOperand().getExpressionType());
            } else if (expression instanceof IASTCastExpression) {
                IType sourceType;
                IASTCastExpression castExpression = (IASTCastExpression)expression;
                IType targetType = castExpression.getExpressionType();
                if (!BindingClassifier.this.isSameType(targetType, sourceType = castExpression.getOperand().getExpressionType())) {
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(targetType);
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(sourceType);
                } else if (!(targetType instanceof IPointerType) && !(targetType instanceof ICPPReferenceType)) {
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(targetType);
                }
            }
            return 3;
        }

        public int visit(IASTName name) {
            IBinding binding;
            if (name instanceof ICPPASTQualifiedName) {
                IASTName[] names = ((ICPPASTQualifiedName)name).getNames();
                int i = 0;
                while (i < names.length - 1) {
                    BindingClassifier.this.defineBinding(names[i].resolveBinding());
                    ++i;
                }
            }
            if ((binding = name.resolveBinding()) != null) {
                IBinding owner = binding.getOwner();
                if (owner instanceof IType) {
                    BindingClassifier.this.defineBinding(owner);
                    if (binding instanceof IProblemBinding) {
                        BindingClassifier.this.declareBinding(binding);
                    }
                } else {
                    BindingClassifier.this.declareBinding(binding);
                }
            }
            return 3;
        }
    }
}

