/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import java.math.BigInteger;
import java.nio.ByteOrder;
import org.eclipse.linuxtools.ctf.core.event.types.Encoding;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;

public class IntegerDeclaration
implements IDeclaration {
    private final int length;
    private final boolean signed;
    private final int base;
    private final ByteOrder byteOrder;
    private final Encoding encoding;
    private final long alignment;
    private final String clock;

    public IntegerDeclaration(int len, boolean signed, int base, ByteOrder byteOrder, Encoding encoding, String clock, long alignment) {
        if (len <= 0 || len == 1 && signed) {
            throw new IllegalArgumentException();
        }
        this.length = len;
        this.signed = signed;
        this.base = base;
        this.byteOrder = byteOrder;
        this.encoding = encoding;
        this.clock = clock;
        this.alignment = alignment;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getBase() {
        return this.base;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public boolean isCharacter() {
        return this.length == 8 && this.encoding != Encoding.NONE;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public long getAlignment() {
        return this.alignment;
    }

    public String getClock() {
        return this.clock;
    }

    @Override
    public IntegerDefinition createDefinition(IDefinitionScope definitionScope, String fieldName) {
        return new IntegerDefinition(this, definitionScope, fieldName);
    }

    public String toString() {
        return "[declaration] integer[" + Integer.toHexString(this.hashCode()) + ']';
    }

    public BigInteger getMaxValue() {
        BigInteger capacity = BigInteger.ONE.shiftLeft(this.length);
        BigInteger max = this.signed ? capacity.divide(BigInteger.valueOf(2L)) : capacity;
        return max.subtract(BigInteger.ONE);
    }

    public BigInteger getMinValue() {
        if (!this.signed) {
            return BigInteger.ZERO;
        }
        BigInteger capacity = BigInteger.ONE.shiftLeft(this.length);
        return capacity.divide(BigInteger.valueOf(2L)).negate();
    }
}

