/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DiagramToolTip {
    private static final int CHARACTERS_PER_COLUMN = 100;
    private static final int DEFAULT_CURSOR_HEIGHT = 32;
    private Control fParent = null;
    private Shell fToolTipShell = null;
    private Text fTextBox = null;

    public DiagramToolTip(Control parent) {
        this.fParent = parent;
        this.fToolTipShell = new Shell(this.fParent.getShell(), 2);
        this.fToolTipShell.setBackground(Display.getDefault().getSystemColor(29));
        this.fTextBox = new Text((Composite)this.fToolTipShell, 66);
        this.fTextBox.setBackground(Display.getDefault().getSystemColor(29));
    }

    public void showToolTip(String value) {
        if (value == null || value.equalsIgnoreCase("")) {
            this.fToolTipShell.setVisible(false);
            return;
        }
        int w = this.fToolTipShell.getBounds().width;
        Point hr = Display.getDefault().getCursorLocation();
        int cursorH = 32;
        int i = 0;
        while (i < Display.getDefault().getCursorSizes().length) {
            if (Display.getDefault().getCursorSizes()[i].y < cursorH) {
                cursorH = Display.getDefault().getCursorSizes()[i].y;
            }
            ++i;
        }
        if (hr.x + w > Display.getDefault().getBounds().width) {
            int tempX = hr.x + w - Display.getDefault().getBounds().width;
            if (tempX > Display.getDefault().getBounds().width) {
                hr.x = 0;
            }
            hr.x -= tempX;
        }
        this.fTextBox.setText(value);
        GC gc = new GC((Drawable)this.fTextBox);
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        int width = 100 * fm.getAverageCharWidth();
        this.fTextBox.setSize(this.fTextBox.computeSize(width, this.fTextBox.getLineCount() * this.fTextBox.getLineHeight()));
        this.fToolTipShell.setLocation(hr.x, hr.y + cursorH);
        this.fToolTipShell.setSize(this.fTextBox.getSize());
        this.fTextBox.setVisible(true);
        this.fToolTipShell.setVisible(true);
    }

    public void hideToolTip() {
        this.fToolTipShell.setVisible(false);
    }

    protected Control getParent() {
        return this.fParent;
    }
}

