/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfWithFolderElement;
import org.eclipse.linuxtools.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;

public class TmfExperimentElement
extends TmfWithFolderElement
implements IPropertySource2 {
    private static final String sfInfoCategory = "Info";
    private static final String sfName = "name";
    private static final String sfPath = "path";
    private static final String sfLocation = "location";
    private static final String sfFolderSuffix = "_exp";
    private static final ReadOnlyTextPropertyDescriptor sfNameDescriptor = new ReadOnlyTextPropertyDescriptor("name", "name");
    private static final ReadOnlyTextPropertyDescriptor sfPathDescriptor = new ReadOnlyTextPropertyDescriptor("path", "path");
    private static final ReadOnlyTextPropertyDescriptor sfLocationDescriptor = new ReadOnlyTextPropertyDescriptor("location", "location");
    private static final IPropertyDescriptor[] sfDescriptors = new IPropertyDescriptor[]{sfNameDescriptor, sfPathDescriptor, sfLocationDescriptor};
    private static final String BOOKMARKS_HIDDEN_FILE = ".bookmarks";

    static {
        sfNameDescriptor.setCategory(sfInfoCategory);
        sfPathDescriptor.setCategory(sfInfoCategory);
        sfLocationDescriptor.setCategory(sfInfoCategory);
    }

    public TmfExperimentElement(String name, IFolder folder, TmfExperimentFolder parent) {
        super(name, (IResource)folder, parent);
        parent.addChild(this);
    }

    public IFolder getResource() {
        return (IFolder)this.fResource;
    }

    @Override
    public TmfProjectElement getProject() {
        return (TmfProjectElement)this.getParent().getParent();
    }

    public List<TmfTraceElement> getTraces() {
        List<ITmfProjectModelElement> children = this.getChildren();
        ArrayList<TmfTraceElement> traces = new ArrayList<TmfTraceElement>();
        for (ITmfProjectModelElement child : children) {
            if (!(child instanceof TmfTraceElement)) continue;
            traces.add((TmfTraceElement)child);
        }
        return traces;
    }

    public void addTrace(TmfTraceElement trace) {
        IFolder experiment = this.getResource();
        IResource resource = trace.getResource();
        IPath location = resource.getLocation();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            Map properties = trace.getResource().getPersistentProperties();
            String bundleName = (String)properties.get(TmfCommonConstants.TRACEBUNDLE);
            String traceType = (String)properties.get(TmfCommonConstants.TRACETYPE);
            String iconUrl = (String)properties.get(TmfCommonConstants.TRACEICON);
            if (resource instanceof IFolder) {
                IFolder folder = experiment.getFolder(trace.getName());
                if (workspace.validateLinkLocation((IResource)folder, location).isOK()) {
                    folder.createLink(location, 256, null);
                    TmfExperimentElement.setProperties((IResource)folder, bundleName, traceType, iconUrl);
                } else {
                    Activator.getDefault().logError("Error creating link. Invalid trace location " + location);
                }
            } else {
                IFile file = experiment.getFile(trace.getName());
                if (workspace.validateLinkLocation((IResource)file, location).isOK()) {
                    file.createLink(location, 256, null);
                    TmfExperimentElement.setProperties((IResource)file, bundleName, traceType, iconUrl);
                } else {
                    Activator.getDefault().logError("Error creating link. Invalid trace location " + location);
                }
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error creating link to location " + location, e);
        }
    }

    public void removeTrace(TmfTraceElement trace) throws CoreException {
        this.closeEditors();
        this.removeChild(trace);
        trace.getResource().delete(true, null);
    }

    private static void setProperties(IResource resource, String bundleName, String traceType, String iconUrl) throws CoreException {
        resource.setPersistentProperty(TmfCommonConstants.TRACEBUNDLE, bundleName);
        resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, traceType);
        resource.setPersistentProperty(TmfCommonConstants.TRACEICON, iconUrl);
    }

    public IFile createBookmarksFile() throws CoreException {
        IFile file = this.getBookmarksFile();
        if (!file.exists()) {
            IFile bookmarksFile = this.getProject().getExperimentsFolder().getResource().getFile(BOOKMARKS_HIDDEN_FILE);
            if (!bookmarksFile.exists()) {
                ByteArrayInputStream source = new ByteArrayInputStream(new byte[0]);
                bookmarksFile.create((InputStream)source, true, null);
            }
            bookmarksFile.setHidden(true);
            file.createLink(bookmarksFile.getLocation(), 256, null);
            file.setHidden(true);
            file.setPersistentProperty(TmfCommonConstants.TRACETYPE, TmfExperiment.class.getCanonicalName());
        }
        return file;
    }

    public IFile getBookmarksFile() {
        IFolder folder = (IFolder)this.fResource;
        IFile file = folder.getFile(String.valueOf(this.getName()) + '_');
        return file;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(sfDescriptors, sfDescriptors.length);
    }

    public Object getPropertyValue(Object id) {
        if (sfName.equals(id)) {
            return this.getName();
        }
        if (sfPath.equals(id)) {
            return this.getPath().toString();
        }
        if (sfLocation.equals(id)) {
            return this.getLocation().toString();
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    @Override
    public String getSuffix() {
        return sfFolderSuffix;
    }

    public void closeEditors() {
        IFile file = this.getBookmarksFile();
        FileEditorInput input = new FileEditorInput(file);
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = wb.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wbWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = wbWindow.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage wbPage = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = wbPage.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorReference = iEditorReferenceArray[n6];
                    try {
                        if (editorReference.getEditorInput().equals(input)) {
                            wbPage.closeEditor(editorReference.getEditor(false), false);
                        }
                    }
                    catch (PartInitException e) {
                        Activator.getDefault().logError("Error closing editor for experiment " + this.getName(), e);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }
}

