/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditorInput;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OpenExperimentHandler
extends AbstractHandler {
    private TmfExperimentElement fExperiment = null;

    public boolean isEnabled() {
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fExperiment = null;
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfExperimentElement) {
            this.fExperiment = (TmfExperimentElement)element;
        }
        return this.fExperiment != null && this.fExperiment.getTraces().size() > 0;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        final TmfExperimentElement experimentElement = this.fExperiment;
        Thread thread = new Thread(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                try {
                    file = experimentElement.createBookmarksFile();
                }
                catch (CoreException e) {
                    Activator.getDefault().logError("Error opening experiment " + experimentElement.getName(), e);
                    OpenExperimentHandler.access$0(String.valueOf(Messages.OpenExperimentHandler_Error) + "\n\n" + e.getMessage());
                    return;
                }
                experimentElement.refreshSupplementaryFolder();
                traceEntries = experimentElement.getTraces();
                nbTraces = traceEntries.size();
                cacheSize = 0x7FFFFFFF;
                commonEditorId = null;
                traces = new ITmfTrace[nbTraces];
                i = 0;
                while (i < nbTraces) {
                    block12: {
                        element = traceEntries.get(i);
                        element = element.getElementUnderTraceFolder();
                        trace = element.instantiateTrace();
                        traceEvent = element.instantiateEvent();
                        if (trace == null || traceEvent == null) {
                            OpenExperimentHandler.access$0(Messages.OpenExperimentHandler_NoTraceType);
                            j = 0;
                            while (j < i) {
                                traces[j].dispose();
                                ++j;
                            }
                            if (trace != null) {
                                trace.dispose();
                            }
                            return;
                        }
                        try {
                            trace.initTrace(element.getResource(), element.getLocation().getPath(), traceEvent.getClass());
                            break block12;
                        }
                        catch (TmfTraceException e) {
                            OpenExperimentHandler.access$0(String.valueOf(Messages.OpenTraceHandler_InitError) + "\n\n" + (Object)e);
                            j = 0;
                            ** while (j < i)
                        }
lbl-1000:
                        // 1 sources

                        {
                            traces[j].dispose();
                            ++j;
                            continue;
                        }
lbl40:
                        // 1 sources

                        trace.dispose();
                        return;
                    }
                    cacheSize = Math.min(cacheSize, trace.getCacheSize());
                    editorId = element.getEditorId();
                    if (commonEditorId == null) {
                        commonEditorId = editorId != null ? editorId : "org.eclipse.linuxtools.tmf.ui.editors.events";
                    } else if (!commonEditorId.equals(editorId)) {
                        commonEditorId = "org.eclipse.linuxtools.tmf.ui.editors.events";
                    }
                    traces[i] = trace;
                    ++i;
                }
                experiment = new TmfExperiment(ITmfEvent.class, experimentElement.getName(), traces, cacheSize, (IResource)experimentElement.getResource());
                experiment.setBookmarksFile(file);
                editorId = commonEditorId;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TmfEditorInput editorInput = new TmfEditorInput(file, (ITmfTrace)experiment);
                            IWorkbench wb = PlatformUI.getWorkbench();
                            IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
                            IEditorPart editor = activePage.findEditor((IEditorInput)new FileEditorInput(file));
                            if (editor != null && editor instanceof IReusableEditor) {
                                activePage.reuseEditor((IReusableEditor)editor, (IEditorInput)editorInput);
                                activePage.activate((IWorkbenchPart)editor);
                            } else {
                                activePage.openEditor((IEditorInput)editorInput, editorId);
                            }
                            IDE.setDefaultEditor((IFile)file, (String)editorId);
                        }
                        catch (CoreException e) {
                            Activator.getDefault().logError("Error opening experiment " + experimentElement.getName(), e);
                            OpenExperimentHandler.displayErrorMsg(String.valueOf(Messages.OpenExperimentHandler_Error) + "\n\n" + e.getMessage());
                            experiment.dispose();
                            return;
                        }
                    }
                });
            }
        };
        thread.start();
        return null;
    }

    private static void displayErrorMsg(final String errorMsg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                mb.setText(Messages.OpenExperimentHandler_Title);
                mb.setMessage(errorMsg);
                mb.open();
            }
        });
    }
}

