/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.commons.ui.dialogs.IInPlaceDialogListener;
import org.eclipse.mylyn.commons.ui.dialogs.InPlaceDialogEvent;
import org.eclipse.mylyn.commons.workbench.InPlaceCheckBoxTreeDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class CheckboxMultiSelectAttributeEditor
extends AbstractAttributeEditor {
    private Text valueText;
    private Composite parent;
    private Button button;
    private boolean suppressRefresh;

    public CheckboxMultiSelectAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.MULTIPLE));
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        if (this.isReadOnly()) {
            this.valueText = new Text(parent, 0x800048);
            this.valueText.setFont(EditorUtil.TEXT_FONT);
            toolkit.adapt((Control)this.valueText, false, false);
            this.valueText.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.valueText.setToolTipText(this.getDescription());
            this.refresh();
            this.setControl((Control)this.valueText);
        } else {
            this.parent = parent;
            Composite composite = toolkit.createComposite(parent);
            composite.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginBottom = 0;
            layout.marginLeft = 0;
            layout.marginRight = 0;
            layout.marginTop = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            this.valueText = toolkit.createText(composite, "", 0x800040);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.valueText);
            this.valueText.setFont(EditorUtil.TEXT_FONT);
            this.valueText.setEditable(false);
            this.valueText.setToolTipText(this.getDescription());
            this.button = toolkit.createButton(composite, "", 1028);
            GridDataFactory.fillDefaults().align(0x1000000, 128).applyTo((Control)this.button);
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    final List<String> values = CheckboxMultiSelectAttributeEditor.this.getValues();
                    Map validValues = CheckboxMultiSelectAttributeEditor.this.getAttributeMapper().getOptions(CheckboxMultiSelectAttributeEditor.this.getTaskAttribute());
                    final InPlaceCheckBoxTreeDialog selectionDialog = new InPlaceCheckBoxTreeDialog(WorkbenchUtil.getShell(), (Control)CheckboxMultiSelectAttributeEditor.this.button, values, validValues, NLS.bind((String)Messages.CheckboxMultiSelectAttributeEditor_Select_X, (Object)CheckboxMultiSelectAttributeEditor.this.getLabel()));
                    selectionDialog.addEventListener(new IInPlaceDialogListener(){

                        public void buttonPressed(InPlaceDialogEvent event) {
                            CheckboxMultiSelectAttributeEditor.this.suppressRefresh = true;
                            try {
                                HashSet newValues;
                                if (event.getReturnCode() == 0) {
                                    Set newValues2 = selectionDialog.getSelectedValues();
                                    if (!new HashSet(values).equals(newValues2)) {
                                        CheckboxMultiSelectAttributeEditor.this.setValues(new ArrayList<String>(newValues2));
                                        CheckboxMultiSelectAttributeEditor.this.refresh();
                                    }
                                } else if (event.getReturnCode() == 1025 && !new HashSet(values).equals(newValues = new HashSet())) {
                                    CheckboxMultiSelectAttributeEditor.this.setValues(new ArrayList<String>(newValues));
                                    CheckboxMultiSelectAttributeEditor.this.refresh();
                                }
                            }
                            finally {
                                CheckboxMultiSelectAttributeEditor.this.suppressRefresh = false;
                            }
                        }
                    });
                    selectionDialog.open();
                }
            });
            toolkit.adapt((Control)this.valueText, false, false);
            this.refresh();
            this.setControl((Control)composite);
        }
    }

    private void reflow() {
        Composite c = this.parent;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite || c instanceof Shell) break;
        }
        for (c = this.parent; c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof SharedScrolledComposite)) continue;
            ((SharedScrolledComposite)c).reflow(true);
            break;
        }
        c = this.parent;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof SharedScrolledComposite || c instanceof Shell) break;
        }
    }

    public List<String> getValues() {
        return this.getAttributeMapper().getValues(this.getTaskAttribute());
    }

    public List<String> getValuesLabels() {
        return this.getAttributeMapper().getValueLabels(this.getTaskAttribute());
    }

    public void setValues(List<String> newValues) {
        this.getAttributeMapper().setValues(this.getTaskAttribute(), newValues);
        this.attributeChanged();
    }

    @Override
    protected void decorateIncoming(Color color) {
        super.decorateIncoming(color);
        if (this.valueText != null && !this.valueText.isDisposed()) {
            this.valueText.setBackground(color);
        }
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setBackground(color);
        }
    }

    @Override
    public void refresh() {
        if (this.valueText == null || this.valueText.isDisposed()) {
            return;
        }
        StringBuilder valueString = new StringBuilder();
        List<String> values = this.getValuesLabels();
        Collections.sort(values);
        int i = 0;
        while (i < values.size()) {
            valueString.append(values.get(i));
            if (i != values.size() - 1) {
                valueString.append(", ");
            }
            ++i;
        }
        this.valueText.setText(valueString.toString());
        if (this.valueText != null && this.parent != null && this.parent.getParent() != null && this.parent.getParent().getParent() != null) {
            Point size = this.valueText.getSize();
            Point newSize = this.valueText.computeSize(size.x - 1, -1);
            if (newSize.y != size.y) {
                this.reflow();
            }
        }
    }

    @Override
    public boolean shouldAutoRefresh() {
        return !this.suppressRefresh;
    }
}

