/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.workbench.forms;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.Window;
import org.eclipse.mylyn.internal.commons.ui.WindowUtil;
import org.eclipse.mylyn.internal.commons.workbench.CommonsWorkbenchPlugin;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class SectionComposite
extends SharedScrolledComposite {
    private FormToolkit toolkit;
    private final Composite content;

    public SectionComposite(Composite parent, int style) {
        super(parent, style | 0x200);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SectionComposite.this.toolkit != null) {
                    SectionComposite.this.toolkit.dispose();
                    SectionComposite.this.toolkit = null;
                }
            }
        });
        this.content = new Composite((Composite)this, 0);
        this.content.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.setContent((Control)this.content);
        this.content.setBackground(null);
        this.setExpandVertical(true);
        this.setExpandHorizontal(true);
    }

    public Composite getContent() {
        return this.content;
    }

    public ExpandableComposite createSection(String title) {
        return this.createSection(title, 0, false);
    }

    public ExpandableComposite createSection(String title, int expansionStyle) {
        return this.createSection(title, expansionStyle, false);
    }

    public ExpandableComposite createSection(String title, int expansionStyle, final boolean grabExcessVerticalSpace) {
        final ExpandableComposite section = this.getToolkit().createExpandableComposite(this.getContent(), 0x32 | expansionStyle);
        section.titleBarTextMarginWidth = 0;
        section.setBackground(null);
        section.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Object shellData;
                GridData g;
                if (((Boolean)e.data).booleanValue() && grabExcessVerticalSpace) {
                    g = (GridData)section.getLayoutData();
                    g.verticalAlignment = 4;
                    g.grabExcessVerticalSpace = true;
                    section.setLayoutData((Object)g);
                } else {
                    g = (GridData)section.getLayoutData();
                    g.verticalAlignment = 1;
                    g.grabExcessVerticalSpace = false;
                    section.setLayoutData((Object)g);
                }
                SectionComposite.this.layout(true);
                Point newSize = section.getShell().computeSize(-1, -1, true);
                Rectangle currentbounds = section.getShell().getBounds();
                if ((newSize.x > currentbounds.width || newSize.y > currentbounds.height) && (shellData = section.getShell().getData()) instanceof Window) {
                    Window window = (Window)shellData;
                    Rectangle preferredSize = new Rectangle(currentbounds.x, currentbounds.y, Math.max(currentbounds.width, newSize.x), Math.max(currentbounds.height, newSize.y));
                    Rectangle result = WindowUtil.getConstrainedShellBounds((Window)window, (Rectangle)preferredSize);
                    section.getShell().setBounds(result);
                }
                SectionComposite.this.reflow(true);
                SectionComposite.this.getParent().layout(true, true);
            }
        });
        section.setText(title);
        if (this.content.getLayout() instanceof GridLayout) {
            GridDataFactory.fillDefaults().indent(0, 5).grab(true, false).span(((GridLayout)this.content.getLayout()).numColumns, -1).applyTo((Control)section);
        }
        return section;
    }

    public FormToolkit getToolkit() {
        this.checkWidget();
        if (this.toolkit == null) {
            this.toolkit = new FormToolkit(CommonsWorkbenchPlugin.getDefault().getFormColors(this.getDisplay()));
        }
        return this.toolkit;
    }
}

