/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexChangeListener;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexerStateListener;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.index.IndexerSetupParticipant;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ILanguageMappingChangeListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexManager;
import org.eclipse.cdt.internal.core.index.IndexChangeEvent;
import org.eclipse.cdt.internal.core.index.IndexFactory;
import org.eclipse.cdt.internal.core.index.IndexerStateEvent;
import org.eclipse.cdt.internal.core.index.provider.IndexProviderManager;
import org.eclipse.cdt.internal.core.pdom.AtomicMultiSet;
import org.eclipse.cdt.internal.core.pdom.CModelListener;
import org.eclipse.cdt.internal.core.pdom.CProjectDescriptionListener;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.IndexUpdatePolicy;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.JobChangeListener;
import org.eclipse.cdt.internal.core.pdom.LanguageMappingChangeListener;
import org.eclipse.cdt.internal.core.pdom.LanguageSettingsChangeListener;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.NotifyCModelManagerTask;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMIndexerJob;
import org.eclipse.cdt.internal.core.pdom.PDOMProxy;
import org.eclipse.cdt.internal.core.pdom.PDOMSetupJob;
import org.eclipse.cdt.internal.core.pdom.TeamPDOMExportOperation;
import org.eclipse.cdt.internal.core.pdom.TeamPDOMImportOperation;
import org.eclipse.cdt.internal.core.pdom.WaitForRefreshJobs;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMProjectIndexLocationConverter;
import org.eclipse.cdt.internal.core.pdom.indexer.AbstractPDOMIndexer;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMNullIndexer;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMRebuildTask;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMUpdateTask;
import org.eclipse.cdt.internal.core.pdom.indexer.ProjectIndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.indexer.TranslationUnitCollector;
import org.eclipse.cdt.internal.core.pdom.indexer.TriggerNotificationTask;
import org.eclipse.cdt.internal.core.resources.PathCanonicalizationStrategy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PDOMManager
implements IWritableIndexManager,
PDOM.IListener {
    private static final String TRACE_INDEXER_SETUP = "org.eclipse.cdt.core/debug/indexer/setup";
    private static final QualifiedName dbNameProperty = new QualifiedName("org.eclipse.cdt.core", "pdomName");
    public static final int[] IDS_FOR_LINKAGES_TO_INDEX = new int[]{1, 2, 3};
    public static final int[] IDS_FOR_LINKAGES_TO_INDEX_C_FIRST = new int[]{2, 1, 3};
    private final ArrayDeque<ICProject> fProjectQueue = new ArrayDeque();
    private final PDOMSetupJob fSetupJob;
    private final ArrayDeque<IPDOMIndexerTask> fTaskQueue = new ArrayDeque();
    private final PDOMIndexerJob fIndexerJob;
    private IPDOMIndexerTask fCurrentTask;
    private int fSourceCount;
    private int fHeaderCount;
    private int fTickCount;
    private final ArrayDeque<Runnable> fChangeEvents = new ArrayDeque();
    private final Job fNotificationJob;
    private final AtomicMultiSet<IIndexFileLocation> fFilesIndexedUnconditionlly = new AtomicMultiSet();
    private Map<IProject, IPDOM> fProjectToPDOM = new HashMap<IProject, IPDOM>();
    private Map<File, ICProject> fFileToProject = new HashMap<File, ICProject>();
    private ListenerList fChangeListeners = new ListenerList();
    private ListenerList fStateListeners = new ListenerList();
    private IndexChangeEvent fIndexChangeEvent = new IndexChangeEvent();
    private IndexerStateEvent fIndexerStateEvent = new IndexerStateEvent();
    private CModelListener fCModelListener = new CModelListener(this);
    private ILanguageMappingChangeListener fLanguageChangeListener = new LanguageMappingChangeListener(this);
    private LanguageSettingsChangeListener fLanguageSettingsChangeListener = new LanguageSettingsChangeListener(this);
    private final ICProjectDescriptionListener fProjectDescriptionListener;
    private final JobChangeListener fJobChangeListener;
    private final IEclipsePreferences.IPreferenceChangeListener fPreferenceChangeListener;
    private IndexFactory fIndexFactory = new IndexFactory(this);
    private IndexProviderManager fIndexProviderManager = new IndexProviderManager();
    private Map<ICProject, IndexUpdatePolicy> fUpdatePolicies = new HashMap<ICProject, IndexUpdatePolicy>();
    private Set<String> fClosingProjects = new HashSet<String>();
    private Map<IProject, PCL> fPrefListeners = new HashMap<IProject, PCL>();
    private List<IndexerSetupParticipant> fSetupParticipants = new ArrayList<IndexerSetupParticipant>();
    private Set<ICProject> fPostponedProjects = new HashSet<ICProject>();
    private int fLastNotifiedState = 0;
    private boolean fInShutDown;
    boolean fTraceIndexerSetup;

    public PDOMManager() {
        PDOM.sDEBUG_LOCKS = "true".equals(Platform.getDebugOption((String)"org.eclipse.cdt.core/debug/index/locks"));
        this.addIndexerSetupParticipant(new WaitForRefreshJobs());
        this.fProjectDescriptionListener = new CProjectDescriptionListener(this);
        this.fJobChangeListener = new JobChangeListener(this);
        this.fPreferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                PDOMManager.this.onPreferenceChange(event);
            }
        };
        this.fSetupJob = new PDOMSetupJob(this);
        this.fIndexerJob = new PDOMIndexerJob(this);
        this.fNotificationJob = this.createNotifyJob();
    }

    public Job startup() {
        this.fInShutDown = false;
        this.updatePathCanonicalizationStrategy();
        Job postStartupJob = new Job(CCorePlugin.getResourceString("CCorePlugin.startupJob")){

            protected IStatus run(IProgressMonitor monitor) {
                PDOMManager.this.postStartup();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == PDOMManager.this;
            }
        };
        postStartupJob.setSystem(true);
        return postStartupJob;
    }

    protected void postStartup() {
        InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").addPreferenceChangeListener(this.fPreferenceChangeListener);
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.fJobChangeListener);
        this.adjustCacheSize();
        this.updatePathCanonicalizationStrategy();
        this.fIndexProviderManager.startup();
        this.fTraceIndexerSetup = String.valueOf(true).equals(Platform.getDebugOption((String)TRACE_INDEXER_SETUP));
        CoreModel model = CoreModel.getDefault();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fCModelListener, 16);
        model.addElementChangedListener(this.fCModelListener);
        LanguageManager.getInstance().registerLanguageChangeListener(this.fLanguageChangeListener);
        LanguageSettingsManager.registerLanguageSettingsChangeListener(this.fLanguageSettingsChangeListener);
        CCorePlugin.getDefault().getProjectDescriptionManager().addCProjectDescriptionListener(this.fProjectDescriptionListener, 4);
        try {
            ICProject[] projects;
            ICProject[] iCProjectArray = projects = model.getCModel().getCProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                ICProject project = iCProjectArray[n2];
                this.addProject(project);
                ++n2;
            }
        }
        catch (CModelException e) {
            CCorePlugin.log((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.fInShutDown = true;
        InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").removePreferenceChangeListener(this.fPreferenceChangeListener);
        CCorePlugin.getDefault().getProjectDescriptionManager().removeCProjectDescriptionListener(this.fProjectDescriptionListener);
        CoreModel model = CoreModel.getDefault();
        model.removeElementChangedListener(this.fCModelListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fCModelListener);
        LanguageSettingsManager.unregisterLanguageSettingsChangeListener(this.fLanguageSettingsChangeListener);
        LanguageManager.getInstance().unregisterLanguageChangeListener(this.fLanguageChangeListener);
        PDOMIndexerJob jobToCancel = null;
        ArrayDeque<IPDOMIndexerTask> arrayDeque = this.fTaskQueue;
        synchronized (arrayDeque) {
            this.fTaskQueue.clear();
            jobToCancel = this.fIndexerJob;
        }
        if (jobToCancel != null) {
            assert (!Thread.holdsLock(this.fTaskQueue));
            jobToCancel.cancelJobs(null, false);
        }
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.fJobChangeListener);
    }

    protected void onPreferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String prop = event.getKey();
        if (prop.equals("org.eclipse.cdt.core.indexDBCacheSizePct") || prop.equals("org.eclipse.cdt.core.maxIndexDBCacheSizeMB")) {
            this.adjustCacheSize();
        } else if (prop.equals("org.eclipse.cdt.core.taskTags") || prop.equals("org.eclipse.cdt.core.taskPriorities") || prop.equals("org.eclipse.cdt.core.taskCaseSensitive")) {
            this.reindexAll();
        } else if (prop.equals("org.eclipse.cdt.core.path_canonicalization")) {
            this.updatePathCanonicalizationStrategy();
            this.reindexAll();
        }
    }

    protected void adjustCacheSize() {
        IPreferencesService prefs = Platform.getPreferencesService();
        int cachePct = prefs.getInt("org.eclipse.cdt.core", "org.eclipse.cdt.core.indexDBCacheSizePct", 10, null);
        int cacheMax = prefs.getInt("org.eclipse.cdt.core", "org.eclipse.cdt.core.maxIndexDBCacheSizeMB", 64, null);
        cachePct = Math.max(1, Math.min(50, cachePct));
        cacheMax = Math.max(1, cacheMax);
        long m1 = Runtime.getRuntime().maxMemory() / 100L * (long)cachePct;
        long m2 = Math.min(m1, (long)cacheMax * 1024L * 1024L);
        ChunkCache.getSharedInstance().setMaxSize(m2);
    }

    private void updatePathCanonicalizationStrategy() {
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean canonicalize = prefs.getBoolean("org.eclipse.cdt.core", "org.eclipse.cdt.core.path_canonicalization", true, null);
        PathCanonicalizationStrategy.setPathCanonicalization(canonicalize);
    }

    public IndexProviderManager getIndexProviderManager() {
        return this.fIndexProviderManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPDOM getPDOM(ICProject project) throws CoreException {
        Map<IProject, IPDOM> map = this.fProjectToPDOM;
        synchronized (map) {
            IProject rproject = project.getProject();
            IPDOM pdom = this.fProjectToPDOM.get(rproject);
            if (pdom == null) {
                pdom = new PDOMProxy();
                this.fProjectToPDOM.put(rproject, pdom);
            }
            return pdom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WritablePDOM getOrCreatePDOM(ICProject project) throws CoreException {
        Map<IProject, IPDOM> map = this.fProjectToPDOM;
        synchronized (map) {
            WritablePDOM pdom;
            IProject rproject = project.getProject();
            IPDOM pdomProxy = this.fProjectToPDOM.get(rproject);
            if (pdomProxy instanceof WritablePDOM) {
                return (WritablePDOM)pdomProxy;
            }
            String dbName = rproject.getPersistentProperty(dbNameProperty);
            File dbFile = null;
            if (dbName != null) {
                dbFile = this.fileFromDatabaseName(dbName);
                if (!dbFile.exists()) {
                    dbFile = null;
                    dbName = null;
                } else {
                    ICProject currentCOwner = this.fFileToProject.get(dbFile);
                    if (currentCOwner != null) {
                        IProject currentOwner = currentCOwner.getProject();
                        if (!currentOwner.exists()) {
                            this.fFileToProject.remove(dbFile);
                            dbFile.delete();
                        }
                        dbName = null;
                        dbFile = null;
                    }
                }
            }
            boolean fromScratch = false;
            if (dbName == null) {
                dbName = this.createNewDatabaseName(project);
                dbFile = this.fileFromDatabaseName(dbName);
                this.storeDatabaseName(rproject, dbName);
                fromScratch = true;
            }
            if (!(pdom = new WritablePDOM(dbFile, new PDOMProjectIndexLocationConverter(rproject), this.getLinkageFactories())).isSupportedVersion() || fromScratch) {
                try {
                    pdom.acquireWriteLock();
                }
                catch (InterruptedException e) {
                    throw new CoreException(CCorePlugin.createStatus(Messages.PDOMManager_creationOfIndexInterrupted, e));
                }
                if (fromScratch) {
                    pdom.setCreatedFromScratch(true);
                } else {
                    pdom.clear();
                    pdom.setClearedBecauseOfVersionMismatch(true);
                }
                PDOMManager.writeProjectPDOMProperties(pdom, rproject);
                pdom.releaseWriteLock();
            }
            pdom.setASTFilePathResolver(new ProjectIndexerInputAdapter(project, false));
            pdom.addListener(this);
            this.fFileToProject.put(dbFile, project);
            this.fProjectToPDOM.put(rproject, pdom);
            if (pdomProxy instanceof PDOMProxy) {
                ((PDOMProxy)pdomProxy).setDelegate(pdom);
            }
            return pdom;
        }
    }

    private Map<String, IPDOMLinkageFactory> getLinkageFactories() {
        return LanguageManager.getInstance().getPDOMLinkageFactoryMappings();
    }

    private void storeDatabaseName(IProject rproject, String dbName) throws CoreException {
        rproject.setPersistentProperty(dbNameProperty, dbName);
    }

    private String createNewDatabaseName(ICProject project) {
        String dbName;
        File file;
        long time = System.currentTimeMillis();
        while ((file = this.fileFromDatabaseName(dbName = this.getDefaultName(project, time++))).exists()) {
        }
        return dbName;
    }

    private File fileFromDatabaseName(String dbName) {
        return CCorePlugin.getDefault().getStateLocation().append(dbName).toFile();
    }

    private String getDefaultName(ICProject project, long time) {
        return String.valueOf(project.getElementName()) + "." + time + ".pdom";
    }

    @Override
    public String getDefaultIndexerId() {
        return this.getIndexerId(null);
    }

    @Override
    public void setDefaultIndexerId(String indexerId) {
        IndexerPreferences.setDefaultIndexerId(indexerId);
    }

    @Override
    public String getIndexerId(ICProject project) {
        IProject prj = project != null ? project.getProject() : null;
        return IndexerPreferences.get(prj, "indexerId", "org.eclipse.cdt.core.nullindexer");
    }

    @Override
    public void setIndexerId(ICProject project, String indexerId) {
        IProject prj = project.getProject();
        IndexerPreferences.set(prj, "indexerId", indexerId);
        CCoreInternals.savePreferences(prj, IndexerPreferences.getScope(prj) == 2);
        this.changeIndexer(project);
    }

    protected void onPreferenceChange(ICProject cproject, IEclipsePreferences.PreferenceChangeEvent event) {
        if ("updatePolicy".equals(event.getKey())) {
            this.changeUpdatePolicy(cproject);
        } else {
            this.changeIndexer(cproject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeUpdatePolicy(ICProject cproject) {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        Map<ICProject, IndexUpdatePolicy> map = this.fUpdatePolicies;
        synchronized (map) {
            IPDOMIndexerTask task;
            IndexUpdatePolicy policy = this.getPolicy(cproject);
            if (policy != null && (task = policy.changePolicy(IndexerPreferences.getUpdatePolicy(cproject.getProject()))) != null) {
                this.enqueue(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeIndexer(ICProject cproject) {
        IProject prj = cproject.getProject();
        if (!prj.exists() || !prj.isOpen()) {
            return;
        }
        try {
            assert (!Thread.holdsLock(this.fProjectToPDOM));
            IPDOMIndexer oldIndexer = this.getIndexer(cproject);
            if (oldIndexer == null) {
                return;
            }
            String newid = IndexerPreferences.get(prj, "indexerId", "org.eclipse.cdt.core.nullindexer");
            Properties props = IndexerPreferences.getProperties(prj);
            Map<ICProject, IndexUpdatePolicy> map = this.fUpdatePolicies;
            synchronized (map) {
                if (this.fClosingProjects.contains(prj.getName())) {
                    return;
                }
                oldIndexer = this.getIndexer(cproject);
                if (oldIndexer != null) {
                    if (oldIndexer.getID().equals(newid) && !oldIndexer.needsToRebuildForProperties(props)) {
                        oldIndexer.setProperties(props);
                        return;
                    }
                    IPDOMIndexer indexer = this.newIndexer(newid, props);
                    this.registerIndexer(cproject, indexer);
                    this.createPolicy(cproject).clearTUs();
                    if (oldIndexer instanceof AbstractPDOMIndexer && IndexerPreferences.preferDefaultLanguage(((AbstractPDOMIndexer)oldIndexer).getProperties()) != IndexerPreferences.preferDefaultLanguage(props)) {
                        this.enqueue(new NotifyCModelManagerTask(cproject.getProject()));
                    }
                    if (IndexerPreferences.getReindexOnIndexerChange(cproject.getProject())) {
                        this.enqueue(new PDOMRebuildTask(indexer));
                    }
                }
            }
            if (oldIndexer != null) {
                this.stopIndexer(oldIndexer);
            }
        }
        catch (Exception e) {
            CCorePlugin.log(e);
        }
    }

    private void registerIndexer(ICProject project, IPDOMIndexer indexer) {
        assert (Thread.holdsLock(this.fUpdatePolicies));
        indexer.setProject(project);
        this.registerPreferenceListener(project);
        this.createPolicy(project).setIndexer(indexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IPDOMIndexer getIndexer(ICProject project) {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        Map<ICProject, IndexUpdatePolicy> map = this.fUpdatePolicies;
        synchronized (map) {
            IndexUpdatePolicy policy = this.getPolicy(project);
            if (policy != null) {
                return policy.getIndexer();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createIndexer(ICProject project, IProgressMonitor pm) throws InterruptedException {
        block31: {
            IProject prj = project.getProject();
            String name = prj.getName();
            if (this.fTraceIndexerSetup) {
                System.out.println("Indexer: Creation for project " + name);
            }
            assert (!Thread.holdsLock(this.fProjectToPDOM));
            try {
                IndexUpdatePolicy policy;
                IPDOMIndexer indexer;
                Properties props;
                Map<ICProject, IndexUpdatePolicy> map = this.fUpdatePolicies;
                synchronized (map) {
                    boolean rebuild;
                    if (this.fClosingProjects.contains(name)) {
                        if (this.fTraceIndexerSetup) {
                            System.out.println("Indexer: Aborting setup (1) for closing project " + name + " [1]");
                        }
                        return;
                    }
                    WritablePDOM pdom = this.getOrCreatePDOM(project);
                    props = IndexerPreferences.getProperties(prj);
                    indexer = this.newIndexer(this.getIndexerId(project), props);
                    policy = this.createPolicy(project);
                    boolean bl = rebuild = pdom.isClearedBecauseOfVersionMismatch() || pdom.isCreatedFromScratch() || policy.isInitialRebuildRequested();
                    if (rebuild) {
                        if ("org.eclipse.cdt.core.nullindexer".equals(indexer.getID())) {
                            rebuild = false;
                        }
                        pdom.setClearedBecauseOfVersionMismatch(false);
                        pdom.setCreatedFromScratch(false);
                    }
                    if (!rebuild) {
                        this.registerIndexer(project, indexer);
                        IPDOMIndexerTask task = policy.createTask();
                        if (task != null) {
                            this.enqueue(task);
                        } else {
                            this.enqueue(new TriggerNotificationTask(this, pdom));
                        }
                        if (policy.isAutomatic()) {
                            boolean resume = false;
                            pdom.acquireReadLock();
                            try {
                                resume = "true".equals(pdom.getProperty("org.eclipse.cdt.internal.core.index.resume"));
                            }
                            finally {
                                pdom.releaseReadLock();
                            }
                            if (resume) {
                                if (this.fTraceIndexerSetup) {
                                    System.out.println("Indexer: Resuming for project " + name);
                                }
                                this.enqueue(new PDOMUpdateTask(indexer, 18));
                            }
                        }
                        return;
                    }
                }
                TeamPDOMImportOperation operation = new TeamPDOMImportOperation(project);
                operation.run(pm);
                Map<ICProject, IndexUpdatePolicy> map2 = this.fUpdatePolicies;
                synchronized (map2) {
                    if (this.fClosingProjects.contains(name)) {
                        if (this.fTraceIndexerSetup) {
                            System.out.println("Indexer: Aborting setup for closing project " + name + " [2]");
                        }
                        return;
                    }
                    props = IndexerPreferences.getProperties(prj);
                    indexer = this.newIndexer(this.getIndexerId(project), props);
                    this.registerIndexer(project, indexer);
                    policy = this.createPolicy(project);
                    policy.clearTUs();
                    IPDOMIndexerTask task = null;
                    if (policy.isAutomatic() || policy.isInitialRebuildRequested()) {
                        policy.clearInitialFlags();
                        if (operation.wasSuccessful()) {
                            if (this.fTraceIndexerSetup) {
                                System.out.println("Indexer: Imported shared index for project " + name);
                            }
                            task = new PDOMUpdateTask(indexer, 18);
                        } else {
                            if (this.fTraceIndexerSetup) {
                                System.out.println("Indexer: Rebuiding for project " + name);
                            }
                            task = new PDOMRebuildTask(indexer);
                        }
                        this.enqueue(task);
                    }
                }
            }
            catch (CoreException e) {
                if (!prj.isOpen()) break block31;
                CCorePlugin.log(e);
            }
        }
    }

    private IPDOMIndexer newIndexer(String indexerId, Properties props) throws CoreException {
        IPDOMIndexer indexer = null;
        IExtension indexerExt = Platform.getExtensionRegistry().getExtension("org.eclipse.cdt.core.CIndexer", indexerId);
        if (indexerExt != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = indexerExt.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if ("run".equals(element.getName())) {
                    try {
                        indexer = (IPDOMIndexer)element.createExecutableExtension("class");
                        indexer.setProperties(props);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                    break;
                }
                ++n2;
            }
        }
        if (indexer == null) {
            indexer = new PDOMNullIndexer();
        }
        return indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(IPDOMIndexerTask subjob) {
        ArrayDeque<IPDOMIndexerTask> arrayDeque = this.fTaskQueue;
        synchronized (arrayDeque) {
            if (this.fCurrentTask != null && this.fCurrentTask.acceptUrgentTask(subjob)) {
                return;
            }
            for (IPDOMIndexerTask task : this.fTaskQueue) {
                if (!task.acceptUrgentTask(subjob)) continue;
                return;
            }
            this.fTaskQueue.addLast(subjob);
            this.fIndexerJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IPDOMIndexerTask getNextTask() {
        IPDOMIndexerTask result = null;
        ArrayDeque<IPDOMIndexerTask> arrayDeque = this.fTaskQueue;
        synchronized (arrayDeque) {
            if (this.fTaskQueue.isEmpty()) {
                this.fCurrentTask = null;
                this.fTickCount = 0;
                this.fHeaderCount = 0;
                this.fSourceCount = 0;
            } else {
                if (this.fCurrentTask != null) {
                    IndexerProgress info = this.fCurrentTask.getProgressInformation();
                    this.fSourceCount += info.fCompletedSources;
                    this.fHeaderCount += info.fCompletedHeaders;
                    this.fTickCount += info.fCompletedSources + info.fPrimaryHeaderCount;
                }
                result = this.fCurrentTask = this.fTaskQueue.removeFirst();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelledIndexerJob(boolean byManager) {
        ArrayDeque<IPDOMIndexerTask> arrayDeque = this.fTaskQueue;
        synchronized (arrayDeque) {
            this.fCurrentTask = null;
            if (!byManager) {
                this.fTaskQueue.clear();
            }
            if (!this.fTaskQueue.isEmpty()) {
                this.fIndexerJob.schedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIndexerIdle() {
        ArrayDeque<IPDOMIndexerTask> arrayDeque = this.fTaskQueue;
        synchronized (arrayDeque) {
            return Job.getJobManager().find((Object)this).length == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProject(ICProject cproject) {
        String name = cproject.getProject().getName();
        if (this.fTraceIndexerSetup) {
            System.out.println("Indexer: Adding new project " + name);
        }
        Map<ICProject, IndexUpdatePolicy> map = this.fUpdatePolicies;
        synchronized (map) {
            this.fClosingProjects.remove(name);
        }
        this.setupProject(cproject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupProject(ICProject cproject) {
        if (this.fInShutDown) {
            return;
        }
        ArrayDeque<ICProject> arrayDeque = this.fProjectQueue;
        synchronized (arrayDeque) {
            this.fProjectQueue.add(cproject);
        }
        this.fSetupJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ICProject getNextProject() {
        ArrayDeque<ICProject> arrayDeque = this.fProjectQueue;
        synchronized (arrayDeque) {
            block4: {
                if (!this.fProjectQueue.isEmpty()) break block4;
                return null;
            }
            return this.fProjectQueue.removeFirst();
        }
    }

    private void registerPreferenceListener(ICProject project) {
        IProject prj = project.getProject();
        PCL pcl = this.fPrefListeners.get(prj);
        if (pcl == null) {
            pcl = new PCL(project);
            this.fPrefListeners.put(prj, pcl);
        }
        IndexerPreferences.addChangeListener(prj, pcl);
    }

    private void unregisterPreferenceListener(ICProject project) {
        IProject prj = project.getProject();
        PCL pcl = this.fPrefListeners.remove(prj);
        if (pcl != null) {
            IndexerPreferences.removeChangeListener(prj, pcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeProject(ICProject project, ITranslationUnit[] added, ITranslationUnit[] changed, ITranslationUnit[] removed) {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        IPDOMIndexer indexer = this.getIndexer(project);
        if (indexer != null && indexer.getID().equals("org.eclipse.cdt.core.nullindexer")) {
            return;
        }
        if (added.length > 0 || changed.length > 0 || removed.length > 0) {
            Map<ICProject, IndexUpdatePolicy> map = this.fUpdatePolicies;
            synchronized (map) {
                IndexUpdatePolicy policy = this.createPolicy(project);
                IPDOMIndexerTask task = policy.handleDelta(added, changed, removed);
                if (task != null) {
                    this.enqueue(task);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexUpdatePolicy createPolicy(ICProject project) {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        Map<ICProject, IndexUpdatePolicy> map = this.fUpdatePolicies;
        synchronized (map) {
            IndexUpdatePolicy policy = this.fUpdatePolicies.get(project);
            if (policy == null) {
                policy = new IndexUpdatePolicy(project, IndexerPreferences.getUpdatePolicy(project.getProject()));
                this.fUpdatePolicies.put(project, policy);
            }
            return policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexUpdatePolicy getPolicy(ICProject project) {
        Map<ICProject, IndexUpdatePolicy> map = this.fUpdatePolicies;
        synchronized (map) {
            return this.fUpdatePolicies.get(project);
        }
    }

    public void preDeleteProject(ICProject cproject) {
        this.preRemoveProject(cproject, true);
    }

    public void preCloseProject(ICProject cproject) {
        this.preRemoveProject(cproject, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preRemoveProject(ICProject cproject, final boolean delete) {
        IPDOMIndexer indexer;
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        IProject rproject = cproject.getProject();
        String name = rproject.getName();
        if (this.fTraceIndexerSetup) {
            System.out.println("Indexer: Removing project " + name + "; delete=" + delete);
        }
        Map<ICProject, IndexUpdatePolicy> map = this.fUpdatePolicies;
        synchronized (map) {
            this.fClosingProjects.add(name);
            indexer = this.getIndexer(cproject);
        }
        if (indexer != null) {
            this.stopIndexer(indexer);
        }
        this.unregisterPreferenceListener(cproject);
        IPDOM pdom = null;
        Map<Object, Object> map2 = this.fProjectToPDOM;
        synchronized (map2) {
            pdom = this.fProjectToPDOM.remove(rproject);
            if (pdom instanceof WritablePDOM && !delete) {
                this.fFileToProject.remove(((WritablePDOM)pdom).getDB().getLocation());
            }
        }
        if (pdom instanceof WritablePDOM) {
            final WritablePDOM finalpdom = (WritablePDOM)pdom;
            Job job = new Job(Messages.PDOMManager_ClosePDOMJob){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        finalpdom.acquireWriteLock();
                        try {
                            try {
                                finalpdom.close();
                                if (delete) {
                                    finalpdom.getDB().getLocation().delete();
                                }
                            }
                            catch (CoreException e) {
                                CCorePlugin.log(e);
                                finalpdom.releaseWriteLock();
                            }
                        }
                        finally {
                            finalpdom.releaseWriteLock();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
        map2 = this.fUpdatePolicies;
        synchronized (map2) {
            this.fUpdatePolicies.remove(cproject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProject(ICProject cproject, ICElementDelta delta) {
        Map<IProject, IPDOM> map = this.fProjectToPDOM;
        synchronized (map) {
            IProject rproject = cproject.getProject();
            this.fProjectToPDOM.remove(rproject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopIndexer(IPDOMIndexer indexer) {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        assert (!Thread.holdsLock(this.fUpdatePolicies));
        ICProject project = indexer.getProject();
        Map<ICProject, IndexUpdatePolicy> map = this.fUpdatePolicies;
        synchronized (map) {
            IndexUpdatePolicy policy = this.getPolicy(project);
            if (policy != null && policy.getIndexer() == indexer) {
                policy.clearTUs();
                policy.setIndexer(null);
            }
        }
        this.cancelIndexerJobs(indexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelIndexerJobs(IPDOMIndexer indexer) {
        PDOMIndexerJob jobToCancel = null;
        ArrayDeque<IPDOMIndexerTask> arrayDeque = this.fTaskQueue;
        synchronized (arrayDeque) {
            Iterator<IPDOMIndexerTask> iter = this.fTaskQueue.iterator();
            while (iter.hasNext()) {
                IPDOMIndexerTask task = iter.next();
                if (task.getIndexer() != indexer) continue;
                iter.remove();
            }
            jobToCancel = this.fIndexerJob;
        }
        if (jobToCancel != null) {
            assert (!Thread.holdsLock(this.fTaskQueue));
            jobToCancel.cancelJobs(indexer, true);
        }
    }

    private void reindexAll() {
        try {
            ICProject[] cProjects;
            ICProject[] iCProjectArray = cProjects = CoreModel.getDefault().getCModel().getCProjects();
            int n = cProjects.length;
            int n2 = 0;
            while (n2 < n) {
                ICProject project = iCProjectArray[n2];
                this.reindex(project);
                ++n2;
            }
        }
        catch (CModelException e) {
            CCorePlugin.log((Throwable)((Object)e));
        }
    }

    @Override
    public void reindex(final ICProject project) {
        Job job = new Job(Messages.PDOMManager_notifyJob_label){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                IPDOMIndexer indexer = null;
                Map map = PDOMManager.this.fUpdatePolicies;
                synchronized (map) {
                    indexer = PDOMManager.this.getIndexer(project);
                    if (indexer == null) {
                        PDOMManager.this.createPolicy(project).requestInitialReindex();
                        return Status.OK_STATUS;
                    }
                }
                PDOMManager.this.cancelIndexerJobs(indexer);
                map = PDOMManager.this.fUpdatePolicies;
                synchronized (map) {
                    indexer = PDOMManager.this.getIndexer(project);
                    if (indexer != null) {
                        PDOMManager.this.createPolicy(project).clearTUs();
                        PDOMManager.this.enqueue(new PDOMRebuildTask(indexer));
                    }
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == PDOMManager.this;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    @Override
    public void addIndexChangeListener(IIndexChangeListener listener) {
        this.fChangeListeners.add((Object)listener);
    }

    @Override
    public void removeIndexChangeListener(IIndexChangeListener listener) {
        this.fChangeListeners.remove((Object)listener);
    }

    @Override
    public void addIndexerStateListener(IIndexerStateListener listener) {
        this.fStateListeners.add((Object)listener);
    }

    @Override
    public void removeIndexerStateListener(IIndexerStateListener listener) {
        this.fStateListeners.remove((Object)listener);
    }

    private Job createNotifyJob() {
        Job notify = new Job(Messages.PDOMManager_notifyJob_label){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                while (true) {
                    Runnable r;
                    ArrayDeque arrayDeque = PDOMManager.this.fChangeEvents;
                    synchronized (arrayDeque) {
                        if (PDOMManager.this.fChangeEvents.isEmpty()) {
                            return Status.OK_STATUS;
                        }
                        r = (Runnable)PDOMManager.this.fChangeEvents.removeFirst();
                    }
                    r.run();
                }
            }
        };
        notify.setSystem(true);
        return notify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNotification(Runnable notify) {
        if (this.fInShutDown) {
            return;
        }
        ArrayDeque<Runnable> arrayDeque = this.fChangeEvents;
        synchronized (arrayDeque) {
            this.fChangeEvents.add(notify);
        }
        this.fNotificationJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireStateChange(final int state) {
        ListenerList listenerList = this.fStateListeners;
        synchronized (listenerList) {
            if (this.fLastNotifiedState == state) {
                return;
            }
            this.fLastNotifiedState = state;
            if (this.fStateListeners.isEmpty()) {
                return;
            }
            Runnable notify = new Runnable(){

                @Override
                public void run() {
                    Object[] listeners;
                    PDOMManager.this.fIndexerStateEvent.setState(state);
                    Object[] objectArray = listeners = PDOMManager.this.fStateListeners.getListeners();
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object listener2 = objectArray[n2];
                        final IIndexerStateListener listener = (IIndexerStateListener)listener2;
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                                CCorePlugin.log(exception);
                            }

                            public void run() throws Exception {
                                listener.indexChanged(PDOMManager.this.fIndexerStateEvent);
                            }
                        });
                        ++n2;
                    }
                }
            };
            this.scheduleNotification(notify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleChange(PDOM pdom, final PDOM.ChangeEvent e) {
        ICProject project;
        if (this.fChangeListeners.isEmpty()) {
            return;
        }
        Map<IProject, IPDOM> map = this.fProjectToPDOM;
        synchronized (map) {
            project = this.fFileToProject.get(pdom.getPath());
        }
        if (project != null) {
            final ICProject finalProject = project;
            Runnable notify = new Runnable(){

                @Override
                public void run() {
                    Object[] listeners;
                    PDOMManager.this.fIndexChangeEvent.setAffectedProject(finalProject, e);
                    Object[] objectArray = listeners = PDOMManager.this.fChangeListeners.getListeners();
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object listener2 = objectArray[n2];
                        final IIndexChangeListener listener = (IIndexChangeListener)listener2;
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                                CCorePlugin.log(exception);
                            }

                            public void run() throws Exception {
                                listener.indexChanged(PDOMManager.this.fIndexChangeEvent);
                            }
                        });
                        ++n2;
                    }
                }
            };
            this.scheduleNotification(notify);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean joinIndexer(int waitMaxMillis, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 14[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMonitorMessage(PDOMIndexerJob job, int currentTicks, int base) {
        int newTick;
        int tickCount;
        int tickEstimate;
        int headerCount;
        int sourceCount;
        int sourceEstimate;
        assert (!Thread.holdsLock(this.fTaskQueue));
        String detail = null;
        ArrayDeque<IPDOMIndexerTask> arrayDeque = this.fTaskQueue;
        synchronized (arrayDeque) {
            sourceCount = sourceEstimate = this.fSourceCount;
            headerCount = this.fHeaderCount;
            tickCount = tickEstimate = this.fTickCount;
            for (IPDOMIndexerTask task : this.fTaskQueue) {
                IndexerProgress info = task.getProgressInformation();
                sourceEstimate += info.fRequestedFilesCount;
                tickEstimate += info.getEstimatedTicks();
            }
            if (this.fCurrentTask != null) {
                IndexerProgress info = this.fCurrentTask.getProgressInformation();
                sourceCount += info.fCompletedSources;
                sourceEstimate += info.fRequestedFilesCount - info.fPrimaryHeaderCount;
                headerCount += info.fCompletedHeaders;
                int completedPrimary = info.fCompletedSources + info.fPrimaryHeaderCount;
                if (info.fRequestedFilesCount != 0) {
                    tickCount += completedPrimary;
                    int additionalHeaders = info.fCompletedHeaders - info.fPrimaryHeaderCount;
                    tickEstimate += info.fRequestedFilesCount;
                    tickCount += additionalHeaders;
                    tickEstimate = (int)((double)tickEstimate + (double)additionalHeaders * Math.sqrt((double)info.fRequestedFilesCount / (double)Math.max(completedPrimary, 1)));
                } else {
                    tickCount += completedPrimary;
                    tickEstimate += info.fTimeEstimate;
                }
                detail = PDOMIndexerJob.sMonitorDetail;
            }
        }
        String msg = MessageFormat.format((String)Messages.PDOMManager_indexMonitorDetail, (Object[])new Object[]{new Integer(sourceCount), new Integer(sourceEstimate), new Integer(headerCount)});
        if (detail != null) {
            msg = String.valueOf(msg) + ": " + detail;
        }
        job.subTask(msg);
        if (tickCount > 0 && tickCount <= tickEstimate && (newTick = tickCount * base / tickEstimate) > currentTicks) {
            job.worked(newTick - currentTicks);
            return newTick;
        }
        return currentTicks;
    }

    @Override
    public IWritableIndex getWritableIndex(ICProject project) throws CoreException {
        return this.fIndexFactory.getWritableIndex(project);
    }

    @Override
    public IIndex getIndex(ICProject project) throws CoreException {
        return this.fIndexFactory.getIndex(new ICProject[]{project}, 0);
    }

    @Override
    public IIndex getIndex(ICProject[] projects) throws CoreException {
        return this.fIndexFactory.getIndex(projects, 0);
    }

    @Override
    public IIndex getIndex(ICProject project, int options) throws CoreException {
        return this.fIndexFactory.getIndex(new ICProject[]{project}, options);
    }

    @Override
    public IIndex getIndex(ICProject[] projects, int options) throws CoreException {
        return this.fIndexFactory.getIndex(projects, options);
    }

    public void exportProjectPDOM(ICProject cproject, File targetLocation, IIndexLocationConverter newConverter) throws CoreException {
        boolean deleted;
        if (targetLocation.exists() && !(deleted = targetLocation.delete())) {
            throw new IllegalArgumentException(MessageFormat.format((String)Messages.PDOMManager_ExistingFileCollides, (Object[])new Object[]{targetLocation}));
        }
        try {
            WritablePDOM pdom = this.getOrCreatePDOM(cproject);
            pdom.acquireReadLock();
            String oldID = null;
            try {
                oldID = pdom.getProperty("org.eclipse.cdt.internal.core.index.fragment.id");
                ((PDOM)pdom).flush();
                FileOutputStream stream = new FileOutputStream(targetLocation);
                pdom.getDB().transferTo(stream.getChannel());
                stream.close();
            }
            finally {
                pdom.releaseReadLock();
            }
            WritablePDOM newPDOM = new WritablePDOM(targetLocation, pdom.getLocationConverter(), this.getLinkageFactories());
            newPDOM.acquireWriteLock();
            try {
                newPDOM.rewriteLocations(newConverter);
                newPDOM.setProperty("org.eclipse.cdt.internal.core.index.fragment.id", "exported." + oldID);
                newPDOM.close();
            }
            finally {
                newPDOM.releaseWriteLock();
            }
        }
        catch (IOException e) {
            throw new CoreException(CCorePlugin.createStatus(e.getMessage()));
        }
        catch (InterruptedException e) {
            throw new CoreException(CCorePlugin.createStatus(e.getMessage()));
        }
    }

    public void importProjectPDOM(ICProject project, InputStream stream) throws CoreException, IOException {
        String newName = this.createNewDatabaseName(project);
        File newFile = this.fileFromDatabaseName(newName);
        FileOutputStream out = new FileOutputStream(newFile);
        try {
            int read;
            int version = 0;
            int i = 0;
            while (i < 4) {
                byte b = (byte)stream.read();
                version = (version << 8) + (b & 0xFF);
                ((OutputStream)out).write(b);
                ++i;
            }
            if (version > PDOM.getMaxSupportedVersion()) {
                Status status = new Status(2, "org.eclipse.cdt.core", 0, CCorePlugin.getResourceString("PDOMManager.unsupportedHigherVersion"), null);
                throw new CoreException((IStatus)status);
            }
            if (!PDOM.isSupportedVersion(version)) {
                Status status = new Status(2, "org.eclipse.cdt.core", 0, CCorePlugin.getResourceString("PDOMManager.unsupportedVersion"), null);
                throw new CoreException((IStatus)status);
            }
            byte[] buffer = new byte[2048];
            while ((read = stream.read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            ((OutputStream)out).close();
        }
        WritablePDOM pdom = (WritablePDOM)this.getPDOM(project);
        try {
            pdom.acquireWriteLock();
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        try {
            pdom.reloadFromFile(newFile);
            this.storeDatabaseName(project.getProject(), newName);
            PDOMManager.writeProjectPDOMProperties(pdom, project.getProject());
        }
        finally {
            pdom.releaseWriteLock();
        }
    }

    @Override
    public void export(ICProject project, String location, int options, IProgressMonitor monitor) throws CoreException {
        TeamPDOMExportOperation operation = new TeamPDOMExportOperation(project);
        operation.setTargetLocation(location);
        operation.setOptions(options);
        operation.run(monitor);
    }

    public static void writeProjectPDOMProperties(WritablePDOM pdom, IProject project) throws CoreException {
        String DELIM = "\u0000";
        String id = "org.eclipse.cdt.core.pdom.project." + DELIM + project.getName() + DELIM;
        pdom.setProperty("org.eclipse.cdt.internal.core.index.fragment.id", id);
    }

    @Override
    public boolean isProjectIndexed(ICProject proj) {
        return !"org.eclipse.cdt.core.nullindexer".equals(this.getIndexerId(proj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIndexerSetupPostponed(ICProject proj) {
        List<IndexerSetupParticipant> list = this.fSetupParticipants;
        synchronized (list) {
            return this.fPostponedProjects.contains(proj);
        }
    }

    @Override
    public void update(ICElement[] tuSelection, int options) throws CoreException {
        Map<ICProject, List<ICElement>> projectsToElements = this.splitSelection(tuSelection);
        for (Map.Entry<ICProject, List<ICElement>> entry : projectsToElements.entrySet()) {
            ICProject project = entry.getKey();
            List<ICElement> filesAndFolders = entry.getValue();
            this.update(project, filesAndFolders, options);
        }
    }

    private Map<ICProject, List<ICElement>> splitSelection(ICElement[] tuSelection) {
        HashMap<ICProject, List<ICElement>> result = new HashMap<ICProject, List<ICElement>>();
        int i = 0;
        while (i < tuSelection.length) {
            block5: {
                ICElement element = tuSelection[i];
                if (element instanceof ICProject || element instanceof ICContainer || element instanceof ITranslationUnit) {
                    ICProject project = element.getCProject();
                    List<ICElement> set = result.get(project);
                    if (set == null) {
                        set = new ArrayList<ICElement>();
                        result.put(project, set);
                    }
                    int j = 0;
                    while (j < set.size()) {
                        ICElement other = set.get(j);
                        if (this.contains(other, element)) break block5;
                        if (this.contains(element, other)) {
                            set.set(j, element);
                            break block5;
                        }
                        ++j;
                    }
                    set.add(element);
                }
            }
            ++i;
        }
        return result;
    }

    private boolean contains(ICElement a, ICElement b) {
        if (a.equals(b)) {
            return true;
        }
        if ((b = b.getParent()) == null) {
            return false;
        }
        return this.contains(a, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ICProject project, List<ICElement> filesAndFolders, int options) throws CoreException {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        Map<ICProject, IndexUpdatePolicy> map = this.fUpdatePolicies;
        synchronized (map) {
            IIndexFileLocation ifl;
            ITranslationUnit tu;
            if ((options & 0x20) != 0) {
                for (ICElement element : filesAndFolders) {
                    if (!(element instanceof ITranslationUnit)) continue;
                    tu = (ITranslationUnit)element;
                    ifl = IndexLocationFactory.getIFL(tu);
                    this.fFilesIndexedUnconditionlly.add(ifl);
                }
            }
            if ((options & 0x40) != 0) {
                for (ICElement element : filesAndFolders) {
                    if (!(element instanceof ITranslationUnit)) continue;
                    tu = (ITranslationUnit)element;
                    ifl = IndexLocationFactory.getIFL(tu);
                    this.fFilesIndexedUnconditionlly.remove(ifl);
                }
            }
            IPDOMIndexer indexer = this.getIndexer(project);
            PDOMUpdateTask task = new PDOMUpdateTask(indexer, options);
            task.setTranslationUnitSelection(filesAndFolders);
            if (indexer != null) {
                this.enqueue(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePostBuildEvent() {
        assert (!Thread.holdsLock(this.fProjectToPDOM));
        Map<ICProject, IndexUpdatePolicy> map = this.fUpdatePolicies;
        synchronized (map) {
            for (IndexUpdatePolicy policy : this.fUpdatePolicies.values()) {
                IPDOMIndexerTask task = policy.createTask();
                if (task == null) continue;
                this.enqueue(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean postponeSetup(final ICProject cproject) {
        List<IndexerSetupParticipant> list = this.fSetupParticipants;
        synchronized (list) {
            IndexerSetupParticipant sp;
            Iterator<IndexerSetupParticipant> iterator = this.fSetupParticipants.iterator();
            do {
                if (iterator.hasNext()) continue;
                this.fPostponedProjects.remove(cproject);
                final IndexerSetupParticipant[] participants = this.fSetupParticipants.toArray(new IndexerSetupParticipant[this.fSetupParticipants.size()]);
                Runnable notify = new Runnable(){

                    @Override
                    public void run() {
                        IndexerSetupParticipant[] indexerSetupParticipantArray = participants;
                        int n = participants.length;
                        int n2 = 0;
                        while (n2 < n) {
                            final IndexerSetupParticipant p = indexerSetupParticipantArray[n2];
                            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                                public void handleException(Throwable exception) {
                                    CCorePlugin.log(exception);
                                }

                                public void run() throws Exception {
                                    p.onIndexerSetup(cproject);
                                }
                            });
                            ++n2;
                        }
                    }
                };
                this.scheduleNotification(notify);
                return false;
            } while (!(sp = iterator.next()).postponeIndexerSetup(cproject));
            this.fPostponedProjects.add(cproject);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyIndexerSetup(IndexerSetupParticipant participant, ICProject project) {
        if (this.fInShutDown) {
            return;
        }
        List<IndexerSetupParticipant> list = this.fSetupParticipants;
        synchronized (list) {
            if (this.fPostponedProjects.contains(project)) {
                this.setupProject(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndexerSetupParticipant(IndexerSetupParticipant participant) {
        List<IndexerSetupParticipant> list = this.fSetupParticipants;
        synchronized (list) {
            this.fSetupParticipants.add(participant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIndexerSetupParticipant(IndexerSetupParticipant participant) {
        List<IndexerSetupParticipant> list = this.fSetupParticipants;
        synchronized (list) {
            this.fSetupParticipants.remove(participant);
            for (ICProject project : this.fPostponedProjects) {
                this.setupProject(project);
            }
        }
    }

    public boolean isProjectRegistered(ICProject project) {
        return this.getIndexer(project) != null;
    }

    public boolean isProjectContentSynced(ICProject cproject) throws CoreException {
        IStatus s = this.getProjectContentSyncState(cproject);
        return s == null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus getProjectContentSyncState(ICProject cproject) throws CoreException {
        if (!"true".equals(IndexerPreferences.get(cproject.getProject(), "indexAllFiles", null))) {
            return null;
        }
        HashSet<ITranslationUnit> sources = new HashSet<ITranslationUnit>();
        cproject.accept(new TranslationUnitCollector(sources, null, (IProgressMonitor)new NullProgressMonitor()));
        MultiStatus syncStatus = null;
        try {
            IIndex index = this.getIndex(cproject);
            index.acquireReadLock();
            try {
                IIndexFileLocation location;
                ITranslationUnit tu;
                IResource resource;
                Iterator iterator = sources.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return null;
                } while (!((resource = (tu = (ITranslationUnit)iterator.next()).getResource()) instanceof IFile) || !this.isSubjectToIndexing(tu.getLanguage()) || (syncStatus = PDOMManager.areSynchronized(new HashSet<IIndexFileLocation>(), index, resource, location = IndexLocationFactory.getWorkspaceIFL((IFile)resource))) == null);
                MultiStatus multiStatus = syncStatus;
                return multiStatus;
            }
            finally {
                index.releaseReadLock();
            }
        }
        catch (InterruptedException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    private boolean isSubjectToIndexing(ILanguage language) {
        int linkageID = language.getLinkageID();
        int[] nArray = IDS_FOR_LINKAGES_TO_INDEX;
        int n = IDS_FOR_LINKAGES_TO_INDEX.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            if (linkageID == id) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static MultiStatus areSynchronized(Set<IIndexFileLocation> trail, IIndex index, IResource resource, IIndexFileLocation location) throws CoreException {
        if (!trail.contains(location)) {
            trail.add(location);
            IIndexFile[] files = index.getFiles(location);
            if (files.length <= 0) {
                return new MultiStatus("org.eclipse.cdt.core", 0, "No index file found for: " + location, null);
            }
            IIndexFile[] iIndexFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexInclude[] includes;
                IIndexFile file = iIndexFileArray[n2];
                long diff = resource.getLocalTimeStamp() - file.getTimestamp();
                if (diff != 0L) {
                    return new MultiStatus("org.eclipse.cdt.core", 0, "Index timestamp for '" + file.getLocation().getFullPath() + "' is " + diff + " msec older than " + location + "(" + SimpleDateFormat.getDateTimeInstance().format(new Date(resource.getLocalTimeStamp())) + ")", null);
                }
                IIndexInclude[] iIndexIncludeArray = includes = index.findIncludes(file);
                int n3 = includes.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFile newResource;
                    MultiStatus m;
                    String path;
                    IIndexInclude inc = iIndexIncludeArray[n4];
                    IIndexFileLocation newLocation = inc.getIncludesLocation();
                    if (newLocation != null && (path = newLocation.getFullPath()) != null && (m = PDOMManager.areSynchronized(trail, index, (IResource)(newResource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path))), newLocation)) != null) {
                        m.add((IStatus)new Status(1, "org.eclipse.cdt.core", "Included by " + file.getLocation().getFullPath()));
                        return m;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean isFileIndexedUnconditionally(IIndexFileLocation ifl) {
        return this.fFilesIndexedUnconditionlly.contains(ifl);
    }

    private final class PCL
    implements IEclipsePreferences.IPreferenceChangeListener {
        private ICProject fProject;

        public PCL(ICProject prj) {
            this.fProject = prj;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (this.fProject.getProject().isOpen()) {
                PDOMManager.this.onPreferenceChange(this.fProject, event);
            }
        }
    }
}

