/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPCompositeBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalParameterPack;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class LookupData
extends IScope.ScopeLookupData {
    public ICPPTemplateArgument[] fTemplateArguments;
    public Map<ICPPNamespaceScope, List<ICPPNamespaceScope>> usingDirectives = Collections.emptyMap();
    public ObjectSet<IScope> visited = new ObjectSet(1);
    public boolean contentAssist = false;
    public boolean typesOnly = false;
    public boolean usingDirectivesOnly = false;
    public boolean ignoreUsingDirectives = false;
    public boolean ignoreMembers = false;
    public boolean qualified = false;
    public boolean checkAssociatedScopes = false;
    public boolean forAssociatedScopes = false;
    public boolean forUsingDeclaration = false;
    public boolean argsContainImpliedObject = false;
    public boolean fNoNarrowing = false;
    private IASTDeclarator fDeclarator;
    private boolean fFunctionCall;
    private IType fImpliedObjectType;
    private ICPPEvaluation[] functionArgs;
    private IType[] functionArgTypes;
    private IASTExpression.ValueCategory[] functionArgValueCategories;
    public ICPPClassType skippedScope;
    public Object foundItems = null;
    public ProblemBinding problem;

    public LookupData(IASTName n) {
        super(n, true, false);
        if (n == null) {
            throw new IllegalArgumentException();
        }
        ICPPTemplateArgument[] args = null;
        if (n instanceof ICPPASTTemplateId) {
            try {
                args = CPPTemplates.createTemplateArgumentArray((ICPPASTTemplateId)n);
            }
            catch (DOMException e) {
                CCorePlugin.log(e);
            }
        }
        this.fTemplateArguments = args;
        this.configureWith(n);
    }

    public LookupData(char[] name, ICPPTemplateArgument[] templateArgs, IASTNode lookupPoint) {
        super(name, lookupPoint);
        this.fTemplateArguments = templateArgs;
    }

    @Override
    public CPPASTTranslationUnit getTranslationUnit() {
        return (CPPASTTranslationUnit)super.getTranslationUnit();
    }

    private void configureWith(IASTName name) {
        IASTNode parent;
        IASTName tn = name;
        if (tn.getPropertyInParent() == ICPPASTTemplateId.TEMPLATE_NAME) {
            tn = (IASTName)tn.getParent();
        }
        IASTNode nameParent = parent = tn.getParent();
        if (parent instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier || parent instanceof ICPPASTElaboratedTypeSpecifier || parent instanceof ICPPASTCompositeTypeSpecifier) {
            this.typesOnly = true;
        } else if (parent instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qn = (ICPPASTQualifiedName)parent;
            if (qn.getLastName() != tn) {
                if (!(tn instanceof ICPPASTTemplateId)) {
                    this.typesOnly = true;
                }
            } else {
                nameParent = parent.getParent();
            }
            IASTName[] names = qn.getNames();
            if (qn.isFullyQualified()) {
                this.qualified = true;
            } else if (names.length > 0 && names[0] != tn) {
                this.qualified = true;
            }
        }
        if (nameParent instanceof ICPPASTUsingDeclaration) {
            this.forUsingDeclaration = true;
        } else if (nameParent instanceof IASTDeclarator) {
            this.fDeclarator = (IASTDeclarator)nameParent;
        } else if (nameParent instanceof IASTFieldReference) {
            this.qualified = true;
        } else if (nameParent instanceof IASTIdExpression && nameParent.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME) {
            this.fFunctionCall = true;
        }
    }

    public IASTDeclaration forDeclaration() {
        IASTNode node = this.fDeclarator;
        while (node instanceof IASTDeclarator) {
            node = node.getParent();
        }
        if (node instanceof IASTSimpleDeclaration || node instanceof IASTFunctionDefinition) {
            return (IASTDeclaration)node;
        }
        return null;
    }

    public IASTDeclarator getDeclarator() {
        return this.fDeclarator;
    }

    public boolean forExplicitFunctionSpecialization() {
        IASTName n = this.getLookupName();
        if (n == null) {
            return false;
        }
        IASTDeclaration decl = this.forDeclaration();
        if (decl != null) {
            if (n.getParent() instanceof ICPPASTTemplateId) {
                n = (IASTName)n.getParent();
            }
            ICPPASTTemplateDeclaration tmplDecl = CPPTemplates.getTemplateDeclaration(n);
            return tmplDecl instanceof ICPPASTTemplateSpecialization;
        }
        return false;
    }

    public boolean forExplicitFunctionInstantiation() {
        IASTDeclaration decl = this.forDeclaration();
        return decl != null && decl.getParent() instanceof ICPPASTExplicitTemplateInstantiation;
    }

    public boolean isFunctionCall() {
        return this.fFunctionCall;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkWholeClassScope(IASTName name) {
        if (name == null) {
            return true;
        }
        node = name.getParent();
        while (node instanceof IASTName) {
            name = (IASTName)node;
            node = name.getParent();
        }
        nameProp = name.getPropertyInParent();
        if (nameProp == IASTIdExpression.ID_NAME || nameProp == IASTFieldReference.FIELD_NAME || nameProp == ICASTFieldDesignator.FIELD_NAME || nameProp == ICPPASTUsingDirective.QUALIFIED_NAME || nameProp == ICPPASTUsingDeclaration.NAME || nameProp == IASTFunctionCallExpression.FUNCTION_NAME || nameProp == IASTNamedTypeSpecifier.NAME || nameProp == ICPPASTConstructorChainInitializer.MEMBER_ID) ** GOTO lbl38
        return false;
lbl-1000:
        // 1 sources

        {
            if (node.getParent() instanceof IASTFunctionDefinition) {
                prop = node.getPropertyInParent();
                if (prop == IASTFunctionDefinition.DECL_SPECIFIER || prop == IASTFunctionDefinition.DECLARATOR) {
                    return false;
                }
                parent = node.getParent();
                while (parent != null) {
                    if (parent instanceof ICPPASTCompositeTypeSpecifier) {
                        return true;
                    }
                    parent = parent.getParent();
                }
                return false;
            }
            if ((node instanceof IASTInitializerList || node instanceof IASTEqualsInitializer) && node.getPropertyInParent() == IASTDeclarator.INITIALIZER) {
                decl = node.getParent();
                while (decl instanceof IASTDeclarator) {
                    decl = decl.getParent();
                }
                if (decl instanceof IASTParameterDeclaration) {
                    parent = decl.getParent();
                    while (parent != null) {
                        if (parent instanceof ICPPASTCompositeTypeSpecifier) {
                            return true;
                        }
                        parent = parent.getParent();
                    }
                    return false;
                }
                if (decl instanceof IASTSimpleDeclaration && decl.getPropertyInParent() == IASTCompositeTypeSpecifier.MEMBER_DECLARATION && (declSpec = ((IASTSimpleDeclaration)decl).getDeclSpecifier()).getStorageClass() != 3) {
                    return true;
                }
            }
            node = node.getParent();
lbl38:
            // 2 sources

            ** while (node != null)
        }
lbl39:
        // 1 sources

        return false;
    }

    public static boolean typesOnly(IASTName tn) {
        ICPPASTQualifiedName qn;
        IASTNode parent;
        if (tn.getPropertyInParent() == ICPPASTTemplateId.TEMPLATE_NAME) {
            tn = (IASTName)tn.getParent();
        }
        if ((parent = tn.getParent()) instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier || parent instanceof ICPPASTElaboratedTypeSpecifier || parent instanceof ICPPASTCompositeTypeSpecifier) {
            return true;
        }
        return parent instanceof ICPPASTQualifiedName && (qn = (ICPPASTQualifiedName)parent).getLastName() != tn;
    }

    public boolean hasResultOrProblem() {
        return this.problem != null || this.hasResults();
    }

    public boolean hasResults() {
        if (this.foundItems == null) {
            return false;
        }
        if (this.foundItems instanceof Object[]) {
            return ((Object[])this.foundItems).length != 0;
        }
        if (this.foundItems instanceof CharArrayObjectMap) {
            return ((CharArrayObjectMap)this.foundItems).size() != 0;
        }
        return false;
    }

    public boolean hasTypeOrMemberFunctionOrVariableResult() {
        if (this.foundItems == null) {
            return false;
        }
        if (this.foundItems instanceof Object[]) {
            Object[] objectArray = (Object[])this.foundItems;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof ICPPMethod || item instanceof IType || item instanceof IVariable) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public IType getImpliedObjectType() {
        if (this.fImpliedObjectType == null) {
            this.fImpliedObjectType = this.determineImpliedObjectType();
        }
        return this.fImpliedObjectType;
    }

    public void setImpliedObjectType(IType impliedObjectType) {
        this.fImpliedObjectType = impliedObjectType;
    }

    private IType determineImpliedObjectType() {
        ICPPASTQualifiedName qn;
        IASTNode parent;
        IASTName tn = this.getLookupName();
        if (tn == null) {
            return null;
        }
        if (tn.getPropertyInParent() == ICPPASTTemplateId.TEMPLATE_NAME) {
            tn = (IASTName)tn.getParent();
        }
        IASTNode nameParent = parent = tn.getParent();
        if (parent instanceof ICPPASTQualifiedName && (qn = (ICPPASTQualifiedName)parent).getLastName() == tn) {
            nameParent = parent.getParent();
        }
        if (nameParent instanceof IASTFieldReference) {
            return ((ICPPASTFieldReference)nameParent).getFieldOwnerType();
        }
        if (nameParent instanceof IASTIdExpression && nameParent.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME) {
            IScope scope = CPPVisitor.getContainingScope(nameParent);
            if (scope instanceof ICPPClassScope) {
                return ((ICPPClassScope)scope).getClassType();
            }
            return CPPVisitor.getImpliedObjectType(scope);
        }
        return null;
    }

    public boolean forFriendship() {
        IASTName lookupName = this.getLookupName();
        if (lookupName == null) {
            return false;
        }
        IASTNode node = lookupName.getParent();
        while (node instanceof IASTName) {
            node = node.getParent();
        }
        IASTDeclaration decl = null;
        IASTDeclarator dtor = null;
        if (node instanceof ICPPASTDeclSpecifier && node.getParent() instanceof IASTDeclaration) {
            decl = (IASTDeclaration)node.getParent();
        } else if (node instanceof IASTDeclarator) {
            dtor = (IASTDeclarator)node;
            while (dtor.getParent() instanceof IASTDeclarator) {
                dtor = (IASTDeclarator)dtor.getParent();
            }
            if (!(dtor.getParent() instanceof IASTDeclaration)) {
                return false;
            }
            decl = (IASTDeclaration)dtor.getParent();
        } else {
            return false;
        }
        if (decl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simple = (IASTSimpleDeclaration)decl;
            if (!((ICPPASTDeclSpecifier)simple.getDeclSpecifier()).isFriend()) {
                return false;
            }
            if (dtor != null) {
                return true;
            }
            return simple.getDeclarators().length == 0;
        }
        if (decl instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition fnDef = (IASTFunctionDefinition)decl;
            if (!((ICPPASTDeclSpecifier)fnDef.getDeclSpecifier()).isFriend()) {
                return false;
            }
            return dtor != null;
        }
        return false;
    }

    public boolean checkAssociatedScopes() {
        return !this.qualified && this.fFunctionCall;
    }

    public boolean checkClassContainingFriend() {
        IASTName lookupName = this.getLookupName();
        if (lookupName == null || lookupName instanceof ICPPASTQualifiedName) {
            return false;
        }
        IASTNode p = lookupName.getParent();
        ASTNodeProperty prop = null;
        while (p != null) {
            prop = p.getPropertyInParent();
            if (prop == ICPPASTTemplateId.TEMPLATE_ID_ARGUMENT || prop == IASTDeclarator.DECLARATOR_NAME) {
                return false;
            }
            if (p instanceof IASTDeclarator && !(((IASTDeclarator)p).getName() instanceof ICPPASTQualifiedName)) {
                return false;
            }
            if (p instanceof IASTDeclaration) {
                if (prop == IASTCompositeTypeSpecifier.MEMBER_DECLARATION) {
                    return CPPVisitor.isFriendDeclaration(p);
                }
                return false;
            }
            p = p.getParent();
        }
        return false;
    }

    public void setFunctionArguments(boolean containsImpliedObject, ICPPEvaluation ... exprs) {
        this.argsContainImpliedObject = containsImpliedObject;
        this.functionArgs = exprs;
    }

    public void setFunctionArguments(boolean containsImpliedObject, IASTInitializerClause ... exprs) {
        ICPPEvaluation[] evals = new ICPPEvaluation[exprs.length];
        int i = 0;
        while (i < evals.length) {
            evals[i] = ((ICPPASTInitializerClause)exprs[i]).getEvaluation();
            ++i;
        }
        this.setFunctionArguments(containsImpliedObject, evals);
    }

    public IType[] getFunctionArgumentTypes() {
        if (this.functionArgTypes == null && this.functionArgs != null) {
            ICPPEvaluation[] exprs = this.functionArgs;
            this.functionArgTypes = new IType[exprs.length];
            int i = 0;
            while (i < exprs.length) {
                ICPPEvaluation e = exprs[i];
                this.functionArgTypes[i] = SemanticUtil.getSimplifiedType(e.getTypeOrFunctionSet(this.getLookupPoint()));
                ++i;
            }
        }
        return this.functionArgTypes;
    }

    public IASTExpression.ValueCategory[] getFunctionArgumentValueCategories() {
        ICPPEvaluation[] args;
        if (this.functionArgValueCategories == null && (args = this.functionArgs) != null) {
            this.functionArgValueCategories = new IASTExpression.ValueCategory[args.length];
            int i = 0;
            while (i < args.length) {
                ICPPEvaluation arg = args[i];
                this.functionArgValueCategories[i] = arg.getValueCategory(this.getLookupPoint());
                ++i;
            }
        }
        return this.functionArgValueCategories;
    }

    public int getFunctionArgumentCount() {
        if (this.functionArgs != null) {
            return this.functionArgs.length;
        }
        return 0;
    }

    public int getFunctionArgumentPackExpansionCount() {
        int count = 0;
        if (this.functionArgs != null) {
            ICPPEvaluation[] iCPPEvaluationArray = this.functionArgs;
            int n = this.functionArgs.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPEvaluation arg = iCPPEvaluationArray[n2];
                if (arg instanceof EvalParameterPack) {
                    ++count;
                }
                ++n2;
            }
        }
        return count;
    }

    public boolean hasFunctionArguments() {
        return this.functionArgs != null;
    }

    public IBinding[] getFoundBindings() {
        Object[] items;
        if (this.foundItems instanceof Object[] && (items = (Object[])this.foundItems).length != 0) {
            IBinding[] bindings = new IBinding[items.length];
            int k = 0;
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof IBinding && !(item instanceof ICPPUsingDeclaration) && !(item instanceof CPPCompositeBinding)) {
                    bindings[k++] = (IBinding)item;
                }
                ++n2;
            }
            if (k != 0) {
                return ArrayUtil.trimAt(IBinding.class, bindings, k - 1);
            }
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public boolean ignoreRecursionResolvingBindings() {
        return this.getLookupName() == null;
    }
}

