/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalNameOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBaseDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;

public class CPPASTElaboratedTypeSpecifier
extends CPPASTBaseDeclSpecifier
implements ICPPASTElaboratedTypeSpecifier,
IASTInternalNameOwner {
    private int kind;
    private IASTName name;

    public CPPASTElaboratedTypeSpecifier() {
    }

    public CPPASTElaboratedTypeSpecifier(int kind, IASTName name) {
        this.kind = kind;
        this.setName(name);
    }

    @Override
    public CPPASTElaboratedTypeSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTElaboratedTypeSpecifier copy(IASTNode.CopyStyle style) {
        CPPASTElaboratedTypeSpecifier copy = new CPPASTElaboratedTypeSpecifier(this.kind, this.name == null ? null : this.name.copy(style));
        return super.copy(copy, style);
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    public void setKind(int value) {
        this.assertNotFrozen();
        this.kind = value;
    }

    @Override
    public IASTName getName() {
        return this.name;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(TYPE_NAME);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleForName(IASTName n) {
        return this.getRoleForName(n, true);
    }

    @Override
    public int getRoleForName(IASTName n, boolean allowResolution) {
        IASTDeclarator[] dtors;
        if (n != this.name) {
            return 3;
        }
        IASTNode parent = this.getParent();
        if (parent instanceof IASTSimpleDeclaration && (dtors = ((IASTSimpleDeclaration)parent).getDeclarators()).length == 0) {
            return 0;
        }
        int kind = this.getKind();
        if (!(kind != 3 && kind != 2 && kind != 1 || this.name instanceof ICPPASTQualifiedName || this.name instanceof ICPPASTTemplateId)) {
            IBinding binding;
            IBinding iBinding = binding = allowResolution ? this.name.resolveBinding() : this.name.getBinding();
            if (binding != null) {
                IASTNode[] decls;
                if (binding instanceof ICPPInternalBinding && ArrayUtil.contains(decls = ((ICPPInternalBinding)binding).getDeclarations(), this.name)) {
                    return 0;
                }
                return 1;
            }
            return 3;
        }
        return 1;
    }
}

