/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateInfo;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class TemplateEngineHelper {
    public static final String US = "_";
    public static final String OPEN_MARKER = "$(";
    public static final String CLOSE_MARKER = ")";
    public static final String STRING_EXTERNALIZATION_MARKER = "%";
    public static final String LOGGER_FILE_NAME = "Process";
    public static final String PROJRESOURCE = "plugin.xml";
    public static final String PLUGIN_ID = "pluginId";
    public static final String PLUGIN_PROPERTIES = "plugin.properties";
    public static final String TEMPLATE_PROPERTIES = "template.properties";
    public static final String BOOLTRUE = "true";
    public static final String ID = "id";
    public static final String VALUE = "value";
    public static final String SDLOG_FILE_NAME = "sharedDefaults";
    public static final String LOCATION = "location";
    public static final String WIZARD_ID = "wizardId";
    public static final String FILTER_PATTERN = "filterPattern";
    public static final String USAGE_DESCRIPTION = "usageDescription";
    public static final String PROJECT_TYPE = "projectType";
    public static final String TOOL_CHAIN = "toolChain";
    public static final String EXTRA_PAGES_PROVIDER = "pagesAfterTemplateSelectionProvider";
    public static final String IS_CATEGORY = "isCategory";

    public static File getSharedDefaultLocation(String sharedLocation) {
        File sharedXMLFile = TemplateEngineHelper.findLocation(sharedLocation);
        return sharedXMLFile;
    }

    private static File findLocation(String fileLocation) {
        CCorePlugin plugin = CCorePlugin.getDefault();
        IPath stateLoc = plugin.getStateLocation();
        fileLocation = String.valueOf(stateLoc.toString()) + File.separator + fileLocation;
        File file = new File(fileLocation);
        return file;
    }

    public static File storeSharedDefaultLocation(String sharedLocation) {
        File sharedXMLFile = TemplateEngineHelper.findLocation(sharedLocation);
        try {
            if (!sharedXMLFile.exists()) {
                sharedXMLFile.createNewFile();
            }
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
        return sharedXMLFile;
    }

    public static IPath getWorkspacePath() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        Path workSpacePath = new Path(String.valueOf(root.getLocation().toString()) + File.separator);
        return workSpacePath;
    }

    public static String getFirstMarkerID(String markerString) {
        String key = null;
        if (markerString.indexOf(OPEN_MARKER) != -1) {
            key = markerString.substring(markerString.indexOf(OPEN_MARKER) + OPEN_MARKER.length(), markerString.indexOf(CLOSE_MARKER));
        }
        return key;
    }

    public static boolean checkDirectoryInWorkspace(String directoryName) {
        boolean retVal = false;
        File file = null;
        try {
            file = new File(TemplateEngineHelper.getWorkspacePath() + directoryName);
        }
        catch (Exception exception) {}
        if (file != null && file.exists() && file.isDirectory()) {
            retVal = true;
        }
        return retVal;
    }

    public static URL getTemplateResourceURL(String pluginId, String resourcePath) throws IOException {
        return FileLocator.find((Bundle)Platform.getBundle((String)pluginId), (IPath)new Path(resourcePath), null);
    }

    public static URL getTemplateResourceURLRelativeToTemplate(TemplateCore template, String resourcePath) throws IOException {
        TemplateInfo templateInfo = template.getTemplateInfo();
        String path = templateInfo.getTemplatePath();
        int slash = path.lastIndexOf("/");
        path = slash == -1 ? resourcePath : String.valueOf(path.substring(0, slash + 1)) + resourcePath;
        URL entry = FileLocator.find((Bundle)Platform.getBundle((String)templateInfo.getPluginId()), (IPath)new Path(path), null);
        if (entry == null) {
            return null;
        }
        return FileLocator.toFileURL((URL)entry);
    }

    public static String externalizeTemplateString(TemplateInfo ti, String key) {
        if (key.startsWith(STRING_EXTERNALIZATION_MARKER)) {
            String pluginId = ti.getPluginId();
            String path = ti.getTemplatePath();
            Path p = new Path(path);
            String propertiesPath = TEMPLATE_PROPERTIES;
            if (p.segmentCount() != 0) {
                p = p.removeLastSegments(1);
                propertiesPath = p.append(propertiesPath).toString();
            }
            return TemplateEngineHelper.externalizeTemplateString(pluginId, propertiesPath, key);
        }
        return key;
    }

    public static String externalizeTemplateString(String pluginId, String location, String key) {
        String value = null;
        if (key != null && key.startsWith(STRING_EXTERNALIZATION_MARKER)) {
            try {
                String string = value = location != null ? TemplateEngineHelper.getValueFromProperties(pluginId, location, key.substring(1)) : null;
                if (value == null) {
                    value = TemplateEngineHelper.getValueFromProperties(pluginId, PLUGIN_PROPERTIES, key.substring(1));
                }
            }
            catch (IOException e) {
                value = key;
                e.printStackTrace();
            }
        }
        return value == null ? key : value;
    }

    private static String getValueFromProperties(String pluginId, String propertiesFile, String key) throws IOException {
        String value = null;
        Bundle b = Platform.getBundle((String)pluginId);
        URL url = TemplateEngineHelper.getResourceURL(b, propertiesFile);
        if (url != null) {
            InputStream in = url.openStream();
            Properties p = new Properties();
            p.load(in);
            value = (String)p.get(key);
        }
        return value;
    }

    private static URL getResourceURL(Bundle bundle, String propertiesFile) {
        return FileLocator.find((Bundle)bundle, (IPath)new Path(propertiesFile), null);
    }
}

