/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.piechart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.dataviewers.piechart.IColorsConstants;
import org.eclipse.linuxtools.dataviewers.piechart.PieChartPaintListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.swtchart.Chart;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;

public class PieChart
extends Chart {
    protected List<RGB> colorList = new ArrayList<RGB>();

    public PieChart(Composite parent, int style) {
        super(parent, style);
        Control plotArea = null;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getClass().getName().equals("org.swtchart.internal.axis.AxisTitle")) {
                child.setVisible(false);
            } else if (child.getClass().getName().equals("org.swtchart.internal.PlotArea")) {
                child.setVisible(false);
                plotArea = child;
            }
            ++n2;
        }
        this.addPaintListener(new PieChartPaintListener(this, plotArea));
    }

    public void addPaintListener(PaintListener listener) {
        if (!listener.getClass().getName().startsWith("org.swtchart.internal.axis")) {
            super.addPaintListener(listener);
        }
    }

    public void addPieChartSeries(String[] labels, double[] val) {
        ISeries[] iSeriesArray = this.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries s = iSeriesArray[n2];
            this.getSeriesSet().deleteSeries(s.getId());
            ++n2;
        }
        double[][] newVal = new double[val.length][1];
        int i = 0;
        while (i < val.length) {
            newVal[i][0] = val[i];
            ++i;
        }
        this.addPieChartSeries(labels, newVal);
    }

    public void addPieChartSeries(String[] labels, double[][] val) {
        ISeries[] iSeriesArray = this.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries s = iSeriesArray[n2];
            this.getSeriesSet().deleteSeries(s.getId());
            ++n2;
        }
        int size = Math.min(labels.length, val.length);
        int i = 0;
        while (i < size) {
            IBarSeries s = (IBarSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.BAR, labels[i]);
            double[] d = new double[val[i].length];
            int j = 0;
            while (j < val[i].length) {
                d[j] = val[i][j];
                ++j;
            }
            s.setXSeries(d);
            s.setBarColor(new Color((Device)this.getDisplay(), this.sliceColor(i)));
            ++i;
        }
    }

    protected RGB sliceColor(int i) {
        RGB next;
        if (this.colorList.size() > i) {
            return this.colorList.get(i);
        }
        if (this.colorList.size() < IColorsConstants.COLORS.length) {
            next = IColorsConstants.COLORS[i];
        } else {
            RGB prev = this.colorList.get(this.colorList.size() - 1);
            int mod = 192;
            int red = (int)((double)mod * Math.random());
            int green = (int)((double)(mod - red) * Math.random());
            int blue = mod - red - green;
            next = new RGB(0, 0, 0);
            next.red = (prev.red + red) % 256;
            next.green = (prev.green + green) % 256;
            next.blue = (prev.blue + blue) % 256;
        }
        this.colorList.add(next);
        return next;
    }
}

