/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.tasks.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContextManager;
import org.eclipse.mylyn.internal.context.tasks.ui.ActivityExternalizationParticipant;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.externalization.ExternalizationManager;
import org.eclipse.mylyn.internal.tasks.core.externalization.IExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.ITaskActivityManager;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.core.activity.AbstractTaskActivityMonitor;

public class TaskActivityMonitor
extends AbstractTaskActivityMonitor {
    private final AbstractContextListener CONTEXT_LISTENER = new AbstractContextListener(){

        public void contextChanged(ContextChangeEvent event) {
            switch (event.getEventKind()) {
                case INTEREST_CHANGED: {
                    List events = TaskActivityMonitor.this.contextManager.getActivityMetaContext().getInteractionHistory();
                    if (events.size() <= 0) break;
                    InteractionEvent interactionEvent = (InteractionEvent)events.get(events.size() - 1);
                    TaskActivityMonitor.this.parseInteractionEvent(interactionEvent, false);
                }
            }
        }
    };
    private static ITaskActivationListener CONTEXT_TASK_ACTIVATION_LISTENER = new TaskActivationAdapter(){

        public void preTaskActivated(ITask task) {
            ContextUiPlugin.getDefault();
        }

        public void taskActivated(ITask task) {
            ContextCore.getContextManager().activateContext(task.getHandleIdentifier());
        }

        public void taskDeactivated(ITask task) {
            ContextCore.getContextManager().deactivateContext(task.getHandleIdentifier());
        }
    };
    private final InteractionContextManager contextManager = ContextCorePlugin.getContextManager();
    private TaskActivityManager taskActivityManager;
    private final TaskList taskList = TasksUiPlugin.getTaskList();
    private final List<ITask> activationHistory = new ArrayList<ITask>();
    private ActivityExternalizationParticipant externalizationParticipant;

    public void start(ITaskActivityManager taskActivityManager) {
        this.taskActivityManager = (TaskActivityManager)taskActivityManager;
        taskActivityManager.addActivationListener(CONTEXT_TASK_ACTIVATION_LISTENER);
        this.contextManager.addActivityMetaContextListener(this.CONTEXT_LISTENER);
        ExternalizationManager externalizationManager = TasksUiPlugin.getExternalizationManager();
        ActivityExternalizationParticipant ACTIVITY_EXTERNALIZTAION_PARTICIPANT = new ActivityExternalizationParticipant(externalizationManager);
        externalizationManager.addParticipant((IExternalizationParticipant)ACTIVITY_EXTERNALIZTAION_PARTICIPANT);
        taskActivityManager.addActivityListener((ITaskActivityListener)ACTIVITY_EXTERNALIZTAION_PARTICIPANT);
        this.setExternalizationParticipant(ACTIVITY_EXTERNALIZTAION_PARTICIPANT);
    }

    public boolean parseInteractionEvent(InteractionEvent event, boolean isReloading) {
        block13: {
            AbstractTask activatedTask;
            if (!event.getKind().equals((Object)InteractionEvent.Kind.COMMAND)) break block13;
            if (event.getDelta().equals("activated") && (activatedTask = this.taskList.getTask(event.getStructureHandle())) != null) {
                this.activationHistory.add((ITask)activatedTask);
                return true;
            }
        }
        try {
            if (event.getKind().equals((Object)InteractionEvent.Kind.ATTENTION)) {
                AbstractTask task;
                if (event.getDelta().equals("added") || event.getDelta().equals("add")) {
                    if (event.getDate().getTime() > 0L && event.getEndDate().getTime() > 0L) {
                        if (event.getStructureKind().equals("workingset")) {
                            this.taskActivityManager.addWorkingSetElapsedTime(event.getStructureHandle(), event.getDate(), event.getEndDate());
                            if (!isReloading) {
                                this.externalizationParticipant.setDirty(true);
                                this.externalizationParticipant.elapsedTimeUpdated(null, 0L);
                            }
                        } else {
                            AbstractTask activatedTask = this.taskList.getTask(event.getStructureHandle());
                            if (activatedTask != null) {
                                this.taskActivityManager.addElapsedTime(activatedTask, event.getDate(), event.getEndDate());
                            }
                        }
                    }
                } else if (event.getDelta().equals("removed") && (task = this.taskList.getTask(event.getStructureHandle())) != null) {
                    this.taskActivityManager.removeElapsedTime((ITask)task, event.getDate(), event.getEndDate());
                }
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error parsing interaction event", t));
        }
        return false;
    }

    public void stop() {
        this.contextManager.removeActivityMetaContextListener(this.CONTEXT_LISTENER);
    }

    public void reloadActivityTime() {
        this.activationHistory.clear();
        this.taskActivityManager.clearActivity();
        List events = this.contextManager.getActivityMetaContext().getInteractionHistory();
        for (InteractionEvent event : events) {
            this.parseInteractionEvent(event, true);
        }
    }

    public void setExternalizationParticipant(ActivityExternalizationParticipant participant) {
        this.externalizationParticipant = participant;
    }

    public List<ITask> getActivationHistory() {
        return new ArrayList<ITask>(this.activationHistory);
    }

    public void loadActivityTime() {
        ContextCorePlugin.getContextManager().loadActivityMetaContext();
        this.reloadActivityTime();
    }

    public boolean isEnabled() {
        return true;
    }
}

