/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.Hashtable;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMultiRunControl;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IRunControl2;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.GDBRunControl_7_0_NS;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GDBRunControl_7_2_NS
extends GDBRunControl_7_0_NS {
    private ICommandControlService fConnection;
    private CommandFactory fCommandFactory;
    private boolean fTraceVisualization;

    public GDBRunControl_7_2_NS(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                GDBRunControl_7_2_NS.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.register(new String[]{IRunControl.class.getName(), IRunControl2.class.getName(), IMIRunControl.class.getName(), IMultiRunControl.class.getName(), GDBRunControl_7_0_NS.class.getName(), GDBRunControl_7_2_NS.class.getName()}, new Hashtable());
        this.fConnection = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.getSession().addServiceEventListener((Object)this, null);
        rm.done();
    }

    @Override
    public void shutdown(RequestMonitor rm) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(rm);
    }

    protected boolean getTraceVisualization() {
        return this.fTraceVisualization;
    }

    protected void setTraceVisualization(boolean visualizing) {
        this.fTraceVisualization = visualizing;
    }

    @Override
    public void suspend(final IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        assert (context != null);
        IMIExecutionDMContext thread = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        IMIContainerDMContext container = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIContainerDMContext.class);
        if (thread == null && container == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Invalid context type.", null));
            rm.done();
            return;
        }
        this.canSuspend(context, (DataRequestMonitor<Boolean>)new ImmediateDataRequestMonitor<Boolean>(rm){

            protected void handleSuccess() {
                if (((Boolean)this.getData()).booleanValue()) {
                    GDBRunControl_7_2_NS.this.fConnection.queueCommand(GDBRunControl_7_2_NS.this.fCommandFactory.createMIExecInterrupt(context), new DataRequestMonitor((Executor)GDBRunControl_7_2_NS.this.getExecutor(), rm));
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Given context: " + context + ", is already suspended.", null));
                    rm.done();
                }
            }
        });
    }

    @Override
    public void resume(final IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        assert (context != null);
        final IMIExecutionDMContext thread = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        final IMIContainerDMContext container = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIContainerDMContext.class);
        if (thread == null && container == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Invalid context type.", null));
            rm.done();
            return;
        }
        this.canResume(context, (DataRequestMonitor<Boolean>)new ImmediateDataRequestMonitor<Boolean>(rm){

            protected void handleSuccess() {
                if (((Boolean)this.getData()).booleanValue()) {
                    if (thread != null) {
                        GDBRunControl_7_2_NS.this.doResume(thread, rm);
                        return;
                    }
                    if (container != null) {
                        GDBRunControl_7_2_NS.this.doResume(container, rm);
                        return;
                    }
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Given context: " + context + ", is already running.", null));
                    rm.done();
                }
            }
        });
    }

    private void doResume(IMIExecutionDMContext context, RequestMonitor rm) {
        final GDBRunControl_7_0_NS.MIThreadRunState threadState = (GDBRunControl_7_0_NS.MIThreadRunState)this.fThreadRunStates.get(context);
        if (threadState == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Given context: " + context + " can't be found.", null));
            rm.done();
            return;
        }
        threadState.fResumePending = true;
        this.fConnection.queueCommand(this.fCommandFactory.createMIExecContinue(context), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            protected void handleFailure() {
                threadState.fResumePending = false;
                super.handleFailure();
            }
        });
    }

    private void doResume(IMIContainerDMContext context, RequestMonitor rm) {
        this.fConnection.queueCommand(this.fCommandFactory.createMIExecContinue((IRunControl.IExecutionDMContext)context), new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    @Override
    @DsfServiceEventHandler
    public void eventDispatched(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent e) {
        this.setTraceVisualization(e.isVisualizationModeEnabled());
        this.setRunControlOperationsEnabled(!e.isVisualizationModeEnabled());
    }

    @Override
    protected void refreshThreadStates() {
        if (!this.getTraceVisualization()) {
            super.refreshThreadStates();
        }
    }
}

