/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.consolelog.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.systemtap.ui.consolelog.actions.ConsoleAction;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.ChartStreamDaemon;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.dataset.DataSetWizard;
import org.eclipse.linuxtools.systemtap.structures.listeners.IGobblerListener;
import org.eclipse.linuxtools.systemtap.structures.runnable.Command;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ChartStreamDaemon2;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.linuxtools.systemtap.ui.graphing.GraphingConstants;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ModifyParsingAction
extends ConsoleAction {
    public ModifyParsingAction(ScriptConsole fConsole) {
        super(fConsole, Platform.getBundle((String)"org.eclipse.linuxtools.systemtap.ui.consolelog").getEntry("icons/actions/regEx.gif"), Localization.getString("ModifyParsingAction_name"), Localization.getString("ModifyParsingAction_desc"));
    }

    public void run() {
        DataSetWizard wizard = new DataSetWizard(GraphingConstants.DataSetMetaData, this.console.getName());
        IWorkbench workbench = PlatformUI.getWorkbench();
        wizard.init(workbench, null);
        WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        IDataSetParser parser = wizard.getParser();
        IDataSet dataSet = wizard.getDataSet();
        if (parser != null && dataSet != null) {
            Command cmd = this.console.getCommand();
            ArrayList listeners = cmd.getInputStreamListeners();
            ChartStreamDaemon2 daemon = null;
            if (listeners != null) {
                int i = 0;
                while (i < listeners.size()) {
                    if (listeners.get(i) instanceof ChartStreamDaemon) {
                        daemon = (ChartStreamDaemon2)((Object)listeners.get(i));
                        break;
                    }
                    ++i;
                }
            }
            if (daemon == null) {
                daemon = new ChartStreamDaemon2(this.console, dataSet, parser);
                cmd.addInputStreamListener((IGobblerListener)daemon);
            } else {
                daemon.setParser(dataSet, parser);
            }
            IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditor");
            GraphSelectorEditor graphSelector = (GraphSelectorEditor)ivp;
            String name = this.console.getName();
            graphSelector.createScriptSet(name.substring(name.lastIndexOf(47) + 1), dataSet);
        }
        wizard.dispose();
    }
}

