/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.callgraph.core.Messages;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapParser;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;

public abstract class SystemTapView
extends ViewPart {
    private final String NEW_LINE = Messages.getString("SystemTapView.1");
    public Composite masterComposite;
    private IMenuManager help;
    private Action kill;
    protected String viewID;
    private Action helpVersion;
    protected Action saveFile;
    protected Action openFile;
    protected Action openDefault;
    protected String sourcePath;
    protected IMenuManager file;
    private SystemTapParser parser;

    public abstract IStatus initializeView(Display var1, IProgressMonitor var2);

    public void maximizeOrRefresh(boolean doMaximize) {
        IWorkbenchPage page = this.getViewSite().getWorkbenchWindow().getActivePage();
        if (doMaximize && page.getPartState(page.getActivePartReference()) != 1) {
            ActionFactory.IWorkbenchAction action = ActionFactory.MAXIMIZE.create(this.getViewSite().getWorkbenchWindow());
            action.run();
        } else {
            this.layout();
        }
    }

    public void layout() {
        this.masterComposite.layout();
    }

    public void maximizeIfUnmaximized() {
        IWorkbenchPage page = this.getViewSite().getWorkbenchWindow().getActivePage();
        if (page.getPartState(page.getActivePartReference()) != 1) {
            ActionFactory.IWorkbenchAction action = ActionFactory.MAXIMIZE.create(this.getViewSite().getWorkbenchWindow());
            action.run();
        }
    }

    public void update() throws InterruptedException {
        ViewUIUpdater updater = new ViewUIUpdater("SystemTapView.update");
        updater.schedule();
        updater.join();
    }

    public SystemTapParser getParser() {
        return this.parser;
    }

    public boolean setParser(SystemTapParser parser) {
        this.parser = parser;
        return this.parser != null;
    }

    public abstract void updateMethod();

    public abstract void setViewID();

    protected abstract boolean createOpenAction();

    protected abstract boolean createOpenDefaultAction();

    public void addFileMenu() {
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        if (this.file == null) {
            this.file = new MenuManager(Messages.getString("SystemTapView.FileMenu"));
            menu.add((IContributionItem)this.file);
        }
        if (this.createOpenAction()) {
            this.file.add((IAction)this.openFile);
        }
        if (this.createOpenDefaultAction()) {
            this.file.add((IAction)this.openDefault);
        }
        this.createSaveAction();
        this.file.add((IAction)this.saveFile);
    }

    public void addHelpMenu() {
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        this.help = new MenuManager(Messages.getString("SystemTapView.Help"));
        menu.add((IContributionItem)this.help);
        this.createHelpActions();
        this.help.add((IAction)this.helpVersion);
    }

    public void createHelpActions() {
        this.helpVersion = new Action(Messages.getString("SystemTapView.Version")){

            public void run() {
                try {
                    Process pr = RuntimeProcessFactory.getFactory().exec("stap -V", null);
                    BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
                    String line = "";
                    String message = "";
                    while ((line = buf.readLine()) != null) {
                        message = String.valueOf(message) + line + SystemTapView.this.NEW_LINE;
                    }
                    try {
                        pr.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Shell sh = new Shell();
                    MessageDialog.openInformation((Shell)sh, (String)Messages.getString("SystemTapView.StapVersion"), (String)message);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    protected void createSaveAction() {
        this.saveFile = new Action(Messages.getString("SystemTapView.SaveMenu")){

            public void run() {
                Shell sh = new Shell();
                FileDialog dialog = new FileDialog(sh, 8192);
                String filePath = dialog.open();
                if (filePath != null) {
                    SystemTapView.this.saveData(filePath);
                }
            }
        };
    }

    protected void addKillButton() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.kill = new Action(Messages.getString("SystemTapView.StopScript"), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.callgraph.core", (String)"icons/progress_stop.gif")){

            public void run() {
                SystemTapView.this.getParser().cancelJob();
            }
        };
        mgr.add((IAction)this.kill);
        this.setKillButtonEnabled(false);
    }

    public void setKillButtonEnabled(boolean val) {
        if (this.kill != null) {
            this.kill.setEnabled(val);
        }
    }

    public void saveData(String targetFile) {
        try {
            File file = new File(targetFile);
            file.delete();
            file.createNewFile();
            File sFile = new File(this.sourcePath);
            if (!sFile.exists()) {
                return;
            }
            FileChannel in = null;
            AbstractInterruptibleChannel out = null;
            try {
                in = new FileInputStream(sFile).getChannel();
                out = new FileOutputStream(file).getChannel();
                if (in == null || out == null) {
                    return;
                }
                long size = in.size();
                MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                ((FileChannel)out).write(buf);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSourcePath(String file) {
        this.sourcePath = file;
    }

    private class ViewUIUpdater
    extends UIJob {
        public ViewUIUpdater(String name) {
            super(name);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            SystemTapView.this.updateMethod();
            return Status.OK_STATUS;
        }
    }
}

