/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.event.metadata;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDeclaration;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.Messages;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.exceptions.ParseException;

public class DeclarationScope {
    private DeclarationScope parentScope = null;
    private final Map<String, StructDeclaration> structs = new HashMap<String, StructDeclaration>();
    private final Map<String, EnumDeclaration> enums = new HashMap<String, EnumDeclaration>();
    private final Map<String, VariantDeclaration> variants = new HashMap<String, VariantDeclaration>();
    private final Map<String, IDeclaration> types = new HashMap<String, IDeclaration>();

    public DeclarationScope() {
    }

    public DeclarationScope(DeclarationScope parentScope) {
        this.parentScope = parentScope;
    }

    public DeclarationScope getParentScope() {
        return this.parentScope;
    }

    public void registerType(String name, IDeclaration declaration) throws ParseException {
        if (this.types.containsKey(name)) {
            throw new ParseException(String.valueOf(Messages.TypeAlreadyDefined) + ':' + name);
        }
        this.types.put(name, declaration);
    }

    public void registerStruct(String name, StructDeclaration declaration) throws ParseException {
        if (this.structs.containsKey(name)) {
            throw new ParseException(String.valueOf(Messages.StructAlreadyDefined) + ':' + name);
        }
        this.structs.put(name, declaration);
        String structPrefix = "struct ";
        this.registerType(String.valueOf(structPrefix) + name, declaration);
    }

    public void registerEnum(String name, EnumDeclaration declaration) throws ParseException {
        if (this.lookupEnum(name) != null) {
            throw new ParseException(String.valueOf(Messages.EnumAlreadyDefined) + ':' + name);
        }
        this.enums.put(name, declaration);
        String enumPrefix = "enum ";
        this.registerType(String.valueOf(enumPrefix) + name, declaration);
    }

    public void registerVariant(String name, VariantDeclaration declaration) throws ParseException {
        if (this.lookupVariant(name) != null) {
            throw new ParseException(String.valueOf(Messages.VariantAlreadyDefined) + ':' + name);
        }
        this.variants.put(name, declaration);
        String variantPrefix = "variant ";
        this.registerType(String.valueOf(variantPrefix) + name, declaration);
    }

    public IDeclaration lookupType(String name) {
        return this.types.get(name);
    }

    public IDeclaration rlookupType(String name) {
        IDeclaration declaration = this.lookupType(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.parentScope != null) {
            return this.parentScope.rlookupType(name);
        }
        return null;
    }

    public StructDeclaration lookupStruct(String name) {
        return this.structs.get(name);
    }

    public StructDeclaration rlookupStruct(String name) {
        StructDeclaration declaration = this.lookupStruct(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.parentScope != null) {
            return this.parentScope.rlookupStruct(name);
        }
        return null;
    }

    public EnumDeclaration lookupEnum(String name) {
        return this.enums.get(name);
    }

    public EnumDeclaration rlookupEnum(String name) {
        EnumDeclaration declaration = this.lookupEnum(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.parentScope != null) {
            return this.parentScope.rlookupEnum(name);
        }
        return null;
    }

    public VariantDeclaration lookupVariant(String name) {
        return this.variants.get(name);
    }

    public VariantDeclaration rlookupVariant(String name) {
        VariantDeclaration declaration = this.lookupVariant(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.parentScope != null) {
            return this.parentScope.rlookupVariant(name);
        }
        return null;
    }

    public String[] getTypeNames() {
        String[] keys = new String[this.types.keySet().size()];
        return this.types.keySet().toArray(keys);
    }

    public void replaceType(String name, IDeclaration newType) throws ParseException {
        if (!this.types.containsKey(name)) {
            throw new ParseException(String.valueOf(Messages.TraceDoesNotContainType) + ':' + name);
        }
        this.types.put(name, newType);
    }
}

