/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.UUID;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.ctf.core.trace.Utils;
import org.eclipse.linuxtools.ctf.parser.CTFLexer;
import org.eclipse.linuxtools.ctf.parser.CTFParser;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.IOStructGen;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.exceptions.CtfAntlrException;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.exceptions.ParseException;

public class Metadata {
    private static final String METADATA_FILENAME = "metadata";
    private static final int METADATA_PACKET_HEADER_SIZE = 37;
    private File metadataFile = null;
    private ByteOrder detectedByteOrder = null;
    private CTFTrace trace = null;

    public Metadata(CTFTrace trace) {
        this.trace = trace;
        String metadataPath = String.valueOf(trace.getTraceDirectory().getPath()) + Utils.SEPARATOR + METADATA_FILENAME;
        this.metadataFile = new File(metadataPath);
    }

    public ByteOrder getDetectedByteOrder() {
        return this.detectedByteOrder;
    }

    public void parse() throws CTFReaderException {
        CTFReaderException tempException = null;
        FileInputStream fis = null;
        FileChannel metadataFileChannel = null;
        Reader metadataTextInput = null;
        try {
            fis = new FileInputStream(this.metadataFile);
            metadataFileChannel = fis.getChannel();
            if (this.isPacketBased(metadataFileChannel)) {
                StringBuffer metadataText = new StringBuffer();
                MetadataPacketHeader packetHeader = this.readMetadataPacket(metadataFileChannel, metadataText);
                while (packetHeader != null) {
                    packetHeader = this.readMetadataPacket(metadataFileChannel, metadataText);
                }
                metadataTextInput = new StringReader(metadataText.toString());
            } else {
                metadataTextInput = new FileReader(this.metadataFile);
            }
            CommonTree tree = Metadata.createAST(metadataTextInput);
            IOStructGen gen = new IOStructGen(tree, this.trace);
            gen.generate();
        }
        catch (FileNotFoundException fileNotFoundException) {
            tempException = new CTFReaderException("Cannot find metadata file!");
        }
        catch (IOException e) {
            tempException = new CTFReaderException(e);
        }
        catch (ParseException e) {
            tempException = new CTFReaderException(e);
        }
        catch (MismatchedTokenException e) {
            tempException = new CtfAntlrException(e);
        }
        catch (RecognitionException e) {
            tempException = new CtfAntlrException(e);
        }
        if (metadataTextInput != null) {
            try {
                metadataTextInput.close();
            }
            catch (IOException iOException) {}
        }
        if (metadataFileChannel != null) {
            try {
                metadataFileChannel.close();
            }
            catch (IOException iOException) {}
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        if (tempException != null) {
            throw tempException;
        }
    }

    private static CommonTree createAST(Reader metadataTextInput) throws IOException, RecognitionException {
        ANTLRReaderStream antlrStream = new ANTLRReaderStream(metadataTextInput);
        CTFLexer ctfLexer = new CTFLexer((CharStream)antlrStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)ctfLexer);
        CTFParser ctfParser = new CTFParser((TokenStream)tokens, false);
        CTFParser.parse_return pr = ctfParser.parse();
        return (CommonTree)pr.getTree();
    }

    private boolean isPacketBased(FileChannel metadataFileChannel) throws CTFReaderException {
        ByteBuffer magicByteBuffer = ByteBuffer.allocate(4);
        try {
            metadataFileChannel.read(magicByteBuffer, 0L);
        }
        catch (IOException e) {
            throw new CTFReaderException("Unable to read metadata file channel.", e);
        }
        int magic = magicByteBuffer.getInt(0);
        if (1976638807 == magic) {
            this.detectedByteOrder = ByteOrder.BIG_ENDIAN;
            return true;
        }
        magicByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        magic = magicByteBuffer.getInt(0);
        if (1976638807 == magic) {
            this.detectedByteOrder = ByteOrder.LITTLE_ENDIAN;
            return true;
        }
        return false;
    }

    private MetadataPacketHeader readMetadataPacket(FileChannel metadataFileChannel, StringBuffer metadataText) throws CTFReaderException {
        int nbBytesRead;
        ByteBuffer headerByteBuffer = ByteBuffer.allocate(37);
        try {
            nbBytesRead = metadataFileChannel.read(headerByteBuffer);
        }
        catch (IOException e) {
            throw new CTFReaderException("Error reading the metadata header.", e);
        }
        if (nbBytesRead < 0) {
            return null;
        }
        headerByteBuffer.position(0);
        headerByteBuffer.order(this.detectedByteOrder);
        assert (nbBytesRead == 37);
        MetadataPacketHeader header = new MetadataPacketHeader();
        header.magic = headerByteBuffer.getInt();
        headerByteBuffer.get(header.uuid);
        header.checksum = headerByteBuffer.getInt();
        header.contentSize = headerByteBuffer.getInt();
        header.packetSize = headerByteBuffer.getInt();
        header.compressionScheme = headerByteBuffer.get();
        header.encryptionScheme = headerByteBuffer.get();
        header.checksumScheme = headerByteBuffer.get();
        header.ctfMajorVersion = headerByteBuffer.get();
        header.ctfMinorVersion = headerByteBuffer.get();
        if (header.magic != 1976638807) {
            throw new CTFReaderException("TSDL magic number does not match");
        }
        UUID uuid = Utils.makeUUID(header.uuid);
        if (!this.trace.uuidIsSet()) {
            this.trace.setUUID(uuid);
        } else if (!this.trace.getUUID().equals(uuid)) {
            throw new CTFReaderException("UUID mismatch");
        }
        int payloadSize = header.contentSize / 8 - 37;
        if (payloadSize < 0) {
            throw new CTFReaderException("Invalid metadata packet payload size.");
        }
        int skipSize = (header.packetSize - header.contentSize) / 8;
        ByteBuffer payloadByteBuffer = ByteBuffer.allocateDirect(payloadSize + skipSize);
        try {
            metadataFileChannel.read(payloadByteBuffer);
        }
        catch (IOException e) {
            throw new CTFReaderException("Error reading metadata packet payload.", e);
        }
        payloadByteBuffer.rewind();
        byte[] payloadByteArray = new byte[payloadByteBuffer.remaining()];
        payloadByteBuffer.get(payloadByteArray, 0, payloadSize);
        String str = new String(payloadByteArray, 0, payloadSize);
        metadataText.append(str);
        return header;
    }

    private static class MetadataPacketHeader {
        public int magic;
        public byte[] uuid = new byte[16];
        public int checksum;
        public int contentSize;
        public int packetSize;
        public byte compressionScheme;
        public byte encryptionScheme;
        public byte checksumScheme;
        public byte ctfMajorVersion;
        public byte ctfMinorVersion;

        private MetadataPacketHeader() {
        }

        public String toString() {
            return "MetadataPacketHeader [magic=0x" + Integer.toHexString(this.magic) + ", uuid=" + Arrays.toString(this.uuid) + ", checksum=" + this.checksum + ", contentSize=" + this.contentSize + ", packetSize=" + this.packetSize + ", compressionScheme=" + this.compressionScheme + ", encryptionScheme=" + this.encryptionScheme + ", checksumScheme=" + this.checksumScheme + ", ctfMajorVersion=" + this.ctfMajorVersion + ", ctfMinorVersion=" + this.ctfMinorVersion + ']';
        }
    }
}

